/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOAuthValidator
implements OAuthValidator {
    public static final long DEFAULT_MAX_TIMESTAMP_AGE = 300000L;
    public static final long DEFAULT_TIMESTAMP_WINDOW = 300000L;
    private static Logger log = Logger.getLogger(SimpleOAuthValidator.class);
    public static final Set<String> SINGLE_PARAMETERS = SimpleOAuthValidator.constructSingleParameters();
    protected final double minVersion = 1.0;
    protected final double maxVersion;
    protected final long maxTimestampAgeMsec;
    private final Set<UsedNonce> usedNonces = new TreeSet<UsedNonce>();

    private static Set<String> constructSingleParameters() {
        HashSet<String> s = new HashSet<String>();
        String[] stringArray = new String[]{"oauth_consumer_key", "oauth_token", "oauth_token_secret", "oauth_callback", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_version"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            s.add(p);
            ++n2;
        }
        return Collections.unmodifiableSet(s);
    }

    public SimpleOAuthValidator() {
        this(300000L, Double.parseDouble("1.0"));
    }

    public SimpleOAuthValidator(long maxTimestampAgeMsec, double maxVersion) {
        this.maxTimestampAgeMsec = maxTimestampAgeMsec;
        this.maxVersion = maxVersion;
    }

    public Date releaseGarbage() {
        return this.removeOldNonces(this.currentTimeMsec());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date removeOldNonces(long currentTimeMsec) {
        UsedNonce next = null;
        UsedNonce min = new UsedNonce((currentTimeMsec - this.maxTimestampAgeMsec + 500L) / 1000L, new String[0]);
        Set<UsedNonce> set = this.usedNonces;
        synchronized (set) {
            Iterator<UsedNonce> iter = this.usedNonces.iterator();
            while (iter.hasNext()) {
                UsedNonce used = iter.next();
                if (min.compareTo(used) <= 0) {
                    next = used;
                    break;
                }
                iter.remove();
            }
        }
        if (next == null) {
            return null;
        }
        return new Date(next.getTimestamp() * 1000L + this.maxTimestampAgeMsec + 500L);
    }

    @Override
    public void validateMessage(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        this.checkSingleParameters(message);
        this.validateVersion(message);
        this.validateTimestampAndNonce(message);
        this.validateSignature(message, accessor);
    }

    protected void checkSingleParameters(OAuthMessage message) throws IOException, OAuthException {
        boolean repeated = false;
        HashMap<String, ArrayList<String>> nameToValues = new HashMap<String, ArrayList<String>>();
        for (Map.Entry parameter : message.getParameters()) {
            String name = (String)parameter.getKey();
            if (!SINGLE_PARAMETERS.contains(name)) continue;
            ArrayList<String> values = (ArrayList<String>)nameToValues.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                nameToValues.put(name, values);
            } else {
                repeated = true;
            }
            values.add((String)parameter.getValue());
        }
        if (repeated) {
            ArrayList<OAuth.Parameter> rejected = new ArrayList<OAuth.Parameter>();
            for (Map.Entry p : nameToValues.entrySet()) {
                String name = (String)p.getKey();
                Collection values = (Collection)p.getValue();
                if (values.size() <= 1) continue;
                for (String value : values) {
                    rejected.add(new OAuth.Parameter(name, value));
                }
            }
            OAuthProblemException problem = new OAuthProblemException("parameter_rejected");
            problem.setParameter("oauth_parameters_rejected", (Object)OAuth.formEncode(rejected));
            throw problem;
        }
    }

    protected void validateVersion(OAuthMessage message) throws OAuthException, IOException {
        double version;
        String versionString = message.getParameter("oauth_version");
        if (versionString != null && ((version = Double.parseDouble(versionString)) < 1.0 || this.maxVersion < version)) {
            log.debug((Object)("Error. oauth_version parameter (" + version + ") must be greater than minVersion=" + 1.0 + " and less than maxVersion=" + this.maxVersion));
            OAuthProblemException problem = new OAuthProblemException("version_rejected");
            problem.setParameter("oauth_acceptable_versions", (Object)("1.0-" + this.maxVersion));
            throw problem;
        }
    }

    protected void validateTimestampAndNonce(OAuthMessage message) throws IOException, OAuthProblemException {
        message.requireParameters(new String[]{"oauth_timestamp", "oauth_nonce"});
        long timestamp = Long.parseLong(message.getParameter("oauth_timestamp"));
        long now = this.currentTimeMsec();
        this.validateTimestamp(message, timestamp, now);
        this.validateNonce(message, timestamp, now);
    }

    protected void validateTimestamp(OAuthMessage message, long timestamp, long currentTimeMsec) throws IOException, OAuthProblemException {
        long min = (currentTimeMsec - this.maxTimestampAgeMsec + 500L) / 1000L;
        long max = (currentTimeMsec + this.maxTimestampAgeMsec + 500L) / 1000L;
        if (timestamp < min || max < timestamp) {
            log.debug((Object)("Error. oauth_timestamp parameter (" + timestamp + ") must be greater than min=" + min + " and less than max=" + max));
            OAuthProblemException problem = new OAuthProblemException("timestamp_refused");
            problem.setParameter("oauth_acceptable_timestamps", (Object)(String.valueOf(min) + "-" + max));
            throw problem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date validateNonce(OAuthMessage message, long timestamp, long currentTimeMsec) throws IOException, OAuthProblemException {
        UsedNonce nonce = new UsedNonce(timestamp, message.getParameter("oauth_nonce"), message.getConsumerKey(), message.getToken());
        boolean valid = false;
        Set<UsedNonce> set = this.usedNonces;
        synchronized (set) {
            valid = this.usedNonces.add(nonce);
        }
        if (!valid) {
            log.debug((Object)("Error. Set of usedNonces already contains newly constructed nonce (" + message.getParameter("oauth_nonce") + ")"));
            throw new OAuthProblemException("nonce_used");
        }
        return this.removeOldNonces(currentTimeMsec);
    }

    protected void validateSignature(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        message.requireParameters(new String[]{"oauth_consumer_key", "oauth_signature_method", "oauth_signature"});
        OAuthSignatureMethod.newSigner((OAuthMessage)message, (OAuthAccessor)accessor).validate(message);
    }

    protected long currentTimeMsec() {
        return System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UsedNonce
    implements Comparable<UsedNonce> {
        private final String sortKey;

        UsedNonce(long timestamp, String ... nonceEtc) {
            StringBuilder key = new StringBuilder(String.format("%20d", timestamp));
            for (String etc : nonceEtc) {
                key.append("&").append(etc == null ? " " : OAuth.percentEncode((String)etc));
            }
            this.sortKey = key.toString();
        }

        long getTimestamp() {
            int end = this.sortKey.indexOf("&");
            if (end < 0) {
                end = this.sortKey.length();
            }
            return Long.parseLong(this.sortKey.substring(0, end).trim());
        }

        @Override
        public int compareTo(UsedNonce that) {
            return that == null ? 1 : this.sortKey.compareTo(that.sortKey);
        }

        public int hashCode() {
            return this.sortKey.hashCode();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            if (that.getClass() != this.getClass()) {
                return false;
            }
            return this.sortKey.equals(((UsedNonce)that).sortKey);
        }

        public String toString() {
            return this.sortKey;
        }
    }
}

