/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DataConfiguration
extends AbstractConfiguration {
    public static final String DATE_FORMAT_KEY = "org.apache.commons.configuration.format.date";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected Configuration configuration;

    public DataConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    protected void addPropertyDirect(String key, Object obj) {
        this.configuration.addProperty(key, obj);
    }

    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public Iterator getKeys() {
        return this.configuration.getKeys();
    }

    public List getBooleanList(String key) {
        return this.getBooleanList(key, new ArrayList());
    }

    public List getBooleanList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Boolean> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof boolean[]) {
            list = new ArrayList<Boolean>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((boolean[])((boolean[])value)));
        } else if (value instanceof Boolean[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Boolean[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toBoolean(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toBoolean(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of booleans", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public boolean[] getBooleanArray(String key) {
        return this.getBooleanArray(key, new boolean[0]);
    }

    /*
     * WARNING - void declaration
     */
    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        void var4_4;
        boolean[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof boolean[]) {
            array = (boolean[])value;
        } else if (value instanceof Boolean[]) {
            array = ArrayUtils.toPrimitive((Boolean[])((Boolean[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new boolean[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toBoolean(it.next());
            }
        } else {
            try {
                array = new boolean[]{PropertyConverter.toBoolean(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of booleans", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getByteList(String key) {
        return this.getByteList(key, new ArrayList());
    }

    public List getByteList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Byte> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof byte[]) {
            list = new ArrayList<Byte>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((byte[])((byte[])value)));
        } else if (value instanceof Byte[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Byte[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toByte(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toByte(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of bytes", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public byte[] getByteArray(String key) {
        return this.getByteArray(key, new byte[0]);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getByteArray(String key, byte[] defaultValue) {
        void var4_4;
        byte[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof byte[]) {
            array = (byte[])value;
        } else if (value instanceof Byte[]) {
            array = ArrayUtils.toPrimitive((Byte[])((Byte[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new byte[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toByte(it.next());
            }
        } else {
            try {
                array = new byte[]{PropertyConverter.toByte(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of bytes", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getShortList(String key) {
        return this.getShortList(key, new ArrayList());
    }

    public List getShortList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Short> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof short[]) {
            list = new ArrayList<Short>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((short[])((short[])value)));
        } else if (value instanceof Short[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Short[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toShort(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toShort(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of shorts", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public short[] getShortArray(String key) {
        return this.getShortArray(key, new short[0]);
    }

    /*
     * WARNING - void declaration
     */
    public short[] getShortArray(String key, short[] defaultValue) {
        void var4_4;
        short[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof short[]) {
            array = (short[])value;
        } else if (value instanceof Short[]) {
            array = ArrayUtils.toPrimitive((Short[])((Short[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new short[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toShort(it.next());
            }
        } else {
            try {
                array = new short[]{PropertyConverter.toShort(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of shorts", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getIntegerList(String key) {
        return this.getIntegerList(key, new ArrayList());
    }

    public List getIntegerList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Integer> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof int[]) {
            list = new ArrayList<Integer>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((int[])((int[])value)));
        } else if (value instanceof Integer[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Integer[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toInteger(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toInteger(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of integers", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, new int[0]);
    }

    /*
     * WARNING - void declaration
     */
    public int[] getIntArray(String key, int[] defaultValue) {
        void var4_4;
        int[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof int[]) {
            array = (int[])value;
        } else if (value instanceof Integer[]) {
            array = ArrayUtils.toPrimitive((Integer[])((Integer[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new int[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toInteger(it.next());
            }
        } else {
            try {
                array = new int[]{PropertyConverter.toInteger(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of integers", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getLongList(String key) {
        return this.getLongList(key, new ArrayList());
    }

    public List getLongList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Long> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof long[]) {
            list = new ArrayList<Long>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((long[])((long[])value)));
        } else if (value instanceof Long[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Long[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toLong(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toLong(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of longs", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public long[] getLongArray(String key) {
        return this.getLongArray(key, new long[0]);
    }

    /*
     * WARNING - void declaration
     */
    public long[] getLongArray(String key, long[] defaultValue) {
        void var4_4;
        long[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof long[]) {
            array = (long[])value;
        } else if (value instanceof Long[]) {
            array = ArrayUtils.toPrimitive((Long[])((Long[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new long[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toLong(it.next());
            }
        } else {
            try {
                array = new long[]{PropertyConverter.toLong(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of longs", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getFloatList(String key) {
        return this.getFloatList(key, new ArrayList());
    }

    public List getFloatList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Float> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof float[]) {
            list = new ArrayList<Float>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((float[])((float[])value)));
        } else if (value instanceof Float[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Float[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toFloat(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toFloat(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of floats", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public float[] getFloatArray(String key) {
        return this.getFloatArray(key, new float[0]);
    }

    /*
     * WARNING - void declaration
     */
    public float[] getFloatArray(String key, float[] defaultValue) {
        void var4_4;
        float[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof float[]) {
            array = (float[])value;
        } else if (value instanceof Float[]) {
            array = ArrayUtils.toPrimitive((Float[])((Float[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new float[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toFloat(it.next()).floatValue();
            }
        } else {
            try {
                array = new float[]{PropertyConverter.toFloat(value).floatValue()};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of floats", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getDoubleList(String key) {
        return this.getDoubleList(key, new ArrayList());
    }

    public List getDoubleList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Double> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof double[]) {
            list = new ArrayList<Double>();
            CollectionUtils.addAll(list, (Object[])ArrayUtils.toObject((double[])((double[])value)));
        } else if (value instanceof Double[]) {
            list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])((Double[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toDouble(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toDouble(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of doubles", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public double[] getDoubleArray(String key) {
        return this.getDoubleArray(key, new double[0]);
    }

    /*
     * WARNING - void declaration
     */
    public double[] getDoubleArray(String key, double[] defaultValue) {
        void var4_4;
        double[] array;
        Object value = this.getProperty(key);
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            array = defaultValue;
        } else if (value instanceof double[]) {
            array = (double[])value;
        } else if (value instanceof Double[]) {
            array = ArrayUtils.toPrimitive((Double[])((Double[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            array = new double[values.size()];
            int i = 0;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                array[i++] = PropertyConverter.toDouble(it.next());
            }
        } else {
            try {
                array = new double[]{PropertyConverter.toDouble(value)};
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of doubles", (Throwable)((Object)e));
            }
        }
        return var4_4;
    }

    public List getBigIntegerList(String key) {
        return this.getBigIntegerList(key, new ArrayList());
    }

    public List getBigIntegerList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<BigInteger> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof BigInteger[]) {
            list = new ArrayList<BigInteger>();
            CollectionUtils.addAll(list, (Object[])((BigInteger[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toBigInteger(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toBigInteger(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of big integers", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public BigInteger[] getBigIntegerArray(String key) {
        return this.getBigIntegerArray(key, new BigInteger[0]);
    }

    public BigInteger[] getBigIntegerArray(String key, BigInteger[] defaultValue) {
        List list = this.getBigIntegerList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new BigInteger[list.size()]);
    }

    public List getBigDecimalList(String key) {
        return this.getBigDecimalList(key, new ArrayList());
    }

    public List getBigDecimalList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<BigDecimal> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof BigDecimal[]) {
            list = new ArrayList<BigDecimal>();
            CollectionUtils.addAll(list, (Object[])((BigDecimal[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toBigDecimal(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toBigDecimal(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of big decimals", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public BigDecimal[] getBigDecimalArray(String key) {
        return this.getBigDecimalArray(key, new BigDecimal[0]);
    }

    public BigDecimal[] getBigDecimalArray(String key, BigDecimal[] defaultValue) {
        List list = this.getBigDecimalList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new BigDecimal[list.size()]);
    }

    public URL getURL(String key) {
        return this.getURL(key, null);
    }

    public URL getURL(String key, URL defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toURL(value);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to an URL", (Throwable)((Object)e));
        }
    }

    public List getURLList(String key) {
        return this.getURLList(key, new ArrayList());
    }

    public List getURLList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<URL> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof URL[]) {
            list = new ArrayList<URL>();
            CollectionUtils.addAll(list, (Object[])((URL[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toURL(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toURL(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of URLs", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public URL[] getURLArray(String key) {
        return this.getURLArray(key, new URL[0]);
    }

    public URL[] getURLArray(String key, URL[] defaultValue) {
        List list = this.getURLList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new URL[list.size()]);
    }

    public Date getDate(String key) {
        return this.getDate(key, this.getDefaultDateFormat());
    }

    public Date getDate(String key, String format) {
        return this.getDate(key, null, format);
    }

    public Date getDate(String key, Date defaultValue) {
        return this.getDate(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date getDate(String key, Date defaultValue, String format) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDate(value, format);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Date", (Throwable)((Object)e));
        }
    }

    public List getDateList(String key) {
        return this.getDateList(key, new ArrayList());
    }

    public List getDateList(String key, String format) {
        return this.getDateList(key, new ArrayList(), format);
    }

    public List getDateList(String key, List defaultValue) {
        return this.getDateList(key, defaultValue, this.getDefaultDateFormat());
    }

    public List getDateList(String key, List defaultValue, String format) {
        Object value = this.getProperty(key);
        ArrayList<Date> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof Date[]) {
            list = new ArrayList<Date>();
            CollectionUtils.addAll(list, (Object[])((Date[])value));
        } else if (value instanceof Calendar[]) {
            list = new ArrayList();
            Calendar[] values = (Calendar[])value;
            for (int i = 0; i < values.length; ++i) {
                list.add(values[i].getTime());
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toDate(it.next(), format));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toDate(value, format));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Dates", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public Date[] getDateArray(String key) {
        return this.getDateArray(key, new Date[0]);
    }

    public Date[] getDateArray(String key, String format) {
        return this.getDateArray(key, new Date[0], format);
    }

    public Date[] getDateArray(String key, Date[] defaultValue) {
        return this.getDateArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date[] getDateArray(String key, Date[] defaultValue, String format) {
        List list = this.getDateList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Date[list.size()]);
    }

    public Calendar getCalendar(String key) {
        return this.getCalendar(key, this.getDefaultDateFormat());
    }

    public Calendar getCalendar(String key, String format) {
        return this.getCalendar(key, null, format);
    }

    public Calendar getCalendar(String key, Calendar defaultValue) {
        return this.getCalendar(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar getCalendar(String key, Calendar defaultValue, String format) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toCalendar(value, format);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Calendar", (Throwable)((Object)e));
        }
    }

    public List getCalendarList(String key) {
        return this.getCalendarList(key, new ArrayList());
    }

    public List getCalendarList(String key, String format) {
        return this.getCalendarList(key, new ArrayList(), format);
    }

    public List getCalendarList(String key, List defaultValue) {
        return this.getCalendarList(key, defaultValue, this.getDefaultDateFormat());
    }

    public List getCalendarList(String key, List defaultValue, String format) {
        Object value = this.getProperty(key);
        ArrayList<Calendar> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof Calendar[]) {
            list = new ArrayList<Calendar>();
            CollectionUtils.addAll(list, (Object[])((Calendar[])value));
        } else if (value instanceof Date[]) {
            list = new ArrayList();
            Date[] values = (Date[])value;
            for (int i = 0; i < values.length; ++i) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(values[i]);
                list.add(calendar);
            }
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toCalendar(it.next(), format));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toCalendar(value, format));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Calendars", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public Calendar[] getCalendarArray(String key) {
        return this.getCalendarArray(key, new Calendar[0]);
    }

    public Calendar[] getCalendarArray(String key, String format) {
        return this.getCalendarArray(key, new Calendar[0], format);
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue) {
        return this.getCalendarArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue, String format) {
        List list = this.getCalendarList(key, format);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Calendar[list.size()]);
    }

    private String getDefaultDateFormat() {
        return this.getString(DATE_FORMAT_KEY, DEFAULT_DATE_FORMAT);
    }

    public Locale getLocale(String key) {
        return this.getLocale(key, null);
    }

    public Locale getLocale(String key, Locale defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toLocale(value);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Locale", (Throwable)((Object)e));
        }
    }

    public List getLocaleList(String key) {
        return this.getLocaleList(key, new ArrayList());
    }

    public List getLocaleList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Locale> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof Locale[]) {
            list = new ArrayList<Locale>();
            CollectionUtils.addAll(list, (Object[])((Locale[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toLocale(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toLocale(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Locales", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public Locale[] getLocaleArray(String key) {
        return this.getLocaleArray(key, new Locale[0]);
    }

    public Locale[] getLocaleArray(String key, Locale[] defaultValue) {
        List list = this.getLocaleList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Locale[list.size()]);
    }

    public Color getColor(String key) {
        return this.getColor(key, null);
    }

    public Color getColor(String key, Color defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toColor(value);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Color", (Throwable)((Object)e));
        }
    }

    public List getColorList(String key) {
        return this.getColorList(key, new ArrayList());
    }

    public List getColorList(String key, List defaultValue) {
        Object value = this.getProperty(key);
        ArrayList<Color> list = null;
        if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            list = defaultValue;
        } else if (value instanceof Color[]) {
            list = new ArrayList<Color>();
            CollectionUtils.addAll(list, (Object[])((Color[])value));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            list = new ArrayList();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                list.add(PropertyConverter.toColor(it.next()));
            }
        } else {
            try {
                list = new ArrayList();
                list.add(PropertyConverter.toColor(value));
            }
            catch (ConversionException e) {
                throw new ConversionException('\'' + key + "' doesn't map to a list of Colors", (Throwable)((Object)e));
            }
        }
        return list;
    }

    public Color[] getColorArray(String key) {
        return this.getColorArray(key, new Color[0]);
    }

    public Color[] getColorArray(String key, Color[] defaultValue) {
        List list = this.getColorList(key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Color[list.size()]);
    }
}

