/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationDynaBean
implements DynaBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean == null ? (class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean = ConfigurationDynaBean.class$("org.apache.commons.configuration.beanutils.ConfigurationDynaBean")) : class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean));
    Configuration configuration;
    static /* synthetic */ Class class$org$apache$commons$configuration$beanutils$ConfigurationDynaBean;

    public ConfigurationDynaBean(Configuration configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("ConfigurationDynaBean(" + configuration + ")"));
        }
        this.configuration = configuration;
    }

    public void set(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("set(" + name + "," + value + ")"));
        }
        if (value == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value instanceof List) {
            List list = (List)value;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.configuration.addProperty(name, iterator.next());
            }
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Integer(array[i]));
            }
        } else if (value instanceof boolean[]) {
            boolean[] array = (boolean[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, BooleanUtils.toBooleanObject((boolean)array[i]));
            }
        } else if (value instanceof char[]) {
            char[] array = (char[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Character(array[i]));
            }
        } else if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Byte(array[i]));
            }
        } else if (value instanceof short[]) {
            short[] array = (short[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Short(array[i]));
            }
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Integer(array[i]));
            }
        } else if (value instanceof long[]) {
            long[] array = (long[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Long(array[i]));
            }
        } else if (value instanceof float[]) {
            float[] array = (float[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Float(array[i]));
            }
        } else if (value instanceof double[]) {
            double[] array = (double[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, new Double(array[i]));
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                this.configuration.addProperty(name, array[i]);
            }
        } else {
            this.configuration.setProperty(name, value);
        }
    }

    public Object get(String name) {
        Configuration subset;
        Object result;
        if (log.isTraceEnabled()) {
            log.trace((Object)("get(" + name + ")"));
        }
        if ((result = this.configuration.getProperty(name)) == null && !(subset = this.configuration.subset(name)).isEmpty()) {
            result = new ConfigurationDynaBean(this.configuration.subset(name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(name + "=[" + result + "]"));
        }
        if (result == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return result;
    }

    public boolean contains(String name, String key) {
        Configuration subset = this.configuration.subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name, int index) {
        try {
            List list = this.configuration.getList(name);
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Indexed property '" + name + "' does not exist.");
            }
            return list.get(index);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
    }

    public Object get(String name, String key) {
        Configuration subset = this.configuration.subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.configuration);
    }

    public void remove(String name, String key) {
        Configuration subset = this.configuration.subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        subset.setProperty(key, null);
    }

    public void set(String name, int index, Object value) {
        try {
            List list = this.configuration.getList(name);
            if (list == null) {
                throw new IllegalArgumentException("Property '" + name + "' does not exist.");
            }
            list.set(index, value);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
    }

    public void set(String name, String key, Object value) {
        this.configuration.setProperty(name + "." + key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

