/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.ws.java2wsdl.Java2OMBuilder;
import org.apache.ws.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.SchemaGenerator;

public class Java2WSDLBuilder {
    private OutputStream out;
    private String className;
    private ClassLoader classLoader;
    private String wsdlPrefix = "wsdl";
    private String serviceName = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String style = "document";
    private String use = "literal";
    private String locationUri = "http://localhost:8080/axis2/services/";

    public String getSchemaTargetNamespace() {
        return this.schemaTargetNamespace;
    }

    public String getStyle() {
        return this.style;
    }

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public String getSchemaTargetNamespacePrefix() {
        return this.schemaTargetNamespacePrefix;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getWsdlPrefix() {
        return this.wsdlPrefix;
    }

    public void setWsdlPrefix(String wsdlPrefix) {
        this.wsdlPrefix = wsdlPrefix;
    }

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader) {
        this.out = out;
        this.className = className;
        this.classLoader = classLoader;
    }

    public void generateWSDL() throws Exception {
        SchemaGenerator sg = new SchemaGenerator(this.classLoader, this.className, this.schemaTargetNamespace, this.schemaTargetNamespacePrefix);
        ArrayList<String> excludeOpeartion = new ArrayList<String>();
        excludeOpeartion.add("init");
        excludeOpeartion.add("setOperationContext");
        excludeOpeartion.add("destroy");
        sg.setExcludeMethods(excludeOpeartion);
        Collection schemaCollection = sg.generateSchema();
        Java2OMBuilder java2OMBuilder = new Java2OMBuilder(sg.getMethods(), schemaCollection, sg.getTypeTable(), this.serviceName == null ? Java2WSDLUtils.getSimpleClassName(this.className) : this.serviceName, this.targetNamespace == null ? Java2WSDLUtils.namespaceFromClassName(this.className, this.classLoader).toString() : this.targetNamespace, this.targetNamespacePrefix, this.style, this.use, this.locationUri);
        OMElement wsdlElemnet = java2OMBuilder.generateOM();
        wsdlElemnet.serialize(this.out);
        this.out.flush();
        this.out.close();
    }
}

