/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

public class Java2WSDLUtils {
    public static final String HTTP = "http://";
    public static final char PACKAGE_CLASS_DELIMITER = '.';
    public static final String SCHEMA_NAMESPACE_EXTN = "/xsd";

    public static boolean isURL(String entry) {
        return entry.startsWith(HTTP);
    }

    public static String getSimpleClassName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        if (index > 0) {
            return qualifiedName.substring(index + 1, qualifiedName.length());
        }
        return qualifiedName;
    }

    public static StringBuffer namespaceFromClassName(String className, ClassLoader classLoader) throws Exception {
        return Java2WSDLUtils.namespaceFromPackageName(Class.forName(className, true, classLoader).getPackage().getName());
    }

    public static StringBuffer namespaceFromPackageName(String packageName) {
        StringBuffer strBuf = new StringBuffer(HTTP);
        int prevIndex = packageName.length();
        int currentIndex = packageName.lastIndexOf(46);
        while (currentIndex != -1) {
            strBuf.append(packageName.substring(currentIndex + 1, prevIndex));
            prevIndex = currentIndex;
            currentIndex = packageName.lastIndexOf(46, prevIndex - 1);
            strBuf.append('.');
            if (currentIndex != -1) continue;
            strBuf.append(packageName.substring(0, prevIndex));
        }
        return strBuf;
    }

    public static StringBuffer schemaNamespaceFromClassName(String packageName, ClassLoader loader) throws Exception {
        return Java2WSDLUtils.namespaceFromClassName(packageName, loader).append(SCHEMA_NAMESPACE_EXTN);
    }

    public static StringBuffer schemaNamespaceFromPackageName(String packageName) {
        return Java2WSDLUtils.namespaceFromPackageName(packageName).append(SCHEMA_NAMESPACE_EXTN);
    }
}

