/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SSLXMPPConnection;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Writer writer;
    private XMPPConnection connection;
    private LinkedList queue;
    private boolean done = false;
    private List listeners = new ArrayList();
    private boolean listenersDeleted = false;
    private List interceptors = new ArrayList();
    private boolean interceptorDeleted = false;

    protected PacketWriter(XMPPConnection connection) {
        this.connection = connection;
        this.writer = connection.writer;
        this.queue = new LinkedList();
        this.writerThread = new Thread(){

            public void run() {
                PacketWriter.this.writePackets();
            }
        };
        this.writerThread.setName("Smack Packet Writer");
        this.writerThread.setDaemon(true);
        int keepAliveInterval = SmackConfiguration.getKeepAliveInterval();
        if (keepAliveInterval > 0) {
            Thread keepAliveThread = new Thread(new KeepAliveTask(keepAliveInterval));
            keepAliveThread.setDaemon(true);
            keepAliveThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.processInterceptors(packet);
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addFirst(packet);
                this.queue.notifyAll();
            }
            this.processListeners(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketListener packetListener, PacketFilter packetFilter) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(new ListenerWrapper(packetListener, packetFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketListener packetListener) {
        List list = this.listeners;
        synchronized (list) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListenerWrapper wrapper = (ListenerWrapper)this.listeners.get(i);
                if (wrapper == null || !wrapper.packetListener.equals(packetListener)) continue;
                this.listeners.set(i, null);
                this.listenersDeleted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketListenerCount() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        List list = this.interceptors;
        synchronized (list) {
            this.interceptors.add(new InterceptorWrapper(packetInterceptor, packetFilter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        List list = this.interceptors;
        synchronized (list) {
            for (int i = 0; i < this.interceptors.size(); ++i) {
                InterceptorWrapper wrapper = (InterceptorWrapper)this.interceptors.get(i);
                if (wrapper == null || !wrapper.packetInterceptor.equals(packetInterceptor)) continue;
                this.interceptors.set(i, null);
                this.interceptorDeleted = true;
            }
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void shutdown() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (!this.done && this.queue.size() == 0) {
                try {
                    this.queue.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.queue.size() > 0) {
                return (Packet)this.queue.removeLast();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackets() {
        block17: {
            try {
                this.openStream();
                while (!this.done) {
                    Packet packet = this.nextPacket();
                    if (packet == null) continue;
                    Writer writer = this.writer;
                    synchronized (writer) {
                        this.writer.write(packet.toXML());
                        this.writer.flush();
                    }
                }
                try {
                    this.writer.write("</stream:stream>");
                    this.writer.flush();
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception e) {}
                }
            }
            catch (IOException ioe) {
                if (this.done) break block17;
                this.done = true;
                this.connection.packetReader.notifyConnectionError(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processListeners(Packet packet) {
        int i;
        List list = this.listeners;
        synchronized (list) {
            if (this.listenersDeleted) {
                for (i = this.listeners.size() - 1; i >= 0; --i) {
                    if (this.listeners.get(i) != null) continue;
                    this.listeners.remove(i);
                }
                this.listenersDeleted = false;
            }
        }
        int size = this.listeners.size();
        for (i = 0; i < size; ++i) {
            ListenerWrapper listenerWrapper = (ListenerWrapper)this.listeners.get(i);
            if (listenerWrapper == null) continue;
            listenerWrapper.notifyListener(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInterceptors(Packet packet) {
        if (packet != null) {
            int i;
            List list = this.interceptors;
            synchronized (list) {
                if (this.interceptorDeleted) {
                    for (i = this.interceptors.size() - 1; i >= 0; --i) {
                        if (this.interceptors.get(i) != null) continue;
                        this.interceptors.remove(i);
                    }
                    this.interceptorDeleted = false;
                }
            }
            int size = this.interceptors.size();
            for (i = 0; i < size; ++i) {
                InterceptorWrapper interceptorWrapper = (InterceptorWrapper)this.interceptors.get(i);
                if (interceptorWrapper == null) continue;
                interceptorWrapper.notifyListener(packet);
            }
        }
    }

    void openStream() throws IOException {
        StringBuffer stream = new StringBuffer();
        stream.append("<stream:stream");
        stream.append(" to=\"").append(this.connection.serviceName).append("\"");
        stream.append(" xmlns=\"jabber:client\"");
        stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        if (this.connection instanceof SSLXMPPConnection) {
            stream.append(">");
        } else {
            stream.append(" version=\"1.0\">");
        }
        this.writer.write(stream.toString());
        this.writer.flush();
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;

        public KeepAliveTask(int delay) {
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!PacketWriter.this.done) {
                Writer writer = PacketWriter.this.writer;
                synchronized (writer) {
                    try {
                        PacketWriter.this.writer.write(" ");
                        PacketWriter.this.writer.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class InterceptorWrapper {
        private PacketInterceptor packetInterceptor;
        private PacketFilter packetFilter;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof InterceptorWrapper) {
                return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
            }
            if (object instanceof PacketInterceptor) {
                return object.equals(this.packetInterceptor);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    private static class ListenerWrapper {
        private PacketListener packetListener;
        private PacketFilter packetFilter;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ListenerWrapper) {
                return ((ListenerWrapper)object).packetListener.equals(this.packetListener);
            }
            if (object instanceof PacketListener) {
                return object.equals(this.packetListener);
            }
            return false;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }
}

