/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSetException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Column {
    private int columnNumber = -1;
    private String name = "";
    private String columnTypeName = "";
    private int columnType = -1;
    private String tableName = "";
    private boolean nullAllowed = false;
    private boolean autoIncrement = false;
    private boolean readOnly = false;
    private boolean searchable = false;
    private int scale = -1;
    private int precision = -1;
    private int length = -1;
    private String type = "";

    void populate(ResultSetMetaData resultSetMetaData, int n, String string) throws SQLException {
        this.columnNumber = n;
        this.name = resultSetMetaData.getColumnName(this.columnNumber);
        try {
            this.tableName = resultSetMetaData.getTableName(this.columnNumber);
            if (this.tableName == null || this.tableName.equals("")) {
                this.tableName = string != null ? string : "";
            }
        }
        catch (Exception exception) {
            this.tableName = string != null ? string : "";
        }
        this.columnTypeName = resultSetMetaData.getColumnTypeName(this.columnNumber);
        this.columnType = resultSetMetaData.getColumnType(this.columnNumber);
        this.nullAllowed = resultSetMetaData.isNullable(this.columnNumber) == 1;
        this.autoIncrement = resultSetMetaData.isAutoIncrement(this.columnNumber);
        this.readOnly = resultSetMetaData.isReadOnly(this.columnNumber);
        this.searchable = resultSetMetaData.isSearchable(this.columnNumber);
        this.scale = resultSetMetaData.getScale(this.columnNumber);
        try {
            this.precision = resultSetMetaData.getPrecision(this.columnNumber);
        }
        catch (NumberFormatException numberFormatException) {
            this.precision = Integer.MAX_VALUE;
        }
        this.length = resultSetMetaData.getColumnDisplaySize(this.columnNumber);
    }

    public String name() {
        return this.name;
    }

    public String dbType() {
        return this.columnTypeName;
    }

    public int typeEnum() {
        return this.columnType;
    }

    public boolean nullAllowed() {
        return this.nullAllowed;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        return this.precision;
    }

    public int length() {
        return this.length;
    }

    public String type() {
        if (this.isBoolean()) {
            return "BOOLEAN";
        }
        if (this.isByte()) {
            return "BYTE";
        }
        if (this.isShort()) {
            return "SHORT";
        }
        if (this.isInt()) {
            return "INTEGER";
        }
        if (this.isLong()) {
            return "LONG";
        }
        if (this.isFloat()) {
            return "FLOAT";
        }
        if (this.isDouble()) {
            return "DOUBLE";
        }
        if (this.isBigDecimal()) {
            return "BIGDECIMAL";
        }
        if (this.isDate()) {
            return "DATE";
        }
        if (this.isTime()) {
            return "TIME";
        }
        if (this.isTimestamp()) {
            return "TIMESTAMP";
        }
        if (this.isString()) {
            return "STRING";
        }
        if (this.isBinary()) {
            return "BINARY";
        }
        if (this.isVarBinary()) {
            return "VARBINARY";
        }
        if (this.isLongVarBinary()) {
            return "LONGVARBINARY";
        }
        return "UNKNOWN TYPE: " + this.typeEnum();
    }

    public boolean isBoolean() {
        return this.typeEnum() == -7;
    }

    public boolean isBigDecimal() {
        return this.typeEnum() == 2 || this.typeEnum() == 3;
    }

    public boolean isBinary() {
        return this.typeEnum() == -2;
    }

    public boolean isByte() {
        return this.typeEnum() == -6;
    }

    public boolean isBytes() {
        return this.typeEnum() == -4 || this.typeEnum() == -3 || this.columnType == -2;
    }

    public boolean isDate() {
        return this.typeEnum() == 91;
    }

    public boolean isDouble() {
        return this.typeEnum() == 6 || this.typeEnum() == 8;
    }

    public boolean isFloat() {
        return this.typeEnum() == 7;
    }

    public boolean isInt() {
        return this.typeEnum() == 4;
    }

    public boolean isLong() {
        return this.typeEnum() == -5;
    }

    public boolean isShort() {
        return this.typeEnum() == 5;
    }

    public boolean isString() {
        return this.typeEnum() == -1 || this.typeEnum() == 11 || this.typeEnum() == 12;
    }

    public boolean isTime() {
        return this.typeEnum() == 92;
    }

    public boolean isTimestamp() {
        return this.typeEnum() == 93;
    }

    public boolean isVarBinary() {
        return this.typeEnum() == -3;
    }

    public boolean isLongVarBinary() {
        return this.typeEnum() == -4;
    }

    public String dbKonaMethod() throws DataSetException {
        throw new DataSetException("Method not implemented: Unknown use!");
    }

    public String javaType() throws DataSetException {
        throw new DataSetException("Method not implemented: Unknown use!");
    }

    public final String preparedStatemntBindMethod() throws DataSetException {
        throw new DataSetException("Method not implemented: Unknown use!");
    }

    public final String resultSetMethod() throws DataSetException {
        throw new DataSetException("Method not implemented: Unknown use!");
    }

    public String getTableName() {
        return this.tableName;
    }
}

