/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import com.workingdogs.village.Value;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class Record {
    private Value[] values;
    private boolean[] isClean;
    private DataSet parentDataSet;
    private int numberOfColumns;
    private int saveType = 0;
    private Schema schema;
    private boolean status;

    public Record() {
    }

    public Record(DataSet dataSet) throws DataSetException, SQLException {
        this.setParentDataSet(dataSet);
        this.initializeRecord();
        this.createValues(this.dataset().resultSet());
    }

    Record(DataSet dataSet, boolean bl) throws DataSetException, SQLException {
        this.setParentDataSet(dataSet);
        this.initializeRecord();
        this.createValues(null);
    }

    private void initializeRecord() throws DataSetException {
        this.schema = this.dataset().schema();
        this.numberOfColumns = this.schema.numberOfColumns();
        this.values = new Value[this.size() + 1];
        this.isClean = new boolean[this.size() + 1];
        this.setSaveType(11);
        for (int i = 1; i <= this.size(); ++i) {
            this.markValueClean(i);
            this.values[i] = null;
        }
    }

    private void createValues(ResultSet resultSet) throws DataSetException, SQLException {
        for (int i = 1; i <= this.size(); ++i) {
            Value value;
            this.values[i] = value = new Value(resultSet, i, this.schema().column(i).typeEnum());
        }
    }

    public int save() throws DataSetException, SQLException {
        return this.save(this.dataset().connection());
    }

    public int save(Connection connection) throws DataSetException, SQLException {
        int n = 0;
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot save a QueryDataSet. Please use a TableDataSet instead.");
        }
        if (!this.needsToBeSaved()) {
            return n;
        }
        if (this.toBeSavedWithInsert()) {
            n = this.saveWithInsert(connection);
        } else if (this.toBeSavedWithUpdate()) {
            n = this.saveWithUpdate(connection);
        } else if (this.toBeSavedWithDelete()) {
            n = this.saveWithDelete(connection);
        }
        return n;
    }

    /*
     * Loose catch block
     */
    private int saveWithDelete(Connection connection) throws DataSetException, SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n2 = 1;
        for (n = 1; n <= this.dataset().keydef().size(); ++n) {
            Value value = this.getValue(this.dataset().keydef().getAttrib(n));
            value.setPreparedStatementValue(preparedStatement, n2++);
        }
        n = preparedStatement.executeUpdate();
        this.setSaveType(1);
        if (n > 1) {
            throw new SQLException("There were " + n + " rows deleted with this records key value.");
        }
        int n3 = n;
        Object var7_8 = null;
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return n3;
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int saveWithUpdate(Connection connection) throws DataSetException, SQLException {
        Value value;
        int n;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n2 = 1;
        for (n = 1; n <= this.size(); ++n) {
            value = this.getValue(n);
            if (this.valueIsClean(n) || this.schema().column(n).readOnly()) continue;
            value.setPreparedStatementValue(preparedStatement, n2++);
        }
        for (n = 1; n <= this.dataset().keydef().size(); ++n) {
            value = this.getValue(this.dataset().keydef().getAttrib(n));
            value.setPreparedStatementValue(preparedStatement, n2++);
        }
        n = preparedStatement.executeUpdate();
        if (((TableDataSet)this.dataset()).refreshOnSave()) {
            this.refresh(this.dataset().connection());
        } else {
            this.markRecordClean();
        }
        this.setSaveType(10);
        if (n > 1) {
            throw new SQLException("There were " + n + " rows updated with this records key value.");
        }
        int n3 = n;
        Object var7_8 = null;
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return n3;
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int saveWithInsert(Connection connection) throws DataSetException, SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n2 = 1;
        for (n = 1; n <= this.size(); ++n) {
            Value value = this.getValue(n);
            if (this.valueIsClean(n) || this.schema().column(n).readOnly()) continue;
            value.setPreparedStatementValue(preparedStatement, n2++);
        }
        n = preparedStatement.executeUpdate();
        if (((TableDataSet)this.dataset()).refreshOnSave()) {
            this.refresh(this.dataset().connection());
        } else {
            this.markRecordClean();
        }
        this.setSaveType(8);
        if (n > 1) {
            throw new SQLException("There were " + n + " rows inserted with this records key value.");
        }
        int n3 = n;
        Object var7_8 = null;
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return n3;
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
        }
    }

    private String getUpdateSaveString() throws DataSetException {
        Object object;
        int n;
        KeyDef keyDef = this.dataset().keydef();
        if (keyDef == null || keyDef.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to create a Record for update.");
        }
        if (this.recordIsClean()) {
            throw new DataSetException("You must Record.setValue() on a column before doing an update.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        for (n = 1; n <= this.size(); ++n) {
            object = this.getValue(n);
            if (this.valueIsClean(n) || this.schema().column(n).readOnly()) continue;
            if (!bl) {
                stringBuffer.append(this.schema().column(n).name());
                stringBuffer.append(" = ?");
                bl = true;
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append(this.schema().column(n).name());
            stringBuffer.append(" = ?");
        }
        bl = false;
        for (n = 1; n <= keyDef.size(); ++n) {
            object = keyDef.getAttrib(n);
            if (!this.valueIsClean(this.schema().index((String)object))) {
                throw new DataSetException("The value for column '" + (String)object + "' is a key value and cannot be updated.");
            }
            if (!bl) {
                stringBuffer2.append((String)object);
                stringBuffer2.append(" = ?");
                bl = true;
                continue;
            }
            stringBuffer2.append(" AND ");
            stringBuffer2.append((String)object);
            stringBuffer2.append(" = ?");
        }
        return "UPDATE " + this.schema().tableName() + " SET " + stringBuffer.toString() + " WHERE " + stringBuffer2.toString();
    }

    private String getDeleteSaveString() throws DataSetException {
        KeyDef keyDef = this.dataset().keydef();
        if (keyDef == null || keyDef.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to delete a Record.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl = false;
        for (int i = 1; i <= keyDef.size(); ++i) {
            if (!bl) {
                stringBuffer.append(keyDef.getAttrib(i));
                stringBuffer.append(" = ?");
                bl = true;
                continue;
            }
            stringBuffer.append(" AND ");
            stringBuffer.append(keyDef.getAttrib(i));
            stringBuffer.append(" = ? ");
        }
        return "DELETE FROM " + this.schema().tableName() + " WHERE " + stringBuffer.toString();
    }

    private String getInsertSaveString() throws DataSetException {
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        for (int i = 1; i <= this.size(); ++i) {
            Value value = this.getValue(i);
            if (this.valueIsClean(i) || this.schema().column(i).readOnly()) continue;
            if (!bl) {
                stringBuffer.append(this.schema().column(i).name());
                stringBuffer2.append("?");
                bl = true;
                continue;
            }
            stringBuffer.append(", " + this.schema().column(i).name());
            stringBuffer2.append(", ?");
        }
        return "INSERT INTO " + this.schema().tableName() + " ( " + stringBuffer.toString() + " ) VALUES ( " + stringBuffer2.toString() + " )";
    }

    public String getSaveString() throws DataSetException {
        if (this.toBeSavedWithInsert()) {
            return this.getInsertSaveString();
        }
        if (this.toBeSavedWithUpdate()) {
            return this.getUpdateSaveString();
        }
        if (this.toBeSavedWithDelete()) {
            return this.getDeleteSaveString();
        }
        throw new DataSetException("Not able to return save string: " + this.saveType);
    }

    public Value getValue(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Values are 1 based!");
        }
        if (n > this.size()) {
            throw new DataSetException("Only " + this.size() + " columns exist!");
        }
        if (this.values[n] == null) {
            throw new DataSetException("No values for the requested column!");
        }
        return this.values[n];
    }

    public Value getValue(String string) throws DataSetException {
        return this.getValue(this.schema().index(string));
    }

    public int size() {
        return this.numberOfColumns;
    }

    public boolean toBeSavedWithInsert() {
        return this.saveType == 4;
    }

    public boolean toBeSavedWithUpdate() {
        return this.saveType == 3;
    }

    public boolean toBeSavedWithDelete() {
        return this.saveType == 2;
    }

    public void markRecordClean() throws DataSetException {
        for (int i = 1; i <= this.size(); ++i) {
            this.markValueClean(i);
        }
    }

    public void markForInsert() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for insert");
        }
        this.setSaveType(4);
    }

    public void markForUpdate() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for update");
        }
        this.setSaveType(3);
    }

    public Record markToBeDeleted() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for deletion");
        }
        this.setSaveType(2);
        return this;
    }

    public Record unmarkToBeDeleted() throws DataSetException {
        if (this.saveType == 1) {
            throw new DataSetException("This record has already been deleted!");
        }
        this.setSaveType(11);
        return this;
    }

    public void markValueClean(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[n] = true;
    }

    public void markValueClean(String string) throws DataSetException {
        this.markValueClean(this.schema().index(string));
    }

    public void markValueDirty(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[n] = false;
    }

    public void markValueDirty(String string) throws DataSetException {
        this.markValueDirty(this.schema().index(string));
    }

    void setSaveType(int n) {
        this.saveType = n;
    }

    int getSaveType() {
        return this.saveType;
    }

    public Record setValue(int n, BigDecimal bigDecimal) throws DataSetException {
        this.values[n].setValue(bigDecimal);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, boolean bl) throws DataSetException {
        this.values[n].setValue(new Boolean(bl));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, byte[] byArray) throws DataSetException {
        this.values[n].setValue(byArray);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, java.util.Date date) throws DataSetException {
        this.values[n].setValue(date);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Date date) throws DataSetException {
        this.values[n].setValue(date);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, double d) throws DataSetException {
        this.values[n].setValue(new Double(d));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, float f) throws DataSetException {
        this.values[n].setValue(new Float(f));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, int n2) throws DataSetException {
        this.values[n].setValue(new Integer(n2));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, long l) throws DataSetException {
        this.values[n].setValue(new Long(l));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, String string) throws DataSetException {
        this.values[n].setValue(string);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Time time) throws DataSetException {
        this.values[n].setValue(time);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Timestamp timestamp) throws DataSetException {
        this.values[n].setValue(timestamp);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Value value) throws DataSetException {
        this.values[n].setValue(value.getValue());
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(String string, BigDecimal bigDecimal) throws DataSetException {
        this.setValue(this.schema().index(string), bigDecimal);
        return this;
    }

    public Record setValue(String string, boolean bl) throws DataSetException {
        this.setValue(this.schema().index(string), bl);
        return this;
    }

    public Record setValue(String string, byte[] byArray) throws DataSetException {
        this.setValue(this.schema().index(string), byArray);
        return this;
    }

    public Record setValue(String string, java.util.Date date) throws DataSetException {
        this.setValue(this.schema().index(string), date);
        return this;
    }

    public Record setValue(String string, Date date) throws DataSetException {
        this.setValue(this.schema().index(string), date);
        return this;
    }

    public Record setValue(String string, double d) throws DataSetException {
        this.setValue(this.schema().index(string), d);
        return this;
    }

    public Record setValue(String string, float f) throws DataSetException {
        this.setValue(this.schema().index(string), f);
        return this;
    }

    public Record setValue(String string, int n) throws DataSetException {
        this.setValue(this.schema().index(string), n);
        return this;
    }

    public Record setValue(String string, long l) throws DataSetException {
        this.setValue(this.schema().index(string), l);
        return this;
    }

    public Record setValue(String string, String string2) throws DataSetException {
        this.setValue(this.schema().index(string), string2);
        return this;
    }

    public Record setValue(String string, Time time) throws DataSetException {
        this.setValue(this.schema().index(string), time);
        return this;
    }

    public Record setValue(String string, Timestamp timestamp) throws DataSetException {
        this.setValue(this.schema().index(string), timestamp);
        return this;
    }

    public Record setValue(String string, Value value) throws DataSetException {
        this.setValue(this.schema().index(string), value);
        return this;
    }

    public Record setValueNull(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.values[n].setValue(null);
        this.markValueDirty(n);
        return this;
    }

    public Record setValueNull(String string) throws DataSetException {
        if (string == null || string.length() == 0) {
            throw new DataSetException("You must specify a column name!");
        }
        this.setValueNull(this.schema().index(string));
        return this;
    }

    public boolean isAZombie() {
        return this.saveType == 1;
    }

    public boolean needsToBeSaved() {
        return !this.isAZombie() || !this.recordIsClean() || this.toBeSavedWithUpdate() || this.toBeSavedWithDelete() || this.toBeSavedWithInsert();
    }

    public boolean valueIsClean(int n) {
        return this.isClean[n];
    }

    boolean valueIsClean(String string) throws DataSetException {
        return this.isClean[this.getValue(string).columnNumber()];
    }

    public boolean recordIsClean() {
        for (int i = 1; i <= this.size(); ++i) {
            if (this.valueIsClean(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(Connection connection) throws DataSetException, SQLException {
        if (this.toBeSavedWithDelete()) {
            return;
        }
        if (this.toBeSavedWithInsert()) {
            throw new DataSetException("There is no way to refresh a record which has been created with addRecord().");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a refresh on Records created with a TableDataSet.");
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getRefreshQueryString());
        int n = 1;
        for (int i = 1; i <= this.dataset().keydef().size(); ++i) {
            Value value = this.getValue(this.dataset().keydef().getAttrib(i));
            if (value.isNull()) {
                throw new DataSetException("You cannot execute an update with a null value for a KeyDef.");
            }
            value.setPreparedStatementValue(preparedStatement, n++);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.initializeRecord();
        this.createValues(resultSet);
        Object var7_8 = null;
        if (preparedStatement == null) return;
        preparedStatement.close();
        return;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
    }

    public String getRefreshQueryString() throws DataSetException {
        int n;
        if (this.dataset().keydef() == null || this.dataset().keydef().size() == 0) {
            throw new DataSetException("You can only perform a getRefreshQueryString on a TableDataSet that was created with a KeyDef.");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a getRefreshQueryString on Records created with a TableDataSet.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        for (n = 1; n <= this.size(); ++n) {
            if (!bl) {
                stringBuffer.append(this.schema().column(n).name());
                bl = true;
                continue;
            }
            stringBuffer.append(", ");
            stringBuffer.append(this.schema().column(n).name());
        }
        bl = false;
        for (n = 1; n <= this.dataset().keydef().size(); ++n) {
            String string = this.dataset().keydef().getAttrib(n);
            if (!this.valueIsClean(string)) {
                throw new DataSetException("You cannot do a refresh from the database if the value for a KeyDef column has been changed with a Record.setValue().");
            }
            if (!bl) {
                stringBuffer2.append(string);
                stringBuffer2.append(" = ?");
                bl = true;
                continue;
            }
            stringBuffer2.append(" AND ");
            stringBuffer2.append(string);
            stringBuffer2.append(" = ?");
        }
        return "SELECT " + stringBuffer.toString() + " FROM " + this.schema().tableName() + " WHERE " + stringBuffer2.toString();
    }

    public void saveWithoutStatusUpdate() throws DataSetException {
        throw new DataSetException("Record.saveWithoutStatusUpdate() is not yet implemented.");
    }

    public Schema schema() throws DataSetException {
        if (this.dataset() != null) {
            return this.schema;
        }
        throw new DataSetException("Internal Error: Record DataSet is null");
    }

    public DataSet dataset() {
        return this.parentDataSet;
    }

    void setParentDataSet(DataSet dataSet) {
        this.parentDataSet = dataSet;
    }

    public String asFormattedString(String string, int[] nArray) throws DataSetException {
        throw new DataSetException("Not yet implemented!");
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.print("{");
            for (int i = 1; i <= this.size(); ++i) {
                printWriter.print("'" + this.getValue(i).asString() + "'");
                if (i >= this.size()) continue;
                printWriter.print(',');
            }
            printWriter.print("}");
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void updateStatus() throws SQLException, DataSetException {
        this.status = true;
    }
}

