/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSetException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Schema {
    private String tableName = "";
    private String columnsAttribute = null;
    private int numberOfColumns = 0;
    private Column[] columns;
    private static Hashtable schemaCache = new Hashtable();
    private Hashtable tableHash;
    private boolean singleTable = true;

    public Schema schema(Connection connection, String string) throws SQLException, DataSetException {
        return this.schema(connection, string, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema schema(Connection connection, String string, String string2) throws SQLException, DataSetException {
        if (string2 == null) {
            string2 = "*";
        }
        Statement statement = null;
        try {
            Object object;
            String string3 = connection.getMetaData().getURL() + string;
            Schema schema = (Schema)schemaCache.get(string3);
            if (schema == null) {
                object = schemaCache;
                synchronized (object) {
                    schema = (Schema)schemaCache.get(string3);
                    if (schema == null) {
                        String string4 = "SELECT " + string2 + " FROM " + string + " WHERE 1 = -1";
                        statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(string4);
                        if (resultSet != null) {
                            schema = new Schema();
                            schema.setTableName(string);
                            schema.setAttributes(string2);
                            schema.populate(resultSet.getMetaData(), string);
                            schemaCache.put(string3, schema);
                        } else {
                            throw new DataSetException("Couldn't retrieve schema for " + string);
                        }
                    }
                }
            }
            object = schema;
            return object;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    void appendTableName(String string) {
        this.tableName = this.tableName + " " + string;
    }

    public String attributes() {
        return this.columnsAttribute;
    }

    public Column column(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Columns are 1 based");
        }
        if (n > this.numberOfColumns) {
            throw new DataSetException("There are only " + this.numberOfColumns() + " available!");
        }
        try {
            return this.columns[n];
        }
        catch (Exception exception) {
            throw new DataSetException("Column number: " + this.numberOfColumns() + " does not exist!");
        }
    }

    public Column column(String string) throws DataSetException {
        return this.column(this.index(string));
    }

    public Column getColumn(String string) throws DataSetException {
        int n = string.indexOf(46);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return this.getColumn(string2, string3);
        }
        return this.column(this.index(string));
    }

    public Column getColumn(String string, String string2) throws DataSetException {
        return (Column)((Hashtable)this.tableHash.get(string)).get(string2);
    }

    Column[] getColumns() {
        return this.columns;
    }

    public String getTableName() throws DataSetException {
        if (this.singleTable) {
            return this.tableName;
        }
        throw new DataSetException("This schema represents several tables.");
    }

    public String[] getAllTableNames() {
        Enumeration enumeration = this.tableHash.keys();
        String[] stringArray = new String[this.tableHash.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public int index(String string) throws DataSetException {
        int n = string.indexOf(46);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return this.index(string2, string3);
        }
        for (int i = 1; i <= this.numberOfColumns(); ++i) {
            if (!this.columns[i].name().equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new DataSetException("Column name: " + string + " does not exist!");
    }

    public int index(String string, String string2) throws DataSetException {
        for (int i = 1; i <= this.numberOfColumns(); ++i) {
            if (!this.columns[i].name().equalsIgnoreCase(string2) || !this.columns[i].getTableName().equalsIgnoreCase(string)) continue;
            return i;
        }
        throw new DataSetException("Column name: " + string2 + " does not exist!");
    }

    public boolean isSingleTable() {
        return this.singleTable;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    void populate(ResultSetMetaData resultSetMetaData, String string) throws SQLException, DataSetException {
        Object object;
        int n;
        this.numberOfColumns = resultSetMetaData.getColumnCount();
        this.columns = new Column[this.numberOfColumns() + 1];
        for (n = 1; n <= this.numberOfColumns(); ++n) {
            object = new Column();
            ((Column)object).populate(resultSetMetaData, n, string);
            this.columns[n] = object;
            if (n <= 1 || ((Column)object).getTableName().equalsIgnoreCase(this.columns[n - 1].getTableName())) continue;
            this.singleTable = false;
        }
        if (this.singleTable) {
            if (string != null && string.length() > 0) {
                this.setTableName(string);
            } else {
                try {
                    this.setTableName(resultSetMetaData.getTableName(1));
                }
                catch (Exception exception) {
                    this.setTableName("");
                }
            }
        } else {
            this.tableHash = new Hashtable((int)(1.25 * (double)this.numberOfColumns + 1.0));
            for (n = 1; n <= this.numberOfColumns(); ++n) {
                if (this.tableHash.containsKey(this.columns[n].getTableName())) {
                    ((Hashtable)this.tableHash.get(this.columns[n].getTableName())).put(this.columns[n].name(), this.columns[n]);
                    continue;
                }
                object = new Hashtable((int)(1.25 * (double)this.numberOfColumns + 1.0));
                ((Hashtable)object).put(this.columns[n].name(), this.columns[n]);
                this.tableHash.put(this.columns[n].getTableName(), object);
            }
        }
    }

    void setAttributes(String string) {
        this.columnsAttribute = string;
    }

    void setTableName(String string) {
        this.tableName = string;
    }

    public String tableName() throws DataSetException {
        return this.getTableName();
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.print('{');
            for (int i = 1; i <= this.numberOfColumns; ++i) {
                printWriter.print('\'');
                if (!this.singleTable) {
                    printWriter.print(this.columns[i].getTableName() + '.');
                }
                printWriter.print(this.columns[i].name() + '\'');
                if (i >= this.numberOfColumns) continue;
                printWriter.print(',');
            }
            printWriter.print('}');
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

