/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.util;

import com.allaire.util.IntegerParser;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ISO8601 {
    public static Date parseDate(String dateString) {
        try {
            StringCharacterIterator it = new StringCharacterIterator(dateString);
            IntegerParser ip = new IntegerParser(it, 10);
            int year = ip.parseInt(4, 4, '-');
            it.next();
            int month = ip.parseInt(1, 2, '-');
            it.next();
            int day = ip.parseInt(1, 2, 'T');
            it.next();
            int hours = ip.parseInt(1, 2, ':');
            it.next();
            int minutes = ip.parseInt(1, 2, ':');
            it.next();
            int seconds = ip.parseInt(1, 2);
            boolean bHasOffset = false;
            int nRawTimezoneOffset = 0;
            char charOffset = it.current();
            if (charOffset != '\uffff') {
                if (charOffset != '+' && charOffset != '-') {
                    return null;
                }
                bHasOffset = true;
                it.next();
                nRawTimezoneOffset = 60 * ip.parseInt(1, 2, ':');
                it.next();
                nRawTimezoneOffset = 60000 * (nRawTimezoneOffset + ip.parseInt(1, 2));
                if (charOffset == '-') {
                    nRawTimezoneOffset *= -1;
                }
                if (it.current() != '\uffff') {
                    return null;
                }
            }
            int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
            int nNetTimezoneOffset = nCurrentTimezoneOffset - nRawTimezoneOffset;
            GregorianCalendar gc = new GregorianCalendar(year, month - 1, day, hours, minutes, seconds);
            gc.add(14, nNetTimezoneOffset);
            return gc.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stringValueOf(Date date, boolean useTimezoneInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(date.getYear() + 1900);
        sb.append('-');
        sb.append(date.getMonth() + 1);
        sb.append('-');
        sb.append(date.getDate());
        sb.append('T');
        sb.append(date.getHours());
        sb.append(':');
        sb.append(date.getMinutes());
        sb.append(':');
        sb.append(date.getSeconds());
        if (useTimezoneInfo) {
            int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
            int nOffsetInMins = nCurrentTimezoneOffset / 60000;
            if (nOffsetInMins < 0) {
                sb.append('-');
                nOffsetInMins *= -1;
            } else {
                sb.append('+');
            }
            sb.append(nOffsetInMins / 60);
            sb.append(':');
            sb.append(nOffsetInMins % 60);
        }
        return sb.toString();
    }
}

