/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import java.util.Hashtable;

public class ElementFactory {
    private Hashtable m_elementClasses = new Hashtable();

    public WddxElement makeWddxElement(String name) throws WddxDeserializationException {
        try {
            Class wddxElementClass = (Class)this.m_elementClasses.get(name);
            return (WddxElement)wddxElementClass.newInstance();
        }
        catch (NullPointerException e) {
            throw new WddxDeserializationException("Null pointer exception for element " + name, e);
        }
        catch (ClassCastException e) {
            throw new WddxDeserializationException("Invalid cast exception for element " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new WddxDeserializationException("No permission to load class for element " + name, e);
        }
        catch (InstantiationException e) {
            throw new WddxDeserializationException("Cannot instantiate class for element " + name, e);
        }
    }

    public void registerWddxElement(String name, String className) throws WddxDeserializationException {
        try {
            Class<?> wddxElementClass = Class.forName(className);
            this.m_elementClasses.put(name, wddxElementClass);
        }
        catch (NullPointerException e) {
            throw new WddxDeserializationException("Null pointer exception while registering WDDX elements", e);
        }
        catch (ClassNotFoundException e) {
            throw new WddxDeserializationException("Cannot find class " + className + " for WDDX element " + name, e);
        }
    }
}

