/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.java.javabean;

import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.java.javabean.BeanInfoSubTask;
import xdoclet.util.LogUtil;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XParameter;
import xjavadoc.XTag;
import xjavadoc.XType;

public class JavaBeanTagsHandler
extends XDocletTagSupport {
    static /* synthetic */ Class class$xdoclet$modules$java$javabean$JavaBeanTagsHandler;

    public static String getBeanInfoClassFor(XClass clazz) throws XDocletException {
        XTag beanTag = clazz.getDoc().getTag("javabean.class");
        String className = null;
        if (beanTag != null) {
            className = beanTag.getAttributeValue("class");
        }
        if (className == null) {
            className = clazz.getQualifiedName();
        }
        return MessageFormat.format(BeanInfoSubTask.GENERATED_BEANINFO_CLASS_NAME, className);
    }

    private static boolean isPossiblePropertyAccessor(XMethod method) {
        return method.getParameters().size() == 0 && !method.getReturnType().getType().isA("void");
    }

    private static boolean isPossiblePropertyAccessor(XMethod method, XType propertyType) {
        return JavaBeanTagsHandler.isPossiblePropertyAccessor(method) && method.getReturnType().getType().equals(propertyType);
    }

    private static boolean isPossiblePropertyMutator(XMethod method) {
        return method.getParameters().size() == 1;
    }

    private static boolean isPossiblePropertyMutator(XMethod method, XType propertyType) {
        if (JavaBeanTagsHandler.isPossiblePropertyMutator(method)) {
            XParameter firstParam = (XParameter)method.getParameters().get(0);
            return firstParam.getType().equals(propertyType);
        }
        return false;
    }

    private static boolean isExplicitlyReadOnlyProperty(XMethod method) {
        XTag tag = method.getDoc().getTag("javabean.property");
        return "true".equalsIgnoreCase(tag.getAttributeValue("readonly"));
    }

    private static XType getPropertyType(XMethod method) {
        XClass result = null;
        String name = method.getDoc().getTag("javabean.property").getAttributeValue("name");
        if (name == null || name.length() <= 0) {
            if (JavaBeanTagsHandler.isPossiblePropertyMutator(method)) {
                XParameter parameter = (XParameter)method.getParameters().get(0);
                result = parameter.getType();
            } else if (JavaBeanTagsHandler.isPossiblePropertyAccessor(method)) {
                result = method.getReturnType().getType();
            }
        } else {
            result = method.getPropertyType().getType();
        }
        return result;
    }

    private static XMethod getGetterMethod(final String propertyName, final XType propertyType, XMethod method) {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$java$javabean$JavaBeanTagsHandler == null ? (class$xdoclet$modules$java$javabean$JavaBeanTagsHandler = JavaBeanTagsHandler.class$("xdoclet.modules.java.javabean.JavaBeanTagsHandler")) : class$xdoclet$modules$java$javabean$JavaBeanTagsHandler), (String)"getGetterMethod");
        if (propertyName == null || propertyName.length() == 0) {
            log.error((Object)("invalid property name: " + propertyName));
            return null;
        }
        if (propertyType == null) {
            log.error((Object)("invalid property type: " + propertyType));
            return null;
        }
        if (method == null) {
            log.error((Object)("invalid method: " + method));
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"===find getter method===");
            log.info((Object)("method name: " + method.getName()));
            log.info((Object)("property name: " + propertyName));
            log.info((Object)("property type: " + propertyType));
        }
        XMethod getterMethod = null;
        final String explicitMethodName = method.getDoc().getTag("javabean.property").getAttributeValue("getter");
        if (explicitMethodName != null && explicitMethodName.length() > 0) {
            List methodList = JavaBeanTagsHandler.getCurrentClass().getMethods(new Predicate(){

                public boolean evaluate(Object obj) {
                    XMethod method = (XMethod)obj;
                    return JavaBeanTagsHandler.isPossiblePropertyAccessor(method, propertyType) && method.getName().equals(explicitMethodName);
                }
            }, false);
            if (methodList.size() == 1) {
                getterMethod = (XMethod)methodList.get(0);
                if (log.isInfoEnabled()) {
                    log.info((Object)("found explicit getter " + getterMethod.getName()));
                }
                if (JavaBeanTagsHandler.isPossiblePropertyAccessor(method, propertyType) && getterMethod != method) {
                    log.warn((Object)("explicit getter " + getterMethod.getName() + " (should be passed method)"));
                }
            } else {
                log.warn((Object)("no explicit getter " + explicitMethodName));
            }
        } else if (JavaBeanTagsHandler.isPossiblePropertyAccessor(method, propertyType)) {
            getterMethod = method;
            log.info((Object)"using the passed method");
        } else {
            List methodList = JavaBeanTagsHandler.getCurrentClass().getMethods(new Predicate(){

                public boolean evaluate(Object obj) {
                    XMethod method = (XMethod)obj;
                    return JavaBeanTagsHandler.isPossiblePropertyAccessor(method, propertyType) && method.getPropertyName().equals(propertyName);
                }
            }, false);
            if (methodList.size() == 1) {
                getterMethod = (XMethod)methodList.get(0);
                if (log.isInfoEnabled()) {
                    log.info((Object)("found standard getter " + getterMethod.getName()));
                }
            } else {
                log.warn((Object)"no standard getter");
            }
        }
        return getterMethod;
    }

    private static XMethod getSetterMethod(final String propertyName, final XType propertyType, XMethod method) {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$java$javabean$JavaBeanTagsHandler == null ? (class$xdoclet$modules$java$javabean$JavaBeanTagsHandler = JavaBeanTagsHandler.class$("xdoclet.modules.java.javabean.JavaBeanTagsHandler")) : class$xdoclet$modules$java$javabean$JavaBeanTagsHandler), (String)"getSetterMethod");
        if (propertyName == null || propertyName.length() == 0) {
            log.error((Object)("invalid property name: " + propertyName));
            return null;
        }
        if (propertyType == null) {
            log.error((Object)("invalid property type: " + propertyType));
            return null;
        }
        if (method == null) {
            log.error((Object)("invalid method: " + method));
            return null;
        }
        XMethod setterMethod = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"===find setter method===");
            log.info((Object)("method name: " + method.getName()));
            log.info((Object)("property name: " + propertyName));
            log.info((Object)("property type: " + propertyType));
        }
        final String explicitMethodName = method.getDoc().getTag("javabean.property").getAttributeValue("setter");
        if (JavaBeanTagsHandler.isExplicitlyReadOnlyProperty(method)) {
            log.info((Object)"explicit read only");
        } else if (explicitMethodName != null && explicitMethodName.length() > 0) {
            List methodList = JavaBeanTagsHandler.getCurrentClass().getMethods(new Predicate(){

                public boolean evaluate(Object obj) {
                    XMethod method = (XMethod)obj;
                    return JavaBeanTagsHandler.isPossiblePropertyMutator(method, propertyType) && method.getName().equals(explicitMethodName);
                }
            }, false);
            if (methodList.size() == 1) {
                setterMethod = (XMethod)methodList.get(0);
                if (log.isInfoEnabled()) {
                    log.info((Object)("found explicit setter " + setterMethod.getName()));
                }
                if (JavaBeanTagsHandler.isPossiblePropertyMutator(method, propertyType) && setterMethod != method) {
                    log.warn((Object)("explicit setter " + setterMethod.getName() + " (should be passed method)"));
                }
            } else {
                log.warn((Object)("no explicit setter " + explicitMethodName));
            }
        } else if (JavaBeanTagsHandler.isPossiblePropertyMutator(method, propertyType)) {
            setterMethod = method;
            log.info((Object)"using the passed method");
        } else {
            List methodList = JavaBeanTagsHandler.getCurrentClass().getMethods(new Predicate(){

                public boolean evaluate(Object obj) {
                    XMethod method = (XMethod)obj;
                    return JavaBeanTagsHandler.isPossiblePropertyMutator(method, propertyType) && method.getPropertyName().equals(propertyName);
                }
            }, false);
            if (methodList.size() == 1) {
                setterMethod = (XMethod)methodList.get(0);
                if (log.isInfoEnabled()) {
                    log.info((Object)("found standard setter " + setterMethod.getName()));
                }
            } else {
                log.info((Object)"no standard setter (not tagged readonly)");
            }
        }
        return setterMethod;
    }

    public String getterPrefix(Properties attributes) throws XDocletException {
        String name = JavaBeanTagsHandler.getTagValue((Properties)attributes, (int)0);
        if ("boolean".equals(name)) {
            return "is";
        }
        if ("java.lang.Boolean".equals(name)) {
            return "is";
        }
        return "get";
    }

    public String getGetterMethodNameQuoted() {
        XMethod getterMethod;
        XMethod currentMethod = JavaBeanTagsHandler.getCurrentMethod();
        String propertyName = this.getPropertyName(currentMethod);
        XType propertyType = JavaBeanTagsHandler.getPropertyType(currentMethod);
        if (propertyName != null) {
            // empty if block
        }
        if ((getterMethod = JavaBeanTagsHandler.getGetterMethod(propertyName, propertyType, currentMethod)) == null) {
            return "null";
        }
        return "\"" + getterMethod.getName() + "\"";
    }

    public String getSetterMethodNameQuoted() {
        XType propertyType;
        XMethod currentMethod = JavaBeanTagsHandler.getCurrentMethod();
        String propertyName = this.getPropertyName(currentMethod);
        XMethod setterMethod = JavaBeanTagsHandler.getSetterMethod(propertyName, propertyType = JavaBeanTagsHandler.getPropertyType(currentMethod), currentMethod);
        if (setterMethod == null) {
            return "null";
        }
        return "\"" + setterMethod.getName() + "\"";
    }

    public String getPropertyNameQuoted() {
        String name = this.getPropertyName(JavaBeanTagsHandler.getCurrentMethod());
        if (name == null) {
            return "null";
        }
        return "\"" + name + "\"";
    }

    public String beanClass(Properties attributes) throws XDocletException {
        if (JavaBeanTagsHandler.getTagValue((int)0, (String)"javabean.class", (String)"class", null, null, (boolean)false, (boolean)false) != null) {
            return JavaBeanTagsHandler.getTagValue((int)0, (String)"javabean.class", (String)"class", null, null, (boolean)false, (boolean)false);
        }
        return JavaBeanTagsHandler.getCurrentClass().getQualifiedName();
    }

    public String capitalizeClassTag(Properties attributes) throws XDocletException {
        String name = JavaBeanTagsHandler.getTagValue((Properties)attributes, (int)0);
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private String getPropertyName(XMethod currentMethod) {
        String name = null;
        XTag tag = currentMethod.getDoc().getTag("javabean.property");
        if (tag != null) {
            name = tag.getAttributeValue("name");
            name = name == null || name.length() <= 0 ? JavaBeanTagsHandler.getCurrentMethod().getPropertyName() : Introspector.decapitalize(name);
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

