/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Constant;
import org.apache.commons.validator.Form;

public class FormSet
implements Serializable {
    private boolean bProcessed = false;
    private String language = null;
    private String country = null;
    private String variant = null;
    private FastHashMap hForms = new FastHashMap();
    private FastHashMap hConstants = new FastHashMap();

    public boolean isProcessed() {
        return this.bProcessed;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void addConstant(Constant c) {
        if (c.getName() != null && c.getName().length() > 0 && c.getValue() != null && c.getValue().length() > 0) {
            this.hConstants.put((Object)c.getName(), (Object)c.getValue());
        }
    }

    public void addConstantParam(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            this.hConstants.put((Object)name, (Object)value);
        }
    }

    public void addForm(Form f) {
        this.hForms.put((Object)f.getName(), (Object)f);
    }

    public Form getForm(Object key) {
        Form f = null;
        Object o = this.hForms.get(key);
        if (o != null) {
            f = (Form)o;
        }
        return f;
    }

    public Map getForms() {
        return Collections.unmodifiableMap(this.hForms);
    }

    public synchronized void process(Map globalConstants) {
        Iterator i = this.hForms.values().iterator();
        while (i.hasNext()) {
            Form f = (Form)i.next();
            f.process(globalConstants, (Map)this.hConstants);
        }
        this.hForms.setFast(true);
        this.hConstants.setFast(true);
        this.bProcessed = true;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("FormSet: language=");
        results.append(this.language);
        results.append("  country=");
        results.append(this.country);
        results.append("  variant=");
        results.append(this.variant);
        results.append("\n");
        Iterator i = this.getForms().values().iterator();
        while (i.hasNext()) {
            results.append("   ");
            results.append(i.next());
            results.append("\n");
        }
        return results.toString();
    }
}

