/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.HashSet;
import junit.framework.TestCase;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.usermanagement.User;

public class TestGrouping
extends TestCase {
    private Grouping grouping;

    protected void setUp() throws Exception {
        super.setUp();
        this.grouping = new RandomGrouping();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestGrouping(String string) {
        super(string);
    }

    public void testGetNextGroupOrderId() {
        TestGrouping.assertEquals((int)1, (int)this.grouping.getNextGroupOrderId());
        this.grouping.setGroups(new HashSet());
        Group group = new Group();
        group.setOrderId(this.grouping.getNextGroupOrderId());
        this.grouping.getGroups().add(group);
        TestGrouping.assertEquals((int)2, (int)this.grouping.getNextGroupOrderId());
        Group group2 = new Group();
        group2.setOrderId(this.grouping.getNextGroupOrderId());
        this.grouping.getGroups().add(group2);
        TestGrouping.assertEquals((int)3, (int)this.grouping.getNextGroupOrderId());
    }

    public void testGetLearners() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group, this.grouping.getNextGroupOrderId());
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = new Group();
        this.insertUserIntoGroup(user2, group2, this.grouping.getNextGroupOrderId());
        TestGrouping.assertEquals((String)"verify number of learners", (int)2, (int)this.grouping.getLearners().size());
    }

    public void testGetGroupByLearner() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group, this.grouping.getNextGroupOrderId());
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = new Group();
        this.insertUserIntoGroup(user2, group2, this.grouping.getNextGroupOrderId());
        Group group3 = this.grouping.getGroupBy(user2);
        TestGrouping.assertEquals((String)"verify group retrieved", (int)group2.getOrderId(), (int)group3.getOrderId());
    }

    public void testGetNullGroupByLearner() {
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group, this.grouping.getNextGroupOrderId());
        User user2 = new User();
        user2.setUserId(new Integer(2));
        Group group2 = this.grouping.getGroupBy(user2);
        TestGrouping.assertTrue((String)"verify group retrieved", (boolean)group2.isNull());
    }

    public void testGetGroupWithLeastMember() {
        int n = this.grouping.getNextGroupOrderId();
        this.grouping.setGroups(new HashSet());
        User user = new User();
        user.setUserId(new Integer(1));
        Group group = new Group();
        this.insertUserIntoGroup(user, group, n);
        User user2 = new User();
        user2.setUserId(new Integer(3));
        group.getUsers().add(user2);
        User user3 = new User();
        user3.setUserId(new Integer(2));
        Group group2 = new Group();
        this.insertUserIntoGroup(user3, group2, this.grouping.getNextGroupOrderId());
        Group group3 = this.grouping.getGroupWithLeastMember();
        TestGrouping.assertEquals((String)"verify group", (int)2, (int)group3.getOrderId());
    }

    private void insertUserIntoGroup(User user, Group group, int n) {
        group.setUsers(new HashSet());
        group.getUsers().add(user);
        group.setOrderId(n);
        this.grouping.getGroups().add(group);
    }
}

