/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.usermanagement.User;

public class TestRandomGrouper
extends TestCase {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$learningdesign$TestRandomGrouper == null ? (class$org$lamsfoundation$lams$learningdesign$TestRandomGrouper = TestRandomGrouper.class$("org.lamsfoundation.lams.learningdesign.TestRandomGrouper")) : class$org$lamsfoundation$lams$learningdesign$TestRandomGrouper));
    private RandomGrouping groupingByNumofGroups;
    private RandomGrouping groupingByLearnerPerGroups;
    private List userList = new ArrayList();
    private static final int NUM_OF_TEST_USERS = 10;
    static /* synthetic */ Class class$org$lamsfoundation$lams$learningdesign$TestRandomGrouper;

    public TestRandomGrouper(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.groupingByNumofGroups = new RandomGrouping(new Long(1L), new TreeSet(), new TreeSet(), new Integer(3), null);
        this.groupingByLearnerPerGroups = new RandomGrouping(new Long(1L), new TreeSet(), new TreeSet(), null, new Integer(4));
        for (int i = 0; i < 10; ++i) {
            this.userList.add(this.createUser(new Integer(i + 1), "tester" + i));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDoGroupingLearnerListByNumOfGroups() {
        this.groupingByNumofGroups.doGrouping(this.userList);
        Group group = this.groupingByNumofGroups.getGroupWithLeastMember();
        Iterator iterator = this.groupingByNumofGroups.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            log.info((Object)("Number of Leaner in Group[" + group2.getOrderId() + "]:" + group2.getUsers().size()));
        }
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByNumofGroups.getGroups().size());
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)3, (int)group.getUsers().size());
    }

    public void testDoGroupingOneLearnerByNumOfGroups() {
        this.groupingByNumofGroups.doGrouping((User)this.userList.get(5));
        Group group = this.groupingByNumofGroups.getGroupWithLeastMember();
        Iterator iterator = this.groupingByNumofGroups.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            log.info((Object)("Number of Leaner in Group[" + group2.getOrderId() + "]:" + group2.getUsers().size()));
        }
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByNumofGroups.getGroups().size());
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)0, (int)group.getUsers().size());
    }

    public void testDoGroupingLearnerListByLearnerPerGroups() {
        this.groupingByLearnerPerGroups.doGrouping(this.userList);
        Group group = this.groupingByLearnerPerGroups.getGroupWithLeastMember();
        Iterator iterator = this.groupingByLearnerPerGroups.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            log.info((Object)("Number of Leaner in Group[" + group2.getOrderId() + "]:" + group2.getUsers().size()));
        }
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByLearnerPerGroups.getGroups().size());
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)3, (int)group.getUsers().size());
    }

    public void testDoGroupingOneLearnerByLearnerPerGroups() {
        this.groupingByLearnerPerGroups.doGrouping((User)this.userList.get(5));
        Group group = this.groupingByLearnerPerGroups.getGroupWithLeastMember();
        Iterator iterator = this.groupingByLearnerPerGroups.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            log.info((Object)("Number of Leaner in Group[" + group2.getOrderId() + "]:" + group2.getUsers().size()));
        }
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)1, (int)this.groupingByLearnerPerGroups.getGroups().size());
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)1, (int)group.getUsers().size());
        this.groupingByLearnerPerGroups.doGrouping((User)this.userList.get(1));
        this.groupingByLearnerPerGroups.doGrouping((User)this.userList.get(2));
        this.groupingByLearnerPerGroups.doGrouping((User)this.userList.get(3));
        group = this.groupingByLearnerPerGroups.getGroupWithLeastMember();
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)4, (int)group.getUsers().size());
        this.groupingByLearnerPerGroups.doGrouping((User)this.userList.get(4));
        group = this.groupingByLearnerPerGroups.getGroupWithLeastMember();
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)1, (int)group.getUsers().size());
    }

    public void testDoGroupingDuplicateLearnerByLearnerPerGroups() {
        this.groupingByLearnerPerGroups.doGrouping(this.userList);
        Group group = this.groupingByLearnerPerGroups.getGroupWithLeastMember();
        Iterator iterator = this.groupingByLearnerPerGroups.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group2 = (Group)iterator.next();
            log.info((Object)("Number of Leaner in Group[" + group2.getOrderId() + "]:" + group2.getUsers().size()));
        }
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByLearnerPerGroups.getGroups().size());
        TestRandomGrouper.assertEquals((String)"verify group with least member", (int)3, (int)group.getUsers().size());
        this.groupingByLearnerPerGroups.doGrouping(this.createUser(new Integer(11), "test11"));
        this.groupingByLearnerPerGroups.doGrouping(this.createUser(new Integer(12), "test12"));
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByLearnerPerGroups.getGroups().size());
        this.groupingByLearnerPerGroups.doGrouping(this.createUser(new Integer(11), "test11"));
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)3, (int)this.groupingByLearnerPerGroups.getGroups().size());
        this.groupingByLearnerPerGroups.doGrouping(this.createUser(new Integer(15), "test15"));
        TestRandomGrouper.assertEquals((String)"verify number of groups created", (int)4, (int)this.groupingByLearnerPerGroups.getGroups().size());
    }

    private User createUser(Integer n, String string) {
        User user = new User();
        user.setUserId(n);
        user.setLogin(string);
        return user;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

