/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.util.DateUtil;

public class TestScheduleGateActivity
extends TestCase {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity == null ? (class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity = TestScheduleGateActivity.class$("org.lamsfoundation.lams.learningdesign.TestScheduleGateActivity")) : class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity));
    private ScheduleGateActivity gateByTimeOffset;
    private ScheduleGateActivity gateByDateTime;
    private static final Long START_TIME_OFFSET = new Long(30L);
    private static final Long END_TIME_OFFSET = new Long(60L);
    static /* synthetic */ Class class$org$lamsfoundation$lams$learningdesign$TestScheduleGateActivity;

    protected void setUp() throws Exception {
        super.setUp();
        this.gateByTimeOffset = new ScheduleGateActivity();
        this.gateByTimeOffset.setGateStartTimeOffset(START_TIME_OFFSET);
        this.gateByTimeOffset.setGateEndTimeOffset(END_TIME_OFFSET);
        this.gateByDateTime = new ScheduleGateActivity();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(DateUtil.convertToUTC(gregorianCalendar.getTime()));
        this.gateByDateTime.setGateStartDateTime(gregorianCalendar.getTime());
        ((Calendar)gregorianCalendar).add(12, END_TIME_OFFSET.intValue());
        this.gateByDateTime.setGateEndDateTime(gregorianCalendar.getTime());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestScheduleGateActivity(String string) {
        super(string);
    }

    public void testGetRealGateOpenTime() {
        TestScheduleGateActivity.assertNotNull((String)"verify real open time by offset", (Object)this.gateByTimeOffset.getRealGateOpenTime());
        log.info((Object)("gate open time offset -- " + this.gateByTimeOffset.getGateStartTimeOffset()));
        log.info((Object)("Real gate open time by offset --" + this.gateByTimeOffset.getRealGateOpenTime()));
        TestScheduleGateActivity.assertNotNull((String)"verify real open time by date time", (Object)this.gateByDateTime.getRealGateOpenTime());
        log.info((Object)("gate open date time(UTC) -- " + this.gateByDateTime.getGateStartDateTime()));
        log.info((Object)("Real gate open time by date time -- " + this.gateByDateTime.getRealGateOpenTime()));
    }

    public void testGetRealGateCloseTime() {
        TestScheduleGateActivity.assertNotNull((String)"verify real open time", (Object)this.gateByTimeOffset.getRealGateCloseTime());
        log.info((Object)("gate close time offset -- " + this.gateByTimeOffset.getGateEndTimeOffset()));
        log.info((Object)("gate close time by offset --" + this.gateByTimeOffset.getRealGateCloseTime()));
        TestScheduleGateActivity.assertNotNull((String)"verify real close time by date time", (Object)this.gateByDateTime.getRealGateCloseTime());
        log.info((Object)("gate close date time(UTC) -- " + this.gateByDateTime.getGateEndDateTime()));
        log.info((Object)("Real gate close time by date time -- " + this.gateByDateTime.getRealGateCloseTime()));
    }

    public void testGetRealCloseTimeWithLongOffset() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.gateByDateTime.getGateEndDateTime());
        ((Calendar)gregorianCalendar).add(12, END_TIME_OFFSET.intValue() * 24);
        this.gateByDateTime.setGateEndDateTime(gregorianCalendar.getTime());
        TestScheduleGateActivity.assertNotNull((String)"verify real close time by date time", (Object)this.gateByDateTime.getRealGateCloseTime());
        log.info((Object)("gate close date time(UTC) -- " + this.gateByDateTime.getGateEndDateTime()));
        log.info((Object)("Real gate close time by date time -- " + this.gateByDateTime.getRealGateCloseTime()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

