/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dao;

import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;

public class TestGroupingDAO
extends AbstractLamsTestCase {
    protected IGroupingDAO groupingDAO;
    protected IUserDAO userDAO = null;
    private static Grouping testGrouping = null;
    private static User testUser = null;
    private final Integer TEST_USER_ID = new Integer(2);
    private final Long TEST_GROUPING_ID = new Long(99L);

    protected void setUp() throws Exception {
        super.setUp();
        this.groupingDAO = (GroupingDAO)this.context.getBean("groupingDAO");
        this.userDAO = (UserDAO)this.context.getBean("userDAO");
        testUser = this.userDAO.getUserById(this.TEST_USER_ID);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestGroupingDAO(String string) {
        super(string);
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"/org/lamsfoundation/lams/learningdesign/learningDesignApplicationContext.xml", "applicationContext.xml"};
    }

    public void testGetGrouping() {
        testGrouping = this.groupingDAO.getGroupingById(this.TEST_GROUPING_ID);
        TestGroupingDAO.assertNotNull((String)"verify grouping", (Object)testGrouping);
        TestGroupingDAO.assertEquals((String)"verify number of existing groups", (int)1, (int)testGrouping.getGroups().size());
        TestGroupingDAO.assertTrue((String)"test learner shouldn't exist", (!testGrouping.doesLearnerExist(testUser) ? 1 : 0) != 0);
    }

    public void testUpdateGrouping() {
        testGrouping.doGrouping(testUser);
        this.groupingDAO.update(testGrouping);
        testGrouping = this.groupingDAO.getGroupingById(this.TEST_GROUPING_ID);
        TestGroupingDAO.assertEquals((String)"verify number of groups", (int)2, (int)testGrouping.getGroups().size());
        TestGroupingDAO.assertTrue((String)"tet learner should exist now", (boolean)testGrouping.doesLearnerExist(testUser));
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }
}

