/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import java.util.Hashtable;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.GroupingDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class AuthoringActivityDTO
extends BaseDTO {
    private Long activityId;
    private Integer activityUIID;
    private String description;
    private String title;
    private String helpText;
    private Integer xcoord;
    private Integer ycoord;
    private Long parentActivityID;
    private Integer parentUIID;
    private Integer activityTypeId;
    private Long groupingID;
    private Integer groupingUIID;
    private Integer orderID;
    private Boolean defineLater;
    private Long learningDesignID;
    private Long learningLibraryID;
    private Date createDateTime;
    private Boolean runOffline;
    private String offlineInstructions;
    private String onlineInstructions;
    private Integer maxOptions;
    private Integer minOptions;
    private String optionsInstructions;
    private Long toolID;
    private Long toolContentID;
    private Integer activityCategoryID;
    private Integer gateActivityLevelID;
    private Boolean gateOpen;
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;
    private Boolean applyGrouping;
    private Integer groupingSupportType;
    private Integer groupingType;
    private String libraryActivityUiImage;
    private Long createGroupingID;
    private Integer createGroupingUIID;
    private GroupingDTO groupingDTO;
    private Long libraryActivityID;

    public AuthoringActivityDTO(Long activityId, Integer activityUIID, String description, String title, String helpText, Integer xcoord, Integer ycoord, Long parentActivityID, Integer parentUIID, Integer activityTypeId, Long groupingID, Integer groupingUIID, Integer orderID, Boolean defineLater, Long learningDesignID, Long learningLibraryID, Date createDateTime, Boolean runOffline, String offlineInstructions, String onlineInstructions, Integer maxOptions, Integer minOptions, String optionsInstructions, Long toolID, Long toolContentID, Integer activityCategoryID, Integer gateActivityLevelID, Boolean gateOpen, Long gateStartTimeOffset, Long gateEndTimeOffset, Date gateStartDateTime, Date gateEndDateTime, String libraryActivityUiImage, Long createGroupingID, Integer createGroupingUIID, Long libraryActivityID, Boolean applyGrouping, Integer groupingSupportType, Integer groupingType, GroupingDTO groupingDTO) {
        this.activityId = activityId;
        this.activityUIID = activityUIID;
        this.description = description;
        this.title = title;
        this.helpText = helpText;
        this.xcoord = xcoord;
        this.ycoord = ycoord;
        this.parentActivityID = parentActivityID;
        this.parentUIID = parentUIID;
        this.activityTypeId = activityTypeId;
        this.groupingID = groupingID;
        this.groupingUIID = groupingUIID;
        this.orderID = orderID;
        this.defineLater = defineLater;
        this.learningDesignID = learningDesignID;
        this.learningLibraryID = learningLibraryID;
        this.createDateTime = createDateTime;
        this.runOffline = runOffline;
        this.offlineInstructions = offlineInstructions;
        this.onlineInstructions = onlineInstructions;
        this.maxOptions = maxOptions;
        this.minOptions = minOptions;
        this.optionsInstructions = optionsInstructions;
        this.toolID = toolID;
        this.toolContentID = toolContentID;
        this.activityCategoryID = activityCategoryID;
        this.gateActivityLevelID = gateActivityLevelID;
        this.gateOpen = gateOpen;
        this.gateStartTimeOffset = gateStartTimeOffset;
        this.gateEndTimeOffset = gateEndTimeOffset;
        this.gateStartDateTime = gateStartDateTime;
        this.gateEndDateTime = gateEndDateTime;
        this.libraryActivityUiImage = libraryActivityUiImage;
        this.createGroupingID = createGroupingID;
        this.createGroupingUIID = createGroupingUIID;
        this.libraryActivityID = libraryActivityID;
        this.applyGrouping = applyGrouping;
        this.groupingSupportType = groupingSupportType;
        this.groupingType = groupingType;
        this.groupingDTO = groupingDTO;
    }

    public AuthoringActivityDTO(Object object) {
        this.processActivityType(object);
        Activity activity = (Activity)object;
        this.activityId = activity.getActivityId();
        this.activityUIID = activity.getActivityUIID();
        this.description = activity.getDescription();
        this.title = activity.getTitle();
        this.helpText = activity.getHelpText();
        this.xcoord = activity.getXcoord();
        this.ycoord = activity.getYcoord();
        this.parentActivityID = activity.getParentActivity() != null ? activity.getParentActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.parentUIID = activity.getParentUIID();
        this.activityTypeId = activity.getActivityTypeId();
        this.groupingID = activity.getGrouping() != null ? activity.getGrouping().getGroupingId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.groupingUIID = activity.getGroupingUIID();
        this.orderID = activity.getOrderId();
        this.defineLater = activity.getDefineLater();
        this.learningDesignID = activity.getLearningDesign() != null ? activity.getLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.learningLibraryID = activity.getLearningLibrary() != null ? activity.getLearningLibrary().getLearningLibraryId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.createDateTime = activity.getCreateDateTime();
        this.runOffline = activity.getRunOffline();
        this.offlineInstructions = activity.getOfflineInstructions();
        this.onlineInstructions = activity.getOnlineInstructions();
        this.activityCategoryID = activity.getActivityCategoryID();
        this.libraryActivityUiImage = activity.getLibraryActivityUiImage();
        this.libraryActivityID = activity.getLibraryActivity() != null ? activity.getLibraryActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
        this.applyGrouping = activity.getApplyGrouping();
        this.groupingSupportType = activity.getGroupingSupportType();
    }

    public AuthoringActivityDTO(Hashtable activityDetails) {
        if (activityDetails.containsKey("activityUIID")) {
            this.activityUIID = this.convertToInteger(activityDetails.get("activityUIID"));
        }
        if (activityDetails.containsKey("description")) {
            this.description = (String)activityDetails.get("description");
        }
        if (activityDetails.containsKey("title")) {
            this.title = (String)activityDetails.get("title");
        }
        if (activityDetails.containsKey("helpText")) {
            this.helpText = (String)activityDetails.get("helpText");
        }
        if (activityDetails.containsKey("xcoord")) {
            this.xcoord = this.convertToInteger(activityDetails.get("xcoord"));
        }
        if (activityDetails.containsKey("ycoord")) {
            this.ycoord = this.convertToInteger(activityDetails.get("ycoord"));
        }
        if (activityDetails.containsKey("parentActivityID")) {
            this.parentActivityID = this.convertToLong(activityDetails.get("parentActivityID"));
        }
        if (activityDetails.containsKey("parentUIID")) {
            this.parentUIID = this.convertToInteger(activityDetails.get("parentUIID"));
        }
        if (activityDetails.containsKey("activityTypeId")) {
            this.activityTypeId = this.convertToInteger(activityDetails.get("activityTypeId"));
        }
        if (activityDetails.containsKey("groupingID")) {
            this.groupingID = this.convertToLong(activityDetails.get("groupingID"));
        }
        if (activityDetails.containsKey("groupingUIID")) {
            this.groupingUIID = this.convertToInteger(activityDetails.get("groupingUIID"));
        }
        if (activityDetails.containsKey("orderID")) {
            this.orderID = this.convertToInteger(activityDetails.get("orderID"));
        }
        if (activityDetails.containsKey("defineLater")) {
            this.defineLater = (Boolean)activityDetails.get("defineLater");
        }
        if (activityDetails.containsKey("learningDesignID")) {
            this.learningDesignID = this.convertToLong(activityDetails.get("learningDesignID"));
        }
        if (activityDetails.containsKey("learningLibraryID")) {
            this.learningLibraryID = this.convertToLong(activityDetails.get("learningLibraryID"));
        }
        if (activityDetails.containsKey("createDateTime")) {
            this.createDateTime = (Date)activityDetails.get("createDateTime");
        }
        if (activityDetails.containsKey("runOffline")) {
            this.runOffline = (Boolean)activityDetails.get("runOffline");
        }
        if (activityDetails.containsKey("offlineInstructions")) {
            this.offlineInstructions = (String)activityDetails.get("offlineInstructions");
        }
        if (activityDetails.containsKey("onlineInstructions")) {
            this.onlineInstructions = (String)activityDetails.get("onlineInstructions");
        }
        if (activityDetails.containsKey("maxOptions")) {
            this.maxOptions = this.convertToInteger(activityDetails.get("maxOptions"));
        }
        if (activityDetails.containsKey("minOptions")) {
            this.minOptions = this.convertToInteger(activityDetails.get("minOptions"));
        }
        if (activityDetails.containsKey("optionsInstructions")) {
            this.optionsInstructions = (String)activityDetails.get("optionsInstructions");
        }
        if (activityDetails.containsKey("toolID")) {
            this.toolID = this.convertToLong(activityDetails.get("toolID"));
        }
        if (activityDetails.containsKey("toolContentID")) {
            this.toolContentID = this.convertToLong(activityDetails.get("toolContentID"));
        }
        if (activityDetails.containsKey("activityCategoryID")) {
            this.activityCategoryID = this.convertToInteger(activityDetails.get("activityCategoryID"));
        }
        if (activityDetails.containsKey("gateActivityLevelID")) {
            this.gateActivityLevelID = this.convertToInteger(activityDetails.get("gateActivityLevelID"));
        }
        if (activityDetails.containsKey("gateOpen")) {
            this.gateOpen = (Boolean)activityDetails.get("gateOpen");
        }
        if (activityDetails.containsKey("gateEndTimeOffset")) {
            this.gateEndTimeOffset = this.convertToLong(activityDetails.get("gateEndTimeOffset"));
        }
        if (activityDetails.containsKey("gateStartTimeOffset")) {
            this.gateStartTimeOffset = this.convertToLong(activityDetails.get("gateStartTimeOffset"));
        }
        if (activityDetails.containsKey("gateEndDateTime")) {
            this.gateEndDateTime = (Date)activityDetails.get("gateEndDateTime");
        }
        if (activityDetails.containsKey("gateStartDateTime")) {
            this.gateStartDateTime = (Date)activityDetails.get("gateStartDateTime");
        }
        if (activityDetails.containsKey("libraryActivityUiImage")) {
            this.libraryActivityUiImage = (String)activityDetails.get("libraryActivityUiImage");
        }
        if (activityDetails.containsKey("createGroupingID")) {
            this.createGroupingID = this.convertToLong(activityDetails.get("createGroupingID"));
        }
        if (activityDetails.containsKey("createGroupingUIID")) {
            this.createGroupingUIID = this.convertToInteger(activityDetails.get("createGroupingUIID"));
        }
        if (activityDetails.containsKey("libraryActivityID")) {
            this.libraryActivityID = this.convertToLong(activityDetails.get("libraryActivityID"));
        }
        if (activityDetails.containsKey("applyGrouping")) {
            this.applyGrouping = (Boolean)activityDetails.get("applyGrouping");
        }
        if (activityDetails.containsKey("groupingSupportType")) {
            this.groupingSupportType = this.convertToInteger(activityDetails.get("groupingSupportType"));
        }
        if (activityDetails.containsKey("groupingType")) {
            this.groupingType = this.convertToInteger(activityDetails.get("groupingType"));
        }
        if (activityDetails.containsKey("groupingDTO")) {
            Hashtable groupingDetails = (Hashtable)activityDetails.get("groupingDTO");
            this.groupingDTO = new GroupingDTO(groupingDetails);
        }
    }

    private void processActivityType(Object activity) {
        if (activity instanceof GroupingActivity) {
            this.addGroupingActivityAttributes((GroupingActivity)activity);
        } else if (activity instanceof ToolActivity) {
            this.addToolActivityAttributes((ToolActivity)activity);
        } else if (activity instanceof GateActivity) {
            this.addGateActivityAttributes(activity);
        } else {
            this.addComplexActivityAttributes(activity);
        }
    }

    private void addComplexActivityAttributes(Object activity) {
        if (activity instanceof OptionsActivity) {
            this.addOptionsActivityAttributes((OptionsActivity)activity);
        } else if (activity instanceof ParallelActivity) {
            this.addParallelActivityAttributes((ParallelActivity)activity);
        } else {
            this.addSequenceActivityAttributes((SequenceActivity)activity);
        }
    }

    private void addGroupingActivityAttributes(GroupingActivity groupingActivity) {
        Grouping grouping = groupingActivity.getCreateGrouping();
        this.groupingDTO = grouping.getGroupingDTO();
        this.createGroupingID = grouping.getGroupingId();
        this.createGroupingUIID = grouping.getGroupingUIID();
        this.groupingType = grouping.getGroupingTypeId();
    }

    private void addOptionsActivityAttributes(OptionsActivity optionsActivity) {
        this.maxOptions = optionsActivity.getMaxNumberOfOptions();
        this.minOptions = optionsActivity.getMinNumberOfOptions();
        this.optionsInstructions = optionsActivity.getOptionsInstructions();
    }

    private void addParallelActivityAttributes(ParallelActivity activity) {
    }

    private void addSequenceActivityAttributes(SequenceActivity activity) {
    }

    private void addToolActivityAttributes(ToolActivity toolActivity) {
        this.toolContentID = toolActivity.getToolContentId();
        this.toolID = toolActivity.getTool().getToolId();
    }

    private void addGateActivityAttributes(Object activity) {
        if (activity instanceof SynchGateActivity) {
            this.addSynchGateActivityAttributes((SynchGateActivity)activity);
        } else if (activity instanceof PermissionGateActivity) {
            this.addPermissionGateActivityAttributes((PermissionGateActivity)activity);
        } else {
            this.addScheduleGateActivityAttributes((ScheduleGateActivity)activity);
        }
        GateActivity gateActivity = (GateActivity)activity;
        this.gateActivityLevelID = gateActivity.getGateActivityLevelId();
        this.gateOpen = gateActivity.getGateOpen();
    }

    private void addSynchGateActivityAttributes(SynchGateActivity activity) {
    }

    private void addPermissionGateActivityAttributes(PermissionGateActivity activity) {
    }

    private void addScheduleGateActivityAttributes(ScheduleGateActivity activity) {
        this.gateStartDateTime = activity.getGateStartDateTime();
        this.gateStartTimeOffset = activity.getGateStartTimeOffset();
        this.gateEndDateTime = activity.getGateEndDateTime();
        this.gateEndTimeOffset = activity.getGateEndTimeOffset();
    }

    public Integer getActivityCategoryID() {
        return this.activityCategoryID != null ? this.activityCategoryID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getActivityId() {
        return this.activityId != null ? this.activityId : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getActivityTypeId() {
        return this.activityTypeId != null ? this.activityTypeId : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Integer getActivityUIID() {
        return this.activityUIID != null ? this.activityUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Date getCreateDateTime() {
        return this.createDateTime != null ? this.createDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getCreateGroupingID() {
        return this.createGroupingID != null ? this.createGroupingID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getCreateGroupingUIID() {
        return this.createGroupingUIID != null ? this.createGroupingUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Boolean getDefineLater() {
        return this.defineLater != null ? this.defineLater : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Integer getGateActivityLevelID() {
        return this.gateActivityLevelID != null ? this.gateActivityLevelID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime != null ? this.gateEndDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset != null ? this.gateEndTimeOffset : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Boolean getGateOpen() {
        return this.gateOpen != null ? this.gateOpen : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime != null ? this.gateStartDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset != null ? this.gateStartTimeOffset : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getGroupingID() {
        return this.groupingID != null ? this.groupingID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID != null ? this.groupingUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getHelpText() {
        return this.helpText != null ? this.helpText : "string_null_value";
    }

    public Long getLearningDesignID() {
        return this.learningDesignID != null ? this.learningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLearningLibraryID() {
        return this.learningLibraryID != null ? this.libraryActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getLibraryActivityID() {
        return this.libraryActivityID != null ? this.libraryActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getLibraryActivityUiImage() {
        return this.libraryActivityUiImage != null ? this.libraryActivityUiImage : "string_null_value";
    }

    public Integer getMaxOptions() {
        return this.maxOptions != null ? this.maxOptions : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Integer getMinOptions() {
        return this.minOptions != null ? this.minOptions : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions != null ? this.offlineInstructions : "string_null_value";
    }

    public String getOptionsInstructions() {
        return this.optionsInstructions != null ? this.optionsInstructions : "string_null_value";
    }

    public Integer getOrderID() {
        return this.orderID != null ? this.orderID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getParentActivityID() {
        return this.parentActivityID != null ? this.parentActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getParentUIID() {
        return this.parentUIID != null ? this.parentUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Boolean getRunOffline() {
        return this.runOffline != null ? this.runOffline : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public String getTitle() {
        return this.title != null ? this.title : "string_null_value";
    }

    public Long getToolContentID() {
        return this.toolContentID != null ? this.toolContentID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Long getToolID() {
        return this.toolID != null ? this.toolID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getXcoord() {
        return this.xcoord != null ? this.xcoord : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Integer getYcoord() {
        return this.ycoord != null ? this.ycoord : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setActivityCategoryID(Integer activityCategoryID) {
        if (!activityCategoryID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityCategoryID = activityCategoryID;
        }
    }

    public void setActivityId(Long activityId) {
        if (!activityId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.activityId = activityId;
        }
    }

    public void setActivityTypeId(Integer activityTypeId) {
        if (!activityTypeId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityTypeId = activityTypeId;
        }
    }

    public void setActivityUIID(Integer activityUIID) {
        if (!activityUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.activityUIID = activityUIID;
        }
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setCreateGroupingID(Long createGroupingID) {
        if (!createGroupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.createGroupingID = createGroupingID;
        }
    }

    public void setCreateGroupingUIID(Integer createGroupingUIID) {
        if (!createGroupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.createGroupingUIID = createGroupingUIID;
        }
    }

    public void setDefineLater(Boolean defineLater) {
        this.defineLater = defineLater;
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setGateActivityLevelID(Integer gateActivityLevelID) {
        if (!gateActivityLevelID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.gateActivityLevelID = gateActivityLevelID;
        }
    }

    public void setGateEndDateTime(Date gateEndDateTime) {
        if (!gateEndDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.gateEndDateTime = gateEndDateTime;
        }
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        if (!gateEndTimeOffset.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.gateEndTimeOffset = gateEndTimeOffset;
        }
    }

    public void setGateOpen(Boolean gateOpen) {
        this.gateOpen = gateOpen;
    }

    public void setGateStartDateTime(Date gateStartDateTime) {
        if (!gateStartDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.gateStartDateTime = gateStartDateTime;
        }
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        if (!gateStartTimeOffset.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.gateStartTimeOffset = gateStartTimeOffset;
        }
    }

    public void setGroupingID(Long groupingID) {
        if (!groupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.groupingID = groupingID;
        }
    }

    public void setGroupingUIID(Integer groupingUIID) {
        if (!groupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingUIID = groupingUIID;
        }
    }

    public void setHelpText(String helpText) {
        if (!helpText.equals("string_null_value")) {
            this.helpText = helpText;
        }
    }

    public void setLearningDesignID(Long learningDesignID) {
        if (!learningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignID;
        }
    }

    public void setLearningLibraryID(Long learningLibraryID) {
        if (!learningLibraryID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningLibraryID = learningLibraryID;
        }
    }

    public void setLibraryActivityID(Long libraryActivityID) {
        if (!libraryActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.libraryActivityID = libraryActivityID;
        }
    }

    public void setLibraryActivityUiImage(String libraryActivityUiImage) {
        if (!libraryActivityUiImage.equals("string_null_value")) {
            this.libraryActivityUiImage = libraryActivityUiImage;
        }
    }

    public void setMaxOptions(Integer maxOptions) {
        if (!maxOptions.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxOptions = maxOptions;
        }
    }

    public void setMinOptions(Integer minOptions) {
        if (!minOptions.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.minOptions = minOptions;
        }
    }

    public void setOfflineInstructions(String offlineInstructions) {
        if (!offlineInstructions.equals("string_null_value")) {
            this.offlineInstructions = offlineInstructions;
        }
    }

    public void setOptionsInstructions(String optionsInstructions) {
        if (!optionsInstructions.equals("string_null_value")) {
            this.optionsInstructions = optionsInstructions;
        }
    }

    public void setOrderID(Integer orderID) {
        if (!orderID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.orderID = orderID;
        }
    }

    public void setParentActivityID(Long parentActivityID) {
        if (!parentActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.parentActivityID = parentActivityID;
        }
    }

    public void setParentUIID(Integer parentUIID) {
        if (!parentUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.parentUIID = parentUIID;
        }
    }

    public void setRunOffline(Boolean runOffline) {
        this.runOffline = runOffline;
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setToolContentID(Long toolContentID) {
        if (!toolContentID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toolContentID = toolContentID;
        }
    }

    public void setToolID(Long toolID) {
        if (!toolID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toolID = toolID;
        }
    }

    public void setXcoord(Integer xcoord) {
        if (!xcoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.xcoord = xcoord;
        }
    }

    public void setYcoord(Integer ycoord) {
        if (!this.xcoord.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.ycoord = ycoord;
        }
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions != null ? this.onlineInstructions : "string_null_value";
    }

    public void setOnlineInstructions(String onlineInstructions) {
        if (!onlineInstructions.equals("string_null_value")) {
            this.onlineInstructions = onlineInstructions;
        }
    }

    public Boolean getApplyGrouping() {
        return this.applyGrouping != null ? this.applyGrouping : WDDXTAGS.BOOLEAN_NULL_VALUE;
    }

    public void setApplyGrouping(Boolean applyGrouping) {
        this.applyGrouping = applyGrouping;
    }

    public Integer getGroupingSupportType() {
        return this.groupingSupportType != null ? this.groupingSupportType : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setGroupingSupportType(Integer groupingSupportType) {
        if (!groupingSupportType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingSupportType = groupingSupportType;
        }
    }

    public Integer getGroupingType() {
        return this.groupingType != null ? this.groupingType : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setGroupingType(Integer groupingType) {
        if (!groupingType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingType = groupingType;
        }
    }

    public GroupingDTO getGroupingDTO() {
        return this.groupingDTO;
    }

    public void setGroupingDTO(GroupingDTO groupingDTO) {
        this.groupingDTO = groupingDTO;
    }
}

