/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Hashtable;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class GroupingDTO
extends BaseDTO {
    private Long groupingID;
    private Integer groupingUIID;
    private Integer groupingType;
    private Integer numberOfGroups;
    private Integer learnersPerGroup;
    private Long staffGroupID;
    private Integer maxNumberOfGroups;

    public GroupingDTO(Long groupingID, Integer groupingUIID, Integer groupingType, Integer numberOfGroups, Integer learnersPerGroup, Long staffGroupID, Integer maxNumberOfGroups) {
        this.groupingID = groupingID;
        this.groupingUIID = groupingUIID;
        this.groupingType = groupingType;
        this.numberOfGroups = numberOfGroups;
        this.learnersPerGroup = learnersPerGroup;
        this.staffGroupID = staffGroupID;
        this.maxNumberOfGroups = maxNumberOfGroups;
    }

    public GroupingDTO(Grouping grouping) {
        this.groupingID = grouping.getGroupingId();
        this.groupingUIID = grouping.getGroupingUIID();
        this.maxNumberOfGroups = grouping.getMaxNumberOfGroups();
        this.groupingType = grouping.getGroupingTypeId();
        Object object = Grouping.getGroupingInstance(this.groupingType);
        this.processGroupingActivity(object);
    }

    public GroupingDTO(Hashtable groupingDetails) {
        if (groupingDetails.containsKey("groupingID")) {
            this.groupingID = this.convertToLong(groupingDetails.get("groupingID"));
        }
        if (groupingDetails.containsKey("groupingUIID")) {
            this.groupingUIID = this.convertToInteger(groupingDetails.get("groupingUIID"));
        }
        if (groupingDetails.containsKey("maxNumberOfGroups")) {
            this.maxNumberOfGroups = this.convertToInteger(groupingDetails.get("maxNumberOfGroups"));
        }
        if (groupingDetails.containsKey("groupingType")) {
            this.groupingType = this.convertToInteger(groupingDetails.get("groupingType"));
        }
        if (groupingDetails.containsKey("staffGroupID")) {
            this.staffGroupID = this.convertToLong(groupingDetails.get("staffGroupID"));
        }
        if (groupingDetails.containsKey("numberOfGroups")) {
            this.numberOfGroups = this.convertToInteger(groupingDetails.get("numberOfGroups"));
        }
        if (groupingDetails.containsKey("learnersPerGroup")) {
            this.learnersPerGroup = this.convertToInteger(groupingDetails.get("learnersPerGroup"));
        }
    }

    public void processGroupingActivity(Object object) {
        if (object instanceof RandomGrouping) {
            this.addRandomGroupingAttributes((RandomGrouping)object);
        } else if (object instanceof ChosenGrouping) {
            this.addChosenGroupingAttributes((ChosenGrouping)object);
        } else {
            this.addLessonClassAttributes((LessonClass)object);
        }
    }

    private void addRandomGroupingAttributes(RandomGrouping grouping) {
        this.learnersPerGroup = grouping.getLearnersPerGroup();
        this.numberOfGroups = grouping.getNumberOfGroups();
    }

    private void addChosenGroupingAttributes(ChosenGrouping grouping) {
    }

    private void addLessonClassAttributes(LessonClass grouping) {
        this.staffGroupID = grouping.getStaffGroup().getGroupId();
    }

    public Long getGroupingID() {
        return this.groupingID != null ? this.groupingID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public void setGroupingID(Long groupingID) {
        if (!groupingID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.groupingID = groupingID;
        }
    }

    public Integer getGroupingType() {
        return this.groupingType != null ? this.groupingType : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setGroupingType(Integer groupingType) {
        if (!groupingType.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingType = groupingType;
        }
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID != null ? this.groupingUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        if (!groupingUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.groupingUIID = groupingUIID;
        }
    }

    public Integer getLearnersPerGroup() {
        return this.learnersPerGroup != null ? this.learnersPerGroup : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setLearnersPerGroup(Integer learnersPerGroup) {
        if (!learnersPerGroup.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.learnersPerGroup = learnersPerGroup;
        }
    }

    public Integer getMaxNumberOfGroups() {
        return this.maxNumberOfGroups != null ? this.maxNumberOfGroups : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setMaxNumberOfGroups(Integer maxNumberOfGroups) {
        if (!maxNumberOfGroups.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.maxNumberOfGroups = maxNumberOfGroups;
        }
    }

    public Integer getNumberOfGroups() {
        return this.numberOfGroups != null ? this.numberOfGroups : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setNumberOfGroups(Integer numberOfGroups) {
        if (!numberOfGroups.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.numberOfGroups = numberOfGroups;
        }
    }

    public Long getStaffGroupID() {
        return this.staffGroupID != null ? this.staffGroupID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public void setStaffGroupID(Long staffGroupID) {
        if (!staffGroupID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.staffGroupID = staffGroupID;
        }
    }
}

