/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Date;
import java.util.Hashtable;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class TransitionDTO
extends BaseDTO {
    private Long transitionId;
    private Integer transitionUIID;
    private Integer toUIID;
    private Integer fromUIID;
    private String description;
    private String title;
    private Date createDateTime;
    private Long toActivityID;
    private Long fromActivityID;
    private Long learningDesignID;

    public TransitionDTO() {
    }

    public TransitionDTO(Long transitionId, Integer transitionUIID, Integer toUIID, Integer fromUIID, String description, String title, Date createDateTime, Long toActivityID, Long fromActivityID, Long learningDesignID) {
        this.transitionId = transitionId;
        this.transitionUIID = transitionUIID;
        this.toUIID = toUIID;
        this.fromUIID = fromUIID;
        this.description = description;
        this.title = title;
        this.createDateTime = createDateTime;
        this.toActivityID = toActivityID;
        this.fromActivityID = fromActivityID;
        this.learningDesignID = learningDesignID;
    }

    public TransitionDTO(Transition transition) {
        this.transitionId = transition.getTransitionId();
        this.transitionUIID = transition.getTransitionUIID();
        this.toUIID = transition.getToUIID();
        this.fromUIID = transition.getFromUIID();
        this.description = transition.getDescription();
        this.title = transition.getTitle();
        this.createDateTime = transition.getCreateDateTime();
        this.toActivityID = transition.getToActivity().getActivityId();
        this.fromActivityID = transition.getFromActivity().getActivityId();
        this.learningDesignID = transition.getLearningDesign().getLearningDesignId();
    }

    public TransitionDTO(Hashtable transitionDetails) {
        if (transitionDetails.containsKey("transitionId")) {
            this.transitionId = this.convertToLong(transitionDetails.get("transitionId"));
        }
        if (transitionDetails.containsKey("transitionUIID")) {
            this.transitionUIID = this.convertToInteger(transitionDetails.get("transitionUIID"));
        }
        if (transitionDetails.containsKey("toUIID")) {
            this.toUIID = this.convertToInteger(transitionDetails.get("toUIID"));
        }
        if (transitionDetails.containsKey("fromUIID")) {
            this.fromUIID = this.convertToInteger(transitionDetails.get("fromUIID"));
        }
        if (transitionDetails.containsKey("description")) {
            this.description = (String)transitionDetails.get("description");
        }
        if (transitionDetails.containsKey("title")) {
            this.title = (String)transitionDetails.get("title");
        }
        if (transitionDetails.containsKey("createDateTime")) {
            this.createDateTime = (Date)transitionDetails.get("createDateTime");
        }
        if (transitionDetails.containsKey("toActivityID")) {
            this.toActivityID = this.convertToLong(transitionDetails.get("toActivityID"));
        }
        if (transitionDetails.containsKey("fromActivityID")) {
            this.fromActivityID = this.convertToLong(transitionDetails.get("fromActivityID"));
        }
        if (transitionDetails.containsKey("learningDesignID")) {
            this.learningDesignID = this.convertToLong(transitionDetails.get("learningDesignID"));
        }
    }

    public Date getCreateDateTime() {
        return this.createDateTime != null ? this.createDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Long getFromActivityID() {
        return this.fromActivityID != null ? this.fromActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getFromUIID() {
        return this.fromUIID != null ? this.fromUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID != null ? this.learningDesignID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getTitle() {
        return this.title != null ? this.title : "string_null_value";
    }

    public Long getToActivityID() {
        return this.toActivityID != null ? this.toActivityID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getToUIID() {
        return this.toUIID != null ? this.toUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getTransitionId() {
        return this.transitionId != null ? this.transitionId : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public Integer getTransitionUIID() {
        return this.transitionUIID != null ? this.transitionUIID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public void setCreateDateTime(Date createDateTime) {
        if (!createDateTime.equals(WDDXTAGS.DATE_NULL_VALUE)) {
            this.createDateTime = createDateTime;
        }
    }

    public void setDescription(String description) {
        if (!description.equals("string_null_value")) {
            this.description = description;
        }
    }

    public void setFromActivityID(Long fromActivityID) {
        if (!fromActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.fromActivityID = fromActivityID;
        }
    }

    public void setFromUIID(Integer fromUIID) {
        if (!fromUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.fromUIID = fromUIID;
        }
    }

    public void setLearningDesignID(Long learningDesignID) {
        if (!learningDesignID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.learningDesignID = learningDesignID;
        }
    }

    public void setTitle(String title) {
        if (!title.equals("string_null_value")) {
            this.title = title;
        }
    }

    public void setToActivityID(Long toActivityID) {
        if (!toActivityID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.toActivityID = toActivityID;
        }
    }

    public void setToUIID(Integer toUIID) {
        if (!toUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.toUIID = toUIID;
        }
    }

    public void setTransitionId(Long transitionId) {
        if (!transitionId.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            this.transitionId = transitionId;
        }
    }

    public void setTransitionUIID(Integer transitionUIID) {
        if (!transitionUIID.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            this.transitionUIID = transitionUIID;
        }
    }
}

