/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.lesson.dao.TestLearnerProgressDAO;

public class TestActivityStrategy
extends TestLearnerProgressDAO {
    private Activity testSubOptionsActivityNB;
    private Activity testSubOptionsActivityMC;
    private Activity testSubParallelActivityQA;
    private Activity testSubParallelActivityMB;
    private Activity testSubSeuquencActivitySR;
    private Activity testSubSeuqenceActivityQNA;
    protected static final Long TEST_NB_ACTIVITY_ID = new Long(16L);
    protected static final Long TEST_MC_ACTIVITY_ID = new Long(17L);
    protected static final Long TEST_QA_ACTIVITY_ID = new Long(18L);
    protected static final Long TEST_MB_ACTIVITY_ID = new Long(19L);
    protected static final Long TEST_SR_ACTIVITY_ID = new Long(22L);
    protected static final Long TEST_QNA_ACTIVITY_ID = new Long(25L);

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public TestActivityStrategy(String string) {
        super(string);
    }

    public void testChildrenCompletedForParallelActivity() {
        this.testSubParallelActivityQA = this.activityDAO.getActivityByActivityId(TEST_QA_ACTIVITY_ID);
        this.testSubParallelActivityMB = this.activityDAO.getActivityByActivityId(TEST_MB_ACTIVITY_ID);
        this.testLearnerProgress.setProgressState(this.testSubParallelActivityQA, (byte)1);
        this.testLearnerProgress.setProgressState(this.testSubParallelActivityMB, (byte)1);
        TestActivityStrategy.assertTrue((String)"should be completed", (boolean)this.testParallelActivity.areChildrenCompleted(this.testLearnerProgress));
    }

    public void testChildrenInCompletedForParallelActivity() {
        this.testSubParallelActivityQA = this.activityDAO.getActivityByActivityId(TEST_QA_ACTIVITY_ID);
        this.testLearnerProgress.setProgressState(this.testSubParallelActivityQA, (byte)1);
        TestActivityStrategy.assertTrue((String)"should not be completed", (!this.testParallelActivity.areChildrenCompleted(this.testLearnerProgress) ? 1 : 0) != 0);
    }

    public void testChildrenCompletedForSequenceActivity() {
        this.testSubSeuquencActivitySR = this.activityDAO.getActivityByActivityId(TEST_SR_ACTIVITY_ID);
        this.testSubSeuqenceActivityQNA = this.activityDAO.getActivityByActivityId(TEST_QNA_ACTIVITY_ID);
        this.testLearnerProgress.setProgressState(this.testSubSeuquencActivitySR, (byte)1);
        this.testLearnerProgress.setProgressState(this.testSubSeuqenceActivityQNA, (byte)1);
        TestActivityStrategy.assertTrue((String)"should be completed", (boolean)this.testSequenceActivity.areChildrenCompleted(this.testLearnerProgress));
    }

    public void testChildrenInCompletedForSequenceActivity() {
        this.testSubSeuquencActivitySR = this.activityDAO.getActivityByActivityId(TEST_SR_ACTIVITY_ID);
        this.testLearnerProgress.setProgressState(this.testSubSeuquencActivitySR, (byte)1);
        TestActivityStrategy.assertTrue((String)"should not be completed", (!this.testSequenceActivity.areChildrenCompleted(this.testLearnerProgress) ? 1 : 0) != 0);
    }

    public void testChildrenCompletedForOptionsActivity() {
        this.testSubOptionsActivityNB = this.activityDAO.getActivityByActivityId(TEST_NB_ACTIVITY_ID);
        this.testSubOptionsActivityMC = this.activityDAO.getActivityByActivityId(TEST_MC_ACTIVITY_ID);
        this.testLearnerProgress.setProgressState(this.testSubOptionsActivityNB, (byte)1);
        TestActivityStrategy.assertTrue((String)"should be completed", (boolean)this.testOptionsActivity.areChildrenCompleted(this.testLearnerProgress));
    }

    public void testChildrenInCompletedForOptionsActivity() {
        TestActivityStrategy.assertTrue((String)"should not be completed", (!this.testOptionsActivity.areChildrenCompleted(this.testLearnerProgress) ? 1 : 0) != 0);
    }

    public void testGetNextActivityBySequenceParentActivity() {
        this.testSubSeuquencActivitySR = this.activityDAO.getActivityByActivityId(TEST_SR_ACTIVITY_ID);
        this.testSubSeuqenceActivityQNA = this.activityDAO.getActivityByActivityId(TEST_QNA_ACTIVITY_ID);
        Activity activity = this.testSequenceActivity.getNextActivityByParent(this.testSubSeuquencActivitySR);
        TestActivityStrategy.assertNotNull((String)"we should have a next activity", (Object)activity);
        TestActivityStrategy.assertEquals((String)"it should be qna", (long)this.testSubSeuqenceActivityQNA.getActivityId(), (long)activity.getActivityId());
    }

    public void testGetFirstActivityWithinSequenceParentActivity() {
        this.testSubSeuquencActivitySR = this.activityDAO.getActivityByActivityId(TEST_SR_ACTIVITY_ID);
        Activity activity = this.testSequenceActivity.getNextActivityByParent(new NullActivity());
        TestActivityStrategy.assertNotNull((String)"we should have a next activity", (Object)activity);
        TestActivityStrategy.assertEquals((String)"it should be share resource", (long)this.testSubSeuquencActivitySR.getActivityId(), (long)activity.getActivityId());
    }

    public void testGetNextActivityByOptionsParentActivity() {
        this.testSubOptionsActivityNB = this.activityDAO.getActivityByActivityId(TEST_NB_ACTIVITY_ID);
        Activity activity = this.testOptionsActivity.getNextActivityByParent(this.testSubOptionsActivityNB);
        TestActivityStrategy.assertNotNull((String)"we should have a next activity", (Object)activity);
        TestActivityStrategy.assertEquals((String)"it should be option activity itself", (long)this.testOptionsActivity.getActivityId(), (long)activity.getActivityId());
    }

    public void testGetNextActivityByParallelParentActivity() {
        this.testSubParallelActivityQA = this.activityDAO.getActivityByActivityId(TEST_QA_ACTIVITY_ID);
        Activity activity = this.testParallelActivity.getNextActivityByParent(this.testSubParallelActivityQA);
        TestActivityStrategy.assertNotNull((String)"we should have a next activity", (Object)activity);
        TestActivityStrategy.assertTrue((String)"It should be kind of null activity", (boolean)activity.isNull());
        TestActivityStrategy.assertTrue((String)"It should waiting activity", (activity.getActivityTypeId() == -1 ? 1 : 0) != 0);
    }
}

