/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao;

import net.sf.hibernate.HibernateException;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.LessonDataAccessTestCase;

public class TestLearnerProgressDAO
extends LessonDataAccessTestCase {
    protected IActivityDAO activityDAO;
    protected Activity testToolActivity;
    protected Activity testParallelActivity;
    protected Activity testOptionsActivity;
    protected Activity testSequenceActivity;
    protected static final Long TEST_TOOL_ACTIVITY_ID = new Long(15L);
    protected static final Long TEST_PARALLEL_ACTIVITY_ID = new Long(13L);
    protected static final Long TEST_OPTIONS_ACTIVITY_ID = new Long(12L);
    protected static final Long TEST_SEQUENCE_ACTIVITY_ID = new Long(14L);

    protected void setUp() throws Exception {
        super.setUp();
        super.initializeTestLesson();
        super.initLearnerProgressData();
        this.activityDAO = (ActivityDAO)this.context.getBean("activityDAO");
        this.testToolActivity = this.activityDAO.getActivityByActivityId(TEST_TOOL_ACTIVITY_ID);
        this.testParallelActivity = this.activityDAO.getActivityByActivityId(TEST_PARALLEL_ACTIVITY_ID);
        this.testOptionsActivity = this.activityDAO.getActivityByActivityId(TEST_OPTIONS_ACTIVITY_ID);
        this.testSequenceActivity = this.activityDAO.getActivityByActivityId(TEST_SEQUENCE_ACTIVITY_ID);
    }

    protected void tearDown() throws Exception {
        super.cleanUpTestLesson();
        super.tearDown();
    }

    public TestLearnerProgressDAO(String string) {
        super(string);
    }

    public void testGetNullLearnerProgressByLearner() {
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        TestLearnerProgressDAO.assertNull((String)"should not get any progress data", (Object)learnerProgress);
    }

    public void testSaveLearnerProgress() throws HibernateException {
        this.learnerProgressDao.saveLearnerProgress(this.testLearnerProgress);
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        this.assertLearnerProgressInitialization(learnerProgress);
        this.learnerProgressDao.deleteLearnerProgress(this.testLearnerProgress);
        super.getSession().flush();
    }

    public void testDeleteLearnerProgress() throws HibernateException {
        this.learnerProgressDao.saveLearnerProgress(this.testLearnerProgress);
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgress(this.testLearnerProgress.getLearnerProgressId());
        this.assertLearnerProgressInitialization(learnerProgress);
        this.learnerProgressDao.deleteLearnerProgress(this.testLearnerProgress);
        super.getSession().flush();
        LearnerProgress learnerProgress2 = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        TestLearnerProgressDAO.assertNull((String)"should not get any progress data", (Object)learnerProgress2);
    }

    public void testGetLearnerProgressByLeaner() throws HibernateException {
        this.learnerProgressDao.saveLearnerProgress(this.testLearnerProgress);
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        this.assertLearnerProgressInitialization(learnerProgress);
        this.learnerProgressDao.deleteLearnerProgress(this.testLearnerProgress);
        super.getSession().flush();
    }

    public void testGetLearnerProgress() throws HibernateException {
        this.learnerProgressDao.saveLearnerProgress(this.testLearnerProgress);
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgress(this.testLearnerProgress.getLearnerProgressId());
        this.assertLearnerProgressInitialization(learnerProgress);
        this.learnerProgressDao.deleteLearnerProgress(this.testLearnerProgress);
        super.getSession().flush();
    }

    public void testUpdateLearnerProgress() throws HibernateException {
        this.learnerProgressDao.saveLearnerProgress(this.testLearnerProgress);
        LearnerProgress learnerProgress = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        Activity activity = this.testLesson.getLearningDesign().getFirstActivity();
        learnerProgress.setProgressState(activity, (byte)1);
        learnerProgress.setProgressState(this.testParallelActivity, (byte)1);
        learnerProgress.setProgressState(this.testToolActivity, (byte)2);
        learnerProgress.setRestarting(true);
        this.learnerProgressDao.updateLearnerProgress(learnerProgress);
        LearnerProgress learnerProgress2 = this.learnerProgressDao.getLearnerProgressByLearner(this.testUser, this.testLesson);
        this.assertLearnerProgressInitialization(learnerProgress);
        TestLearnerProgressDAO.assertEquals((String)"verify completed activity", (int)2, (int)learnerProgress2.getCompletedActivities().size());
        TestLearnerProgressDAO.assertEquals((String)"verify attempted activity", (int)1, (int)learnerProgress2.getAttemptedActivities().size());
        TestLearnerProgressDAO.assertTrue((String)"is restarting", (boolean)learnerProgress2.isRestarting());
        this.learnerProgressDao.deleteLearnerProgress(this.testLearnerProgress);
        super.getSession().flush();
    }

    private void assertLearnerProgressInitialization(LearnerProgress learnerProgress) {
        TestLearnerProgressDAO.assertNotNull((String)"There should be a learner progress", (Object)learnerProgress);
        TestLearnerProgressDAO.assertEquals((String)"verify user", (Object)learnerProgress.getUser().getUserId(), (Object)this.testUser.getUserId());
        TestLearnerProgressDAO.assertEquals((String)"verify Lesson", (Object)learnerProgress.getLesson().getLessonId(), (Object)this.testLesson.getLessonId());
    }
}

