/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class User
implements Serializable {
    private Integer userId;
    private String login;
    private String password;
    private String title;
    private String firstName;
    private String lastName;
    private String addressLine1;
    private String addressLine2;
    private String addressLine3;
    private String city;
    private String state;
    private String country;
    private String dayPhone;
    private String eveningPhone;
    private String mobilePhone;
    private String fax;
    private String email;
    private Boolean disabledFlag;
    private Date createDate;
    private Workspace workspace;
    private AuthenticationMethod authenticationMethod;
    private Set userOrganisations;
    private Organisation baseOrganisation;
    private Set learnerProgresses;
    private Set userToolSessions;
    private Set userGroups;
    private Set learningDesigns;
    private Set lessons;
    private String fullName;

    public User(String login, String password, String title, String firstName, String lastName, String addressLine1, String addressLine2, String addressLine3, String city, String state, String country, String dayPhone, String eveningPhone, String mobilePhone, String fax, String email, Boolean disabledFlag, Date createDate, Workspace workspace, AuthenticationMethod authenticationMethod, Set userOrganisations, Organisation baseOrganisation, Set learnerProgresses, Set userToolSessions, Set userGroups, Set learningDesigns, Set lessons) {
        this.login = login;
        this.password = password;
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressLine3 = addressLine3;
        this.city = city;
        this.state = state;
        this.country = country;
        this.dayPhone = dayPhone;
        this.eveningPhone = eveningPhone;
        this.mobilePhone = mobilePhone;
        this.fax = fax;
        this.email = email;
        this.disabledFlag = disabledFlag;
        this.createDate = createDate;
        this.workspace = workspace;
        this.authenticationMethod = authenticationMethod;
        this.userOrganisations = userOrganisations;
        this.baseOrganisation = baseOrganisation;
        this.learnerProgresses = learnerProgresses;
        this.userToolSessions = userToolSessions;
        this.userGroups = userGroups;
        this.learningDesigns = learningDesigns;
        this.lessons = lessons;
    }

    public User() {
    }

    public User(String login, String password, Boolean disabledFlag, Date createDate, Workspace workspace, AuthenticationMethod authenticationMethod, Set userOrganisations, Organisation baseOrganisation, Set learnerProgresses, Set userToolSessions, Set userGroups, Set learningDesigns, Set lessons) {
        this.login = login;
        this.password = password;
        this.disabledFlag = disabledFlag;
        this.createDate = createDate;
        this.workspace = workspace;
        this.authenticationMethod = authenticationMethod;
        this.userOrganisations = userOrganisations;
        this.baseOrganisation = baseOrganisation;
        this.learnerProgresses = learnerProgresses;
        this.userToolSessions = userToolSessions;
        this.userGroups = userGroups;
        this.learningDesigns = learningDesigns;
        this.lessons = lessons;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFullName() {
        return this.getFirstName() + ", " + this.getLastName();
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getDayPhone() {
        return this.dayPhone;
    }

    public void setDayPhone(String dayPhone) {
        this.dayPhone = dayPhone;
    }

    public String getEveningPhone() {
        return this.eveningPhone;
    }

    public void setEveningPhone(String eveningPhone) {
        this.eveningPhone = eveningPhone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getDisabledFlag() {
        return this.disabledFlag;
    }

    public void setDisabledFlag(Boolean disabledFlag) {
        this.disabledFlag = disabledFlag;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public Organisation getBaseOrganisation() {
        return this.baseOrganisation;
    }

    public void setBaseOrganisation(Organisation baseOrganisation) {
        this.baseOrganisation = baseOrganisation;
    }

    public Set getUserOrganisations() {
        return this.userOrganisations;
    }

    public void setUserOrganisations(Set userOrganisations) {
        this.userOrganisations = userOrganisations;
    }

    public void addUserOrganisation(UserOrganisation userOrganisation) {
        if (this.userOrganisations == null) {
            this.userOrganisations = new HashSet();
        }
        this.userOrganisations.add(userOrganisation);
    }

    public Set getLearnerProgresses() {
        return this.learnerProgresses;
    }

    public void setLearnerProgresses(Set learnerProgresses) {
        this.learnerProgresses = learnerProgresses;
    }

    public Set getUserToolSessions() {
        return this.userToolSessions;
    }

    public void setUserToolSessions(Set userToolSessions) {
        this.userToolSessions = userToolSessions;
    }

    public Set getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Set userGroups) {
        this.userGroups = userGroups;
    }

    public Set getLearningDesigns() {
        return this.learningDesigns;
    }

    public void setLearningDesigns(Set learningDesigns) {
        this.learningDesigns = learningDesigns;
    }

    public Set getLessons() {
        return this.lessons;
    }

    public void setLessons(Set lessons) {
        this.lessons = lessons;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", (Object)this.getUserId()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof User)) {
            return false;
        }
        User castOther = (User)other;
        return new EqualsBuilder().append((Object)this.getUserId(), (Object)castOther.getUserId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getUserId()).toHashCode();
    }

    public UserDTO getUserDTO() {
        return new UserDTO(this.userId, this.firstName, this.lastName, this.login);
    }

    public boolean isMember(Organisation organisation) {
        Iterator iterator = this.userOrganisations.iterator();
        while (iterator.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)iterator.next();
            Integer organisationID = userOrganisation.getOrganisation().getOrganisationId();
            if (organisationID != organisation.getOrganisationId()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMemberAccess(WorkspaceFolder workspaceFolder) {
        Iterator iterator = this.userOrganisations.iterator();
        while (iterator.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)iterator.next();
            Integer folderID = userOrganisation.getOrganisation().getWorkspace().getRootFolder().getWorkspaceFolderId();
            if (folderID != workspaceFolder.getWorkspaceFolderId()) continue;
            return true;
        }
        return false;
    }
}

