/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class OrganisationDAO
extends HibernateDaoSupport
implements IOrganisationDAO {
    private static final String TABLENAME = "lams_organisation";
    private static final String FIND_BY_WORKSPACE = "from lams_organisation in class " + (class$org$lamsfoundation$lams$usermanagement$Organisation == null ? (class$org$lamsfoundation$lams$usermanagement$Organisation = OrganisationDAO.class$("org.lamsfoundation.lams.usermanagement.Organisation")) : class$org$lamsfoundation$lams$usermanagement$Organisation).getName() + " where workspace_id=?";
    static /* synthetic */ Class class$org$lamsfoundation$lams$usermanagement$Organisation;

    public List getAllOrganisations() {
        return this.getHibernateTemplate().find("from Organisation");
    }

    public Organisation getOrganisationById(Integer organisationId) {
        return (Organisation)this.getHibernateTemplate().get(class$org$lamsfoundation$lams$usermanagement$Organisation == null ? (class$org$lamsfoundation$lams$usermanagement$Organisation = OrganisationDAO.class$("org.lamsfoundation.lams.usermanagement.Organisation")) : class$org$lamsfoundation$lams$usermanagement$Organisation, (Serializable)organisationId);
    }

    public List getOrganisationsByName(String name) {
        String queryString = "from Organisation o where o.name=?";
        return this.getHibernateTemplate().find(queryString, (Object)name);
    }

    public List getChildOrganisations(Organisation parentOrg) {
        String queryString = "from Organisation o where o.parentOrganisation.organisationId=?";
        return this.getHibernateTemplate().find(queryString, (Object)parentOrg.getOrganisationId());
    }

    public void saveOrganisation(Organisation organisation) {
        this.getHibernateTemplate().save((Object)organisation);
    }

    public void updateOrganisation(Organisation organisation) {
        this.getHibernateTemplate().update((Object)organisation);
    }

    public void saveOrUpdateOrganisation(Organisation organisation) {
        this.getHibernateTemplate().saveOrUpdate((Object)organisation);
    }

    public void deleteOrganisation(Organisation organisation) {
        Iterator iter = organisation.getChildOrganisations().iterator();
        Organisation parentOrganisation = organisation.getParentOrganisation();
        while (iter.hasNext()) {
            Organisation childOrganisation = (Organisation)iter.next();
            childOrganisation.setParentOrganisation(parentOrganisation);
            iter.remove();
        }
        this.getHibernateTemplate().delete((Object)organisation);
    }

    public void deleteOrganisationById(Integer organisationId) {
        this.deleteOrganisation(this.getOrganisationById(organisationId));
    }

    public Organisation getOrganisationByWorkspaceID(Integer workspaceID) {
        List list = this.getHibernateTemplate().find(FIND_BY_WORKSPACE, (Object)workspaceID);
        if (list.size() != 0) {
            return (Organisation)list.get(0);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

