/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.Date;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.AuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.OrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.RoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserOrganisationRoleDAO;

public class UserDAOTest
extends AbstractLamsTestCase {
    private User user = null;
    private UserDAO userDAO = null;
    protected RoleDAO roleDAO;
    protected OrganisationDAO organisationDAO;
    protected OrganisationTypeDAO organisationTypeDAO;
    protected AuthenticationMethodDAO authenticationMethodDAO;
    protected UserOrganisationDAO userOrganisationDAO;
    protected UserOrganisationRoleDAO userOrganisationRoleDAO;

    public UserDAOTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.userDAO = (UserDAO)this.context.getBean("userDAO");
        this.organisationDAO = (OrganisationDAO)this.context.getBean("organisationDAO");
        this.organisationTypeDAO = (OrganisationTypeDAO)this.context.getBean("organisationTypeDAO");
        this.authenticationMethodDAO = (AuthenticationMethodDAO)this.context.getBean("authenticationMethodDAO");
        this.roleDAO = (RoleDAO)this.context.getBean("roleDAO");
        this.userOrganisationDAO = (UserOrganisationDAO)this.context.getBean("userOrganisationDAO");
        this.userOrganisationRoleDAO = (UserOrganisationRoleDAO)this.context.getBean("userOrganisationRoleDAO");
    }

    public void testGetUser() {
        this.user = this.userDAO.getUserById(new Integer(2));
        UserDAOTest.assertNotNull((Object)this.user.getLogin());
    }

    public void testIsMember() {
        Organisation organisation = this.organisationDAO.getOrganisationById(new Integer(4));
        this.user = this.userDAO.getUserById(new Integer(4));
        boolean bl = this.user.isMember(organisation);
        UserDAOTest.assertTrue((boolean)bl);
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"WEB-INF/spring/applicationContext.xml", "WEB-INF/spring/learningDesignApplicationContext.xml"};
    }

    public void testSaveUser() {
        User user = new User();
        user.setLogin("MiniMinhas");
        user.setPassword("MiniMinhas");
        user.setDisabledFlag(new Boolean(false));
        user.setCreateDate(new Date());
        user.setAuthenticationMethod(this.authenticationMethodDAO.getAuthenticationMethodById(new Integer(2)));
        user.setBaseOrganisation(this.organisationDAO.getOrganisationById(new Integer(1)));
        this.userDAO.saveUser(user);
        this.createUserOrganisation(user);
    }

    private Integer createUserOrganisation(User user) {
        UserOrganisation userOrganisation = new UserOrganisation();
        userOrganisation.setOrganisation(user.getBaseOrganisation());
        userOrganisation.setUser(user);
        this.userOrganisationDAO.saveUserOrganisation(userOrganisation);
        userOrganisation.addUserOrganisationRole(this.createUserOrganisationRole(userOrganisation));
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
        return userOrganisation.getUserOrganisationId();
    }

    private UserOrganisationRole createUserOrganisationRole(UserOrganisation userOrganisation) {
        UserOrganisationRole userOrganisationRole = new UserOrganisationRole();
        userOrganisationRole.setUserOrganisation(userOrganisation);
        userOrganisationRole.setRole(this.roleDAO.getRoleByName("STAFF"));
        this.userOrganisationRoleDAO.saveUserOrganisationRole(userOrganisationRole);
        return userOrganisationRole;
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }
}

