/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IAuthenticationMethodDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationTypeDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;

public class UserManagementService
implements IUserManagementService {
    private IUserDAO userDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IOrganisationTypeDAO organisationTypeDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    private IUserOrganisationRoleDAO userOrganisationRoleDAO;
    private IAuthenticationMethodDAO authenticationMethodDAO;
    protected IWorkspaceDAO workspaceDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected ILearningDesignDAO learningDesignDAO;
    private FlashMessage flashMessage;

    public void setWorkspaceFolderDAO(IWorkspaceFolderDAO workspaceFolderDAO) {
        this.workspaceFolderDAO = workspaceFolderDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOrganisationTypeDAO(IOrganisationTypeDAO organisationTypeDAO) {
        this.organisationTypeDAO = organisationTypeDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    public void setUserOrganisationRoleDAO(IUserOrganisationRoleDAO userOrganisationRoleDAO) {
        this.userOrganisationRoleDAO = userOrganisationRoleDAO;
    }

    public void setAuthenticationMethodDAO(IAuthenticationMethodDAO authenticationMethodDAO) {
        this.authenticationMethodDAO = authenticationMethodDAO;
    }

    public User getUserById(Integer userId) {
        return this.userDAO.getUserById(userId);
    }

    public User getUserByLogin(String login) {
        return this.userDAO.getUserByLogin(login);
    }

    public Organisation getOrganisationById(Integer organisationId) {
        return this.organisationDAO.getOrganisationById(organisationId);
    }

    public OrganisationType getOrganisationTypeByName(String name) {
        return this.organisationTypeDAO.getOrganisationTypeByName(name);
    }

    public Organisation getBaseOrganisation(Organisation organisation) {
        if (organisation.getOrganisationType().getName().equals("ROOT ORGANISATION")) {
            return null;
        }
        if (organisation.getOrganisationType().getName().equals("BASE ORGANISATION")) {
            return organisation;
        }
        return this.getBaseOrganisation(organisation.getParentOrganisation());
    }

    public Role getRoleByName(String roleName) {
        return this.roleDAO.getRoleByName(roleName);
    }

    public UserOrganisationRole getUserOrganisationRole(String login, Integer organisationId, String roleName) {
        User user = this.userDAO.getUserByLogin(login);
        if (user == null) {
            return null;
        }
        UserOrganisation userOrganisation = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), organisationId);
        if (userOrganisation == null) {
            return null;
        }
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            return null;
        }
        return this.userOrganisationRoleDAO.getUserOrganisationRole(userOrganisation.getUserOrganisationId(), role.getRoleId());
    }

    public UserOrganisation getUserOrganisation(Integer userId, Integer organisationId) {
        return this.userOrganisationDAO.getUserOrganisation(userId, organisationId);
    }

    public List getAllAuthenticationMethods() {
        return this.authenticationMethodDAO.getAllAuthenticationMethods();
    }

    public AuthenticationMethod getAuthenticationMethodForUser(String login) {
        return this.authenticationMethodDAO.getAuthenticationMethodByUser(this.userDAO.getUserByLogin(login));
    }

    public AuthenticationMethod getAuthenticationMethodByName(String name) {
        return this.authenticationMethodDAO.getAuthenticationMethodByName(name);
    }

    public List getUserOrganisationsForUser(User user) {
        return this.userOrganisationDAO.getUserOrganisationsByUser(user);
    }

    public List getOrganisationsForUserByRole(User user, String roleName) {
        ArrayList<Organisation> list = new ArrayList<Organisation>();
        Iterator i = this.userOrganisationDAO.getUserOrganisationsByUser(user).iterator();
        while (i.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)i.next();
            Iterator i2 = userOrganisation.getUserOrganisationRoles().iterator();
            while (i2.hasNext()) {
                UserOrganisationRole userOrgansiationRole = (UserOrganisationRole)i2.next();
                if (!userOrgansiationRole.getRole().getName().equals(roleName)) continue;
                list.add(userOrgansiationRole.getUserOrganisation().getOrganisation());
            }
        }
        return list;
    }

    public List getChildOrganisations(Organisation parentOrg) {
        return this.organisationDAO.getChildOrganisations(parentOrg);
    }

    public List getRolesForUserByOrganisation(User user, Integer orgId) {
        ArrayList<Role> list = new ArrayList<Role>();
        UserOrganisation userOrg = this.userOrganisationDAO.getUserOrganisation(user.getUserId(), orgId);
        if (userOrg == null) {
            return null;
        }
        Iterator i = this.userOrganisationRoleDAO.getUserOrganisationRoles(userOrg.getUserOrganisationId()).iterator();
        while (i.hasNext()) {
            UserOrganisationRole userOrgRole = (UserOrganisationRole)i.next();
            list.add(userOrgRole.getRole());
        }
        return list;
    }

    public List getUsersFromOrganisation(Integer orgId) {
        ArrayList<User> list = new ArrayList<User>();
        Iterator i = this.userOrganisationDAO.getUserOrganisationsByOrganisationId(orgId).iterator();
        while (i.hasNext()) {
            UserOrganisation userOrganisation = (UserOrganisation)i.next();
            list.add(userOrganisation.getUser());
        }
        return list;
    }

    public void createUser(User user) {
        this.userDAO.saveUser(user);
    }

    public void updateUser(User user) {
        this.userDAO.updateUser(user);
    }

    public void saveOrUpdateUser(User user) {
        this.userDAO.saveOrUpdateUser(user);
    }

    public void updatePassword(String login, String newPassword) {
        this.userDAO.updatePassword(login, newPassword);
    }

    public void removeUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.deleteUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateOrganisation(Organisation organisation) {
        this.organisationDAO.saveOrUpdateOrganisation(organisation);
    }

    public void saveOrUpdateUserOrganisation(UserOrganisation userOrganisation) {
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
    }

    public void saveOrUpdateUserOrganisationRole(UserOrganisationRole userOrganisationRole) {
        this.userOrganisationRoleDAO.saveOrUpdateUserOrganisationRole(userOrganisationRole);
    }

    public void setWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public Integer saveOrganisation(Organisation organisation, Integer userID) {
        Workspace workspace = this.createWorkspace(organisation.getName());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, userID, WorkspaceFolder.NORMAL);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        organisation.setWorkspace(workspace);
        this.organisationDAO.saveOrganisation(organisation);
        return organisation.getOrganisationId();
    }

    public Workspace createWorkspace(String name) {
        Workspace workspace = new Workspace(name);
        this.workspaceDAO.insert(workspace);
        return workspace;
    }

    public WorkspaceFolder createWorkspaceFolder(Workspace workspace, Integer userID, Integer workspaceFolderType) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(workspace.getName(), workspace.getWorkspaceId(), userID, new Date(), new Date(), workspaceFolderType);
        this.workspaceFolderDAO.insert(workspaceFolder);
        return workspaceFolder;
    }

    public Integer saveUser(User user, Integer roleID) {
        this.userDAO.saveUser(user);
        this.createUserOrganisation(user, roleID);
        Workspace workspace = this.createWorkspace(user.getLogin());
        WorkspaceFolder workspaceFolder = this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.NORMAL);
        WorkspaceFolder runSequencesFolder = this.createWorkspaceFolder(workspace, user.getUserId(), WorkspaceFolder.RUN_SEQUENCES);
        workspace.setRootFolder(workspaceFolder);
        this.workspaceDAO.update(workspace);
        user.setWorkspace(workspace);
        this.userDAO.updateUser(user);
        return user.getUserId();
    }

    private Integer createUserOrganisation(User user, Integer roleID) {
        UserOrganisation userOrganisation = new UserOrganisation();
        userOrganisation.setOrganisation(user.getBaseOrganisation());
        userOrganisation.setUser(user);
        this.userOrganisationDAO.saveUserOrganisation(userOrganisation);
        userOrganisation.addUserOrganisationRole(this.createUserOrganisationRole(userOrganisation, roleID));
        this.userOrganisationDAO.saveOrUpdateUserOrganisation(userOrganisation);
        return userOrganisation.getUserOrganisationId();
    }

    private UserOrganisationRole createUserOrganisationRole(UserOrganisation userOrganisation, Integer roleID) {
        UserOrganisationRole userOrganisationRole = new UserOrganisationRole();
        userOrganisationRole.setUserOrganisation(userOrganisation);
        userOrganisationRole.setRole(this.roleDAO.getRoleById(roleID));
        this.userOrganisationRoleDAO.saveUserOrganisationRole(userOrganisationRole);
        return userOrganisationRole;
    }

    public void getFolderContents(Integer userID, Integer workspaceFolderID) {
    }

    public String moveLearningDesign(Long learningDesignID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (learningDesign != null) {
            WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetWorkspaceFolderID);
            if (workspaceFolder != null) {
                learningDesign.setWorkspaceFolder(workspaceFolder);
                this.learningDesignDAO.update(learningDesign);
                this.flashMessage = new FlashMessage("moveLearningDesign", targetWorkspaceFolderID);
            } else {
                this.flashMessage = new FlashMessage("moveLearningDesign", "No such target workspaceFolder with a workspace_folder_id of :" + targetWorkspaceFolderID + " exists", 1);
            }
        } else {
            this.flashMessage = new FlashMessage("moveLearningDesign", "No such learning design with a learning_design_id of:" + learningDesignID + " exists", 1);
        }
        return this.flashMessage.serializeMessage();
    }

    public void moveWorkspaceFolder(Integer currentWorkspaceFolderID, Integer targetWorkspaceFolderID, Integer userID) {
        WorkspaceFolder currentWorkspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(currentWorkspaceFolderID);
        WorkspaceFolder targetWorkspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(targetWorkspaceFolderID);
        if (currentWorkspaceFolder != null && targetWorkspaceFolder != null) {
            currentWorkspaceFolder.setParentWorkspaceFolder(targetWorkspaceFolder);
            this.workspaceFolderDAO.update(currentWorkspaceFolder);
        }
    }

    public void renameFolder(Integer workspaceFolderID, String newName, Integer userID) {
        WorkspaceFolder workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
        if (workspaceFolder != null) {
            workspaceFolder.setName(newName);
            this.workspaceFolderDAO.update(workspaceFolder);
        }
    }

    public void renameLearningDesign(Long learningDesignID, String title, Integer userID) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        if (learningDesign != null) {
            learningDesign.setTitle(title);
            this.learningDesignDAO.update(learningDesign);
        }
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public String getWorkspace(Integer userID) throws IOException {
        User user = this.userDAO.getUserById(userID);
        if (user != null) {
            Workspace workspace = user.getWorkspace();
            this.flashMessage = new FlashMessage("getWorkspace", workspace.getWorkspaceDTO());
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("getWorkspace", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getWDDXForOrganisationsForUserByRole(Integer userID, String roleName) throws IOException {
        User user = this.userDAO.getUserById(userID);
        Vector<OrganisationDTO> organisations = new Vector<OrganisationDTO>();
        if (user != null) {
            Iterator iterator = this.getOrganisationsForUserByRole(user, roleName).iterator();
            while (iterator.hasNext()) {
                Organisation organisation = (Organisation)iterator.next();
                organisations.add(organisation.getOrganisationDTO());
            }
            this.flashMessage = new FlashMessage("getWDDXForOrganisationsForUserByRole", organisations);
        } else {
            this.flashMessage = FlashMessage.getNoSuchUserExists("getWDDXForOrganisationsForUserByRole", userID);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getUsersFromOrganisationByRole(Integer organisationID, String roleName) throws IOException {
        Vector<UserDTO> users = new Vector<UserDTO>();
        Organisation organisation = this.organisationDAO.getOrganisationById(organisationID);
        if (organisation != null) {
            Iterator iterator = organisation.getUserOrganisations().iterator();
            while (iterator.hasNext()) {
                UserOrganisation userOrganisation = (UserOrganisation)iterator.next();
                Iterator userOrganisationRoleIterator = userOrganisation.getUserOrganisationRoles().iterator();
                while (userOrganisationRoleIterator.hasNext()) {
                    UserOrganisationRole userOrganisationRole = (UserOrganisationRole)userOrganisationRoleIterator.next();
                    if (!userOrganisationRole.getRole().getName().equals(roleName)) continue;
                    users.add(userOrganisation.getUser().getUserDTO());
                }
            }
            this.flashMessage = new FlashMessage("getUsersFromOrganisationByRole", users);
        } else {
            this.flashMessage = new FlashMessage("getUsersFromOrganisationByRole", "No such Organisation with an organisation_id of:" + organisationID + " exists", 1);
        }
        return this.flashMessage.serializeMessage();
    }
}

