/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.util;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;

public class AdminPreparer {
    public static void prepare(Organisation org, HttpServletRequest request, UserManagementService service) {
        UserOrganisationRole userOrgRole = null;
        if (org.getParentOrganisation() != null) {
            userOrgRole = service.getUserOrganisationRole(request.getRemoteUser(), org.getParentOrganisation().getOrganisationId(), "ADMIN");
        }
        List childOrgs = service.getChildOrganisations(org);
        for (int i = 0; i < childOrgs.size(); ++i) {
            Organisation childOrg = (Organisation)childOrgs.get(i);
            if (service.getUserOrganisationRole(request.getRemoteUser(), childOrg.getOrganisationId(), "ADMIN") != null) continue;
            childOrgs.remove(i);
        }
        if (childOrgs.size() != 0) {
            HashSet childOrganisations = new HashSet();
            childOrganisations.addAll(childOrgs);
            org.setChildOrganisations(childOrganisations);
        } else {
            org.setChildOrganisations(null);
        }
        request.setAttribute("organisation", (Object)org);
        if (userOrgRole != null) {
            request.setAttribute("parentAccess", (Object)"true");
        }
    }
}

