/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.util;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.fileupload.FileItem;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.util.IUserImportFileParser;

public class ExcelUserImportFileParser
implements IUserImportFileParser {
    private static final short LOGIN = 0;
    private static final short PASSWORD = 1;
    private static final short AUTH_METHOD = 2;
    private static final short ROLE = 3;
    private static final short STATUS = 4;
    private static final short TITLE = 5;
    private static final short FIRST_NAME = 6;
    private static final short LAST_NAME = 7;
    private static final short EMAIL = 8;
    private static final short ADDRESS1 = 9;
    private static final short ADDRESS2 = 10;
    private static final short ADDRESS3 = 11;
    private static final short CITY = 12;
    private static final short STATE = 13;
    private static final short COUNTRY = 14;
    private static final short DAY_PHONE = 15;
    private static final short EVE_PHONE = 16;
    private static final short MOB_PHONE = 17;
    private static final short FAX = 18;
    private static String[] errMsgArray = new String[]{"Login is required.", "Password is required.", "Authentication method is required.", "Role is required."};
    private boolean emptyRow;
    private boolean hasError;
    private String errMsgForRow;
    private IUserManagementService service;

    public ExcelUserImportFileParser(IUserManagementService service) {
        this.service = service;
    }

    public String parseUsersInOrganisation(FileItem fileItem, Organisation org, String adminLogin, boolean existingUsersOnly) throws IOException {
        String errorMessage = "";
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        int count = 0;
        Object cell = null;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            Iterator iter;
            this.emptyRow = true;
            this.hasError = false;
            this.errMsgForRow = "";
            HSSFRow row = sheet.getRow(i);
            User user = new User();
            Set roles = null;
            user.setLogin(this.parseStringCell(row.getCell((short)0), i, 0));
            if (existingUsersOnly) {
                if ((user = this.service.getUserByLogin(user.getLogin())) == null) {
                    this.errMsgForRow = this.errMsgForRow + "<br>Row " + i + ": Skipped. Error was: " + this.parseStringCell(row.getCell((short)0), i, 0) + " does not exist! ";
                    this.hasError = true;
                } else {
                    List userOrgs = this.service.getUserOrganisationsForUser(user);
                    iter = userOrgs.iterator();
                    boolean userOrgExisted = false;
                    boolean authorised = false;
                    while (iter.hasNext()) {
                        UserOrganisation userOrg = (UserOrganisation)iter.next();
                        if (userOrg.getOrganisation().getOrganisationId().equals(org.getOrganisationId())) {
                            userOrgExisted = true;
                            break;
                        }
                        User admin = this.service.getUserByLogin(adminLogin);
                        Iterator iter2 = this.service.getUserOrganisationsForUser(admin).iterator();
                        while (iter2.hasNext()) {
                            UserOrganisation adminOrg = (UserOrganisation)iter2.next();
                            if (!adminOrg.getOrganisation().getOrganisationId().equals(userOrg.getOrganisation().getOrganisationId())) continue;
                            authorised = true;
                            break;
                        }
                        if (!authorised) continue;
                        break;
                    }
                    if (!authorised) {
                        this.errMsgForRow = this.errMsgForRow + "<br>Row " + i + ": Skipped. Error was: " + this.parseStringCell(row.getCell((short)0), i, 0) + "<br>You are not authorised to select the user!";
                        this.hasError = true;
                    }
                    if (userOrgExisted) {
                        this.errMsgForRow = this.errMsgForRow + "<br>Row " + i + ": Skipped. Error was: " + this.parseStringCell(row.getCell((short)0), i, 0) + " is already a member of the current org: " + org.getName();
                        this.hasError = true;
                    }
                    roles = this.parseRoleCell(row.getCell((short)3), i, 3);
                }
            } else {
                user.setPassword(this.parseStringCell(row.getCell((short)1), i, 1));
                user.setAuthenticationMethod(this.parseAuthMethodCell(row.getCell((short)2), i, 2));
                roles = this.parseRoleCell(row.getCell((short)3), i, 3);
                user.setDisabledFlag(this.parseStatusCell(row.getCell((short)4), i));
                user.setTitle(this.parseStringCell(row.getCell((short)5), i, -1));
                user.setFirstName(this.parseStringCell(row.getCell((short)6), i, -1));
                user.setLastName(this.parseStringCell(row.getCell((short)7), i, -1));
                user.setEmail(this.parseStringCell(row.getCell((short)8), i, -1));
                user.setAddressLine1(this.parseStringCell(row.getCell((short)9), i, -1));
                user.setAddressLine2(this.parseStringCell(row.getCell((short)10), i, -1));
                user.setAddressLine3(this.parseStringCell(row.getCell((short)11), i, -1));
                user.setCity(this.parseStringCell(row.getCell((short)12), i, -1));
                user.setState(this.parseStringCell(row.getCell((short)13), i, -1));
                user.setCountry(this.parseStringCell(row.getCell((short)14), i, -1));
                user.setDayPhone(this.parseStringCell(row.getCell((short)15), i, -1));
                user.setEveningPhone(this.parseStringCell(row.getCell((short)16), i, -1));
                user.setMobilePhone(this.parseStringCell(row.getCell((short)17), i, -1));
                user.setFax(this.parseStringCell(row.getCell((short)18), i, -1));
            }
            if (this.emptyRow) break;
            if (this.hasError) {
                errorMessage = errorMessage + this.errMsgForRow;
                continue;
            }
            try {
                if (!existingUsersOnly) {
                    user.setCreateDate(new Date());
                    user.setBaseOrganisation(this.service.getBaseOrganisation(org));
                    this.service.createUser(user);
                }
                UserOrganisation userOrg = new UserOrganisation();
                userOrg.setUser(user);
                userOrg.setOrganisation(org);
                this.service.saveOrUpdateUserOrganisation(userOrg);
                iter = roles.iterator();
                while (iter.hasNext()) {
                    UserOrganisationRole userOrgRole = new UserOrganisationRole();
                    userOrgRole.setUserOrganisation(userOrg);
                    userOrgRole.setRole((Role)iter.next());
                    this.service.saveOrUpdateUserOrganisationRole(userOrgRole);
                }
                ++count;
                continue;
            }
            catch (Exception e) {
                this.errMsgForRow = this.errMsgForRow + "<br>Row " + i + ": Failed to add " + user.getLogin() + ": Skipped. Error was: " + e.getMessage();
                errorMessage = errorMessage + this.errMsgForRow;
            }
        }
        return count + " user(s) have been added successfully!" + errorMessage;
    }

    private String parseStringCell(HSSFCell cell, int row, int msgIndex) {
        if (msgIndex != -1 && cell == null) {
            if (this.hasError) {
                this.errMsgForRow = this.errMsgForRow + errMsgArray[msgIndex];
            } else {
                this.errMsgForRow = this.errMsgForRow + "<br>Row " + row + ": Skipped. Error was: " + errMsgArray[msgIndex];
                this.hasError = true;
            }
            return null;
        }
        if (cell != null) {
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() != null) {
                    if (cell.getStringCellValue().trim().length() != 0) {
                        this.emptyRow = false;
                    }
                } else {
                    return null;
                }
                return cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                cell.setCellType(0);
                double d = cell.getNumericCellValue();
                this.emptyRow = false;
                return new Long(new Double(d).longValue()).toString();
            }
        }
        return null;
    }

    private AuthenticationMethod parseAuthMethodCell(HSSFCell cell, int row, int msgIndex) {
        String authMethodName = this.parseStringCell(cell, row, msgIndex);
        if (authMethodName == null) {
            return null;
        }
        return this.service.getAuthenticationMethodByName(authMethodName);
    }

    private Set parseRoleCell(HSSFCell cell, int row, int msgIndex) {
        Role role;
        String roleDescription = "";
        if (msgIndex != -1 && cell == null) {
            if (this.hasError) {
                this.errMsgForRow = this.errMsgForRow + errMsgArray[msgIndex];
            } else {
                this.errMsgForRow = this.errMsgForRow + "<br>Row " + row + ": Skipped. Error was: " + errMsgArray[msgIndex];
                this.hasError = true;
            }
            return null;
        }
        if (cell != null) {
            try {
                cell.setCellType(1);
                if (cell.getStringCellValue() != null) {
                    if (cell.getStringCellValue().trim().length() != 0) {
                        this.emptyRow = false;
                    }
                } else {
                    return null;
                }
                roleDescription = cell.getStringCellValue().trim();
            }
            catch (Exception e) {
                return null;
            }
        }
        HashSet<Role> roles = new HashSet<Role>();
        int fromIndex = 0;
        int index = roleDescription.indexOf("|", fromIndex);
        while (index != -1) {
            role = this.service.getRoleByName(roleDescription.substring(fromIndex, index));
            if (role != null) {
                roles.add(role);
            }
            fromIndex = index + 1;
            index = roleDescription.indexOf("|", fromIndex);
        }
        role = this.service.getRoleByName(roleDescription.substring(fromIndex, roleDescription.length()));
        if (role != null) {
            roles.add(role);
        }
        return roles;
    }

    private Boolean parseStatusCell(HSSFCell cell, int row) {
        String status = this.parseStringCell(cell, row, -1);
        return new Boolean("disabled".equals(status));
    }
}

