/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.usermanagement.util.AdminPreparer;
import org.lamsfoundation.lams.usermanagement.util.ExcelUserImportFileParser;
import org.lamsfoundation.lams.usermanagement.web.OrganisationActionForm;
import org.lamsfoundation.lams.usermanagement.web.UserActionForm;
import org.lamsfoundation.lams.usermanagement.web.UsersAddActionForm;
import org.lamsfoundation.lams.usermanagement.web.UsersRemoveActionForm;
import org.lamsfoundation.lams.util.UploadFileUtil;
import org.lamsfoundation.lams.web.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AdminAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$usermanagement$web$AdminAction == null ? (class$org$lamsfoundation$lams$usermanagement$web$AdminAction = AdminAction.class$("org.lamsfoundation.lams.usermanagement.web.AdminAction")) : class$org$lamsfoundation$lams$usermanagement$web$AdminAction));
    private static WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
    private static UserManagementService service = (UserManagementService)ctx.getBean("userManagementServiceTarget");
    static /* synthetic */ Class class$org$lamsfoundation$lams$usermanagement$web$AdminAction;

    public ActionForward getAdmin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getAdmin");
        Integer orgId = null;
        try {
            if (request.getParameter("orgId") != null) {
                orgId = new Integer(request.getParameter("orgId").trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean error = false;
        if (orgId == null) {
            log.error((Object)"There is no 'orgId' parameter in the request");
            error = true;
        } else {
            Organisation org = service.getOrganisationById(orgId);
            if (org != null) {
                log.debug((Object)("Copying properties from org " + org.toString()));
                AdminPreparer.prepare(org, request, service);
            } else {
                log.error((Object)("Organisation id " + orgId + " not found"));
                error = true;
            }
        }
        return mapping.findForward(error ? "error" : "admin");
    }

    public ActionForward getOrganisationEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getOrganisationEdit");
        Integer orgId = null;
        try {
            if (request.getParameter("orgId") != null) {
                orgId = new Integer(request.getParameter("orgId").trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean error = false;
        OrganisationActionForm orgForm = new OrganisationActionForm();
        if (orgId == null) {
            log.error((Object)"There is no 'orgId' parameter in the request");
            error = true;
        } else if (orgId == -1) {
            orgForm.setOrgId(new Integer(-1));
            orgForm.setName("");
            orgForm.setDescription("");
            Integer parentOrgId = new Integer(request.getParameter("parentOrgId").trim());
            Organisation parent = service.getOrganisationById(parentOrgId);
            if (parent != null) {
                orgForm.setParentOrgId(parent.getOrganisationId());
                orgForm.setParentOrgName(parent.getName());
            } else {
                log.error((Object)"Creating new top level organisation (parent organisation id not found)");
                error = true;
            }
        } else {
            Organisation org = service.getOrganisationById(orgId);
            if (org != null) {
                log.debug((Object)("Copying properties from org " + org.toString()));
                orgForm.setOrgId(org.getOrganisationId());
                orgForm.setName(org.getName());
                orgForm.setDescription(org.getDescription());
            } else {
                log.error((Object)("Organisation id " + orgId + " not found"));
                error = true;
            }
        }
        request.getSession(true).setAttribute("OrganisationActionForm", (Object)orgForm);
        return mapping.findForward(error ? "error" : "organisation");
    }

    public ActionForward importUsersFromFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean error = false;
        if (request.getParameter("orgId") == null) {
            error = true;
            log.error((Object)"There is no 'orgId' parameter in the reuqest");
        } else {
            Integer orgId = new Integer(request.getParameter("orgId").trim());
            Organisation org = service.getOrganisationById(orgId);
            FileItem fileToUpload = null;
            String errorMessage = null;
            List items = null;
            try {
                items = UploadFileUtil.getUploadItems(request, false, null);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    log.debug((Object)("Request item: " + item.toString()));
                    if (item.getName() == null || item.getSize() == 0L) continue;
                    fileToUpload = item;
                }
                if (fileToUpload == null) {
                    error = true;
                    log.error((Object)"There is no file uploaded");
                } else {
                    ExcelUserImportFileParser parser = new ExcelUserImportFileParser(service);
                    boolean existingUsersOnly = request.getParameter("existingUsersOnly").equals("true");
                    errorMessage = parser.parseUsersInOrganisation(fileToUpload, org, request.getRemoteUser(), existingUsersOnly);
                }
            }
            catch (FileUploadException fue) {
                log.error((Object)"Unable to upload file. Exception occured: ", (Throwable)fue);
                errorMessage = "Unable to upload file. Error was:" + fue.getMessage();
            }
            catch (IOException e) {
                log.error((Object)("IOException happened when processing uploaded file: " + e));
                errorMessage = "IOException happened when processing uploaded file: " + e.getMessage();
            }
            catch (Exception e) {
                log.error((Object)("Exception happened when uploading file: " + e));
                errorMessage = "Exception happened when uploading file: " + e.getMessage();
            }
            AdminPreparer.prepare(org, request, service);
            if (errorMessage != null) {
                request.setAttribute("errormsg", (Object)errorMessage);
            }
        }
        return mapping.findForward(error ? "error" : "admin");
    }

    public ActionForward getUserEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getUserEdit");
        Integer editUserId = null;
        String adminUserLogin = null;
        try {
            if (request.getParameter("userid") != null) {
                editUserId = new Integer(request.getParameter("userid").trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        UserActionForm newForm = null;
        boolean error = false;
        try {
            adminUserLogin = request.getRemoteUser();
            Integer orgId = null;
            try {
                if (request.getParameter("orgId") != null) {
                    orgId = new Integer(request.getParameter("orgId").trim());
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Organisation org = service.getOrganisationById(orgId);
            if (org == null) {
                log.error((Object)("implUserEdit: Organisation not found " + orgId));
                error = true;
            } else {
                request.setAttribute("organisation", (Object)org);
                User user = null;
                if (editUserId == null) {
                    editUserId = new Integer(-1);
                } else {
                    user = service.getUserById(editUserId);
                }
                newForm = user != null ? this.setupEditUserActionForm(editUserId, org, user) : this.setupNewUserActionForm(org);
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        log.debug((Object)("getUserEdit: Form is " + newForm.toMap().toString()));
        request.getSession(true).setAttribute("UserActionForm", (Object)newForm);
        return mapping.findForward(error ? "error" : "user");
    }

    private UserActionForm setupNewUserActionForm(Organisation org) {
        UserActionForm newForm = new UserActionForm();
        newForm.setOrgId(org.getOrganisationId());
        newForm.setCreateNew(true);
        newForm.setDisabledFlag(new Boolean(false));
        newForm.setCreateDate(new Date());
        newForm.setRoleNames(new String[0]);
        newForm.setNewMembershipOrganisationId(org.getOrganisationId());
        newForm.setAllAuthMethods(service.getAllAuthenticationMethods());
        newForm.setNewMembershipOrgName(org.getName());
        return newForm;
    }

    private UserActionForm setupEditUserActionForm(Integer editUserId, Organisation org, User user) throws IllegalAccessException, InvocationTargetException {
        UserActionForm newForm = new UserActionForm();
        BeanUtils.copyProperties((Object)((Object)newForm), (Object)user);
        newForm.setPasswordConfirm(newForm.getPassword());
        newForm.setOrgId(org.getOrganisationId());
        newForm.setOtherMemberships(service.getUserOrganisationsForUser(user));
        newForm.setAllAuthMethods(service.getAllAuthenticationMethods());
        newForm.setCreateNew(false);
        newForm.setRoleNames(this.getRoleNames(user, org.getOrganisationId()));
        return newForm;
    }

    private String[] getRoleNames(User user, Integer orgId) {
        String[] rolenames = new String[service.getRolesForUserByOrganisation(user, orgId).size()];
        Iterator iter = service.getRolesForUserByOrganisation(user, orgId).iterator();
        int i = 0;
        while (iter.hasNext()) {
            Role role = (Role)iter.next();
            rolenames[i] = role.getName();
            ++i;
        }
        return rolenames;
    }

    public ActionForward getUsersAdd(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"getUsersAdd");
        Integer orgId = null;
        try {
            if (request.getParameter("orgId") != null) {
                orgId = new Integer(request.getParameter("orgId").trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        UsersAddActionForm newForm = null;
        boolean error = false;
        if (orgId == null) {
            log.error((Object)"getUsersAdd: Missing parameter orgId");
            error = true;
        } else {
            newForm = this.setupOrgAddUserForm(request, orgId);
        }
        if (newForm == null || error) {
            request.getSession(true).removeAttribute("UsersAddActionForm");
            return mapping.findForward("error");
        }
        request.getSession(true).setAttribute("UsersAddActionForm", (Object)newForm);
        return mapping.findForward("usersadd");
    }

    private UsersAddActionForm setupOrgAddUserForm(HttpServletRequest request, Integer orgId) {
        boolean error = false;
        UsersAddActionForm newForm = new UsersAddActionForm();
        try {
            Organisation org = service.getOrganisationById(orgId);
            if (org != null) {
                log.debug((Object)("Copying properties from org " + org.toString()));
                newForm.setName(org.getName());
                newForm.setDescription(org.getDescription());
                newForm.setOrgId(org.getOrganisationId());
            } else {
                log.error((Object)("getUsersAdd: Organisation not found or not available to this user. Id #=" + orgId));
                error = true;
            }
            User adminUser = service.getUserByLogin(request.getRemoteUser());
            List userOrgs = service.getUserOrganisationsForUser(adminUser);
            newForm.setAvailableOrgs(this.getOrgsWithAdminRole(userOrgs, org));
            newForm.setSelectedOrgId(new Integer(-1));
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            error = true;
        }
        if (error) {
            newForm = null;
            return null;
        }
        return newForm;
    }

    private List getOrgsWithAdminRole(List userOrgs, Organisation currentOrg) {
        ArrayList<Organisation> orgs = new ArrayList<Organisation>();
        Iterator iter = userOrgs.iterator();
        while (iter.hasNext()) {
            UserOrganisation userOrg = (UserOrganisation)iter.next();
            List roles = service.getRolesForUserByOrganisation(userOrg.getUser(), userOrg.getOrganisation().getOrganisationId());
            if (userOrg.getOrganisation().getOrganisationId().equals(currentOrg.getOrganisationId())) continue;
            Iterator iter2 = roles.iterator();
            while (iter2.hasNext()) {
                Role role = (Role)iter2.next();
                if (!role.getName().equals("ADMIN")) continue;
                orgs.add(userOrg.getOrganisation());
            }
        }
        return orgs;
    }

    public ActionForward getUsersRemove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getUsersRemove");
        Integer orgId = null;
        try {
            if (request.getParameter("orgId") != null) {
                orgId = new Integer(request.getParameter("orgId").trim());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        UsersRemoveActionForm newForm = new UsersRemoveActionForm();
        log.debug((Object)("orgId=" + orgId));
        boolean error = false;
        if (orgId == null) {
            log.error((Object)"getOrganisationAddUsers: Missing parameter orgId");
            error = true;
        } else {
            Organisation org = service.getOrganisationById(orgId);
            if (org != null) {
                log.debug((Object)("Copying properties from org " + org.toString()));
                newForm.setName(org.getName());
                newForm.setDescription(org.getDescription());
                newForm.setOrgId(org.getOrganisationId());
                List users = service.getUsersFromOrganisation(orgId);
                for (int i = 0; i < users.size(); ++i) {
                    User user = (User)users.get(i);
                    if (!user.getLogin().equals(request.getRemoteUser())) continue;
                    users.remove(i);
                }
                newForm.setUsers(users);
            } else {
                log.error((Object)("getUsersRemove: Organisation not found or not available to this user. Id #=" + orgId));
                error = true;
            }
        }
        request.getSession(true).setAttribute("UsersRemoveActionForm", (Object)newForm);
        return mapping.findForward(error ? "error" : "usersremove");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

