/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.wddx;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class LDWDDXValueObjectFactory {
    static LDWDDXValueObjectFactory factory = null;
    protected ActivityDAO activityDAO;
    protected ToolDAO toolDAO;

    public LDWDDXValueObjectFactory() {
    }

    public LDWDDXValueObjectFactory(ActivityDAO activityDAO, ToolDAO toolDAO) {
        this.activityDAO = activityDAO;
        this.toolDAO = toolDAO;
    }

    public static LDWDDXValueObjectFactory getInstance() {
        return factory == null ? new LDWDDXValueObjectFactory() : factory;
    }

    public Hashtable requestLearningLibraryList(Collection learningLibraries) {
        Hashtable<String, Object> libraryList = new Hashtable<String, Object>();
        libraryList.put("objectType", "LearningLibraryList");
        libraryList.put("title", "Learning Libraries");
        libraryList.put("description", "All available system libraries");
        Vector<Hashtable> libraries = new Vector<Hashtable>();
        if (learningLibraries != null) {
            Iterator iter = learningLibraries.iterator();
            while (iter.hasNext()) {
                LearningLibrary library = (LearningLibrary)iter.next();
                Hashtable output = this.buildLearningLibraryObject(library);
                libraries.add(output);
            }
        }
        libraryList.put("libraries", libraries);
        return libraryList;
    }

    private Hashtable buildLearningLibraryObject(LearningLibrary library) {
        Hashtable<String, Object> libraries = new Hashtable<String, Object>();
        Long libraryID = library.getLearningLibraryId();
        libraries.put("learning_library_id", libraryID);
        libraries.put("description", library.getDescription() != null ? library.getDescription() : "string_null_value");
        libraries.put("title", library.getTitle() != null ? library.getTitle() : "string_null_value");
        libraries.put("create_date_time", library.getCreateDateTime() != null ? library.getCreateDateTime() : WDDXTAGS.DATE_NULL_VALUE);
        List coll = this.activityDAO.getActivitiesByLibraryID(libraryID);
        Vector<Hashtable> templateActivities = new Vector<Hashtable>();
        if (coll != null) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                Hashtable output = this.buildActivityObject(object);
                this.addAuthoringURLS(object, output);
                templateActivities.add(output);
            }
        }
        libraries.put("templateActivities", templateActivities);
        return libraries;
    }

    private void addAuthoringURLS(Object activity, Hashtable output) {
        if (activity.getClass().getName().equals("org.lamsfoundation.lams.learningdesign.ToolActivity")) {
            ToolActivity toolActivity = (ToolActivity)activity;
            Tool tool = toolActivity.getTool();
            Hashtable toolOutput = this.buildToolObject(tool);
            output.put("authoringURLS", toolOutput);
        }
    }

    private Hashtable buildToolObject(Tool tool) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("objectType", "Tool");
        table.put("tool_id", tool.getToolId());
        table.put("displayName", tool.getToolDisplayName());
        table.put("toolAuthoringURL", tool.getAuthorUrl());
        return table;
    }

    private void processActivityType(Hashtable activities, Object activity) {
        String className = activity.getClass().getName();
        if (activity instanceof GroupingActivity) {
            this.buildGroupingActivityObject(activities, activity);
        } else if (activity instanceof ToolActivity) {
            this.buildToolActivity(activities, (ToolActivity)activity);
        } else if (activity instanceof GateActivity) {
            this.buildGateActivityObject(activities, activity);
        } else {
            this.buildComplexActivityObject(activities, activity);
        }
    }

    public Hashtable buildActivityObject(Object objActivity) {
        Hashtable activities = LDWDDXValueObjectFactory.getCutDownActivityDetails(objActivity);
        this.processActivityType(activities, objActivity);
        Activity activity = (Activity)objActivity;
        activities.put("help_text", activity.getHelpText() != null ? activity.getHelpText() : "string_null_value");
        activities.put("parent_activity_id", activity.getParentActivity() != null ? activity.getParentActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        activities.put("parent_activity_ui_id", activity.getParentActivity() != null ? activity.getParentActivity().getActivityUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("learning_activity_type_id", activity.getActivityTypeId() != null ? activity.getActivityTypeId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("grouping_id", activity.getGrouping() != null ? activity.getGrouping().getGroupingId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        activities.put("grouping_ui_id", activity.getGrouping() != null ? activity.getGrouping().getGroupingUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("define_later_flag", activity.getDefineLater());
        activities.put("run_offline", activity.getRunOffline());
        activities.put("learning_design_id", activity.getLearningDesign() != null ? activity.getLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        activities.put("learning_library_id", activity.getLearningLibrary() != null ? activity.getLearningLibrary().getLearningLibraryId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        if (activity.getCreateDateTime() != null) {
            activities.put("create_date_time", activity.getCreateDateTime());
        }
        activities.put("offline_instructions", activity.getOfflineInstructions() != null ? activity.getOfflineInstructions() : "string_null_value");
        if (activity.getLibraryActivityUiImage() != null) {
            activities.put("library_activity_ui_image", activity.getLibraryActivityUiImage());
        }
        activities.put("library_activity_id", activity.getLibraryActivity() != null ? activity.getLibraryActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        return activities;
    }

    private void buildGroupingActivityObject(Hashtable activities, Object activity) {
        GroupingActivity groupingActivity = (GroupingActivity)activity;
        Grouping grouping = groupingActivity.getCreateGrouping();
        Integer groupingType = grouping.getGroupingTypeId();
        Hashtable groupingTable = null;
        groupingTable = groupingType == Grouping.CHOSEN_GROUPING_TYPE ? this.addChosenGroupingAttributes((ChosenGrouping)grouping) : this.addRandomGroupingAttributes((RandomGrouping)grouping);
        groupingTable.put("max_number_of_groups", grouping.getMaxNumberOfGroups());
        groupingTable.put("grouping_ui_id", grouping.getGroupingUIID());
        activities.put("create_grouping_id", grouping.getGroupingId());
        activities.put("create_grouping_ui_id", grouping.getGroupingUIID());
        activities.put("grouping", groupingTable);
    }

    private Hashtable addChosenGroupingAttributes(ChosenGrouping chosenGrouping) {
        return new Hashtable();
    }

    private Hashtable addRandomGroupingAttributes(RandomGrouping randomGrouping) {
        Hashtable<String, Integer> groupingTable = new Hashtable<String, Integer>();
        groupingTable.put("number_of_groups", randomGrouping.getNumberOfGroups());
        groupingTable.put("learners_per_group", randomGrouping.getLearnersPerGroup());
        return groupingTable;
    }

    private void buildToolActivity(Hashtable activities, ToolActivity toolActivity) {
        activities.put("order_id", toolActivity.getOrderId() != null ? toolActivity.getOrderId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        if (toolActivity.getTool() != null) {
            activities.put("tool_id", toolActivity.getTool().getToolId());
        }
        if (toolActivity.getToolContentId() != null) {
            activities.put("tool_content_id", toolActivity.getToolContentId());
        }
    }

    private void buildOptionsActivityObject(Hashtable activities, OptionsActivity optActivity) {
        if (optActivity.getMaxNumberOfOptions() != null) {
            activities.put("max_number_of_options", optActivity.getMaxNumberOfOptions());
        }
        if (optActivity.getMinNumberOfOptions() != null) {
            activities.put("min_number_of_options", optActivity.getMinNumberOfOptions());
        }
        activities.put("options_instructions", optActivity.getOptionsInstructions() != null ? optActivity.getOptionsInstructions() : "string_null_value");
        Iterator iter = optActivity.getActivities().iterator();
        this.addChildActivities(activities, iter);
    }

    private void buildSequenceActivityObject(Hashtable activities, SequenceActivity sequenceActivity) {
    }

    private void buildParallelActivityObject(Hashtable activities, ParallelActivity parallelActivity) {
    }

    private void buildScheduleGateActivityObject(Hashtable activities, ScheduleGateActivity schActivity) {
        if (schActivity.getGateEndTimeOffset() != null) {
            activities.put("gate_end_time_offset", schActivity.getGateEndTimeOffset());
        }
        if (schActivity.getGateStartTimeOffset() != null) {
            activities.put("gate_start_time_offset", schActivity.getGateStartTimeOffset());
        }
        activities.put("gate_end_date_time", schActivity.getGateEndDateTime() != null ? schActivity.getGateEndDateTime() : WDDXTAGS.DATE_NULL_VALUE);
        activities.put("gate_start_date_time", schActivity.getGateStartDateTime() != null ? schActivity.getGateStartDateTime() : WDDXTAGS.DATE_NULL_VALUE);
    }

    private void buildGateActivityObject(Hashtable activities, Object activity) {
        if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivityObject(activities, (PermissionGateActivity)activity);
        } else if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivityObject(activities, (SynchGateActivity)activity);
        } else {
            this.buildScheduleGateActivityObject(activities, (ScheduleGateActivity)activity);
        }
        GateActivity gateActivity = (GateActivity)activity;
        activities.put("gate_activity_level_id", gateActivity.getGateActivityLevelId() != null ? gateActivity.getGateActivityLevelId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("gate_open", gateActivity.getGateOpen() != null ? gateActivity.getGateOpen() : WDDXTAGS.BOOLEAN_NULL_VALUE);
    }

    private void buildPermissionGateActivityObject(Hashtable activities, PermissionGateActivity permissionGateActivity) {
    }

    private void buildSynchGateActivityObject(Hashtable activities, SynchGateActivity synchGateActivity) {
    }

    private void buildComplexActivityObject(Hashtable activities, Object activity) {
        if (activity instanceof OptionsActivity) {
            this.buildOptionsActivityObject(activities, (OptionsActivity)activity);
        } else if (activity instanceof SequenceActivity) {
            this.buildSequenceActivityObject(activities, (SequenceActivity)activity);
        } else {
            this.buildParallelActivityObject(activities, (ParallelActivity)activity);
        }
        ComplexActivity complexActivity = (ComplexActivity)activity;
        Iterator iter = complexActivity.getActivities().iterator();
        this.addChildActivities(activities, iter);
    }

    private void addChildActivities(Hashtable activities, Iterator iter) {
        Vector<Hashtable> childActivities = new Vector<Hashtable>();
        while (iter.hasNext()) {
            Object object = iter.next();
            childActivities.add(this.buildActivityObject(object));
        }
        activities.put("childActivities", childActivities);
    }

    public static Hashtable buildTransitionObject(Transition trans) {
        Hashtable<String, Object> transitions = new Hashtable<String, Object>();
        transitions.put("transition_id", trans.getTransitionId());
        transitions.put("transition_ui_id", trans.getTransitionUIID() != null ? trans.getTransitionUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        if (trans.getDescription() != null) {
            transitions.put("description", trans.getDescription());
        }
        if (trans.getTitle() != null) {
            transitions.put("title", trans.getTitle());
        }
        transitions.put("to_activity_id", trans.getToActivity() != null ? trans.getToActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        transitions.put("from_activity_id", trans.getFromActivity() != null ? trans.getFromActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        transitions.put("learning_design_id", trans.getLearningDesign() != null ? trans.getLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        transitions.put("to_activity_ui_id", trans.getToUIID() != null ? trans.getToUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        transitions.put("from_activity_ui_id", trans.getFromUIID() != null ? trans.getFromUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        return transitions;
    }

    public Hashtable requestLearningDesignList(Collection learningDesigns) {
        Hashtable<String, Object> designList = new Hashtable<String, Object>();
        designList.put("objectType", "LearningDesignList");
        designList.put("title", "Learning Designs");
        designList.put("description", "All available Learning Designs");
        Vector<Hashtable> designs = new Vector<Hashtable>();
        if (learningDesigns != null) {
            Iterator iter = learningDesigns.iterator();
            while (iter.hasNext()) {
                LearningDesign design = (LearningDesign)iter.next();
                Hashtable output = this.buildLearningDesignObject(design);
                designs.add(output);
            }
        }
        designList.put("designs", designs);
        return designList;
    }

    public Hashtable buildLearningDesignObject(LearningDesign design) {
        Hashtable designs = LDWDDXValueObjectFactory.getCutDownLearningDesignDetails(design);
        designs.put("learning_design_ui_id", design.getLearningDesignUIID() != null ? design.getLearningDesignUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        designs.put("valid_design_flag", design.getValidDesign());
        designs.put("read_only_flag", design.getReadOnly());
        if (design.getDateReadOnly() != null) {
            designs.put("date_read_only", design.getDateReadOnly());
        }
        designs.put("user_id", design.getUser().getUserId());
        designs.put("version", design.getVersion() != null ? design.getVersion() : "string_null_value");
        designs.put("parent_learning_design_id", design.getParentLearningDesign() != null ? design.getParentLearningDesign().getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        designs.put("workspace_folder_id", design.getWorkspaceFolder().getWorkspaceFolderId());
        designs.put("duration", design.getDuration() != null ? design.getDuration() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        Set coll = design.getActivities();
        HashSet<Activity> parentActivities = new HashSet<Activity>();
        Iterator iter = null;
        if (coll != null) {
            iter = coll.iterator();
            while (iter.hasNext()) {
                Activity activity = (Activity)iter.next();
                if (activity.getParentActivity() != null) continue;
                parentActivities.add(activity);
            }
        }
        iter = parentActivities.iterator();
        Vector<Hashtable> activities = new Vector<Hashtable>();
        while (iter.hasNext()) {
            Object object = iter.next();
            Hashtable output = this.buildActivityObject(object);
            activities.add(output);
        }
        designs.put("activities", activities);
        coll = design.getTransitions();
        Vector<Hashtable> transitions = new Vector<Hashtable>();
        if (coll != null) {
            iter = coll.iterator();
            while (iter.hasNext()) {
                Transition trans = (Transition)iter.next();
                Hashtable output = LDWDDXValueObjectFactory.buildTransitionObject(trans);
                transitions.add(output);
            }
        }
        designs.put("transitions", transitions);
        return designs;
    }

    public static Hashtable getCutDownActivityDetails(Object objActivity) {
        Hashtable<String, Object> activities = new Hashtable<String, Object>();
        activities.put("objectType", "Activity");
        Activity activity = (Activity)objActivity;
        activities.put("activity_id", activity.getActivityId());
        activities.put("learning_activity_type_id", activity.getActivityCategoryID() != null ? activity.getActivityCategoryID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("activity_ui_id", activity.getActivityUIID() != null ? activity.getActivityUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("description", activity.getDescription() != null ? activity.getDescription() : "string_null_value");
        activities.put("title", activity.getTitle() != null ? activity.getTitle() : "string_null_value");
        activities.put("xcoord", activity.getXcoord() != null ? activity.getXcoord() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        activities.put("ycoord", activity.getYcoord() != null ? activity.getYcoord() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        return activities;
    }

    public static Hashtable getCutDownLearningDesignDetails(LearningDesign design) {
        Hashtable<String, Object> designs = new Hashtable<String, Object>();
        designs.put("objectType", "LearningDesign");
        designs.put("learning_design_id", design.getLearningDesignId() != null ? design.getLearningDesignId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        designs.put("description", design.getDescription() != null ? design.getDescription() : "string_null_value");
        designs.put("title", design.getTitle() != null ? design.getTitle() : "string_null_value");
        designs.put("first_activity_id", design.getFirstActivity() != null ? design.getFirstActivity().getActivityId() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        designs.put("first_activity_ui_id", design.getFirstActivity() != null ? design.getFirstActivity().getActivityUIID() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        designs.put("max_id", design.getMaxId() != null ? design.getMaxId() : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER);
        designs.put("help_text", design.getHelpText() != null ? design.getHelpText() : "string_null_value");
        designs.put("version", design.getVersion() != null ? design.getVersion() : "string_null_value");
        designs.put("license_id", design.getLicense() != null ? design.getLicense().getLicenseID() : WDDXTAGS.NUMERIC_NULL_VALUE_LONG);
        designs.put("license_text", design.getLicenseText() != null ? design.getLicenseText() : "string_null_value");
        return designs;
    }
}

