/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.wddx;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.UserDAO;
import org.lamsfoundation.lams.usermanagement.dao.hibernate.WorkspaceFolderDAO;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

public class LDWDDXValueObjectStorer {
    static LDWDDXValueObjectStorer storer = null;
    protected UserDAO userDAO = null;
    protected LearningDesignDAO learningDesignDAO = null;
    protected ActivityDAO activityDAO = null;
    protected WorkspaceFolderDAO workspaceFolderDAO = null;
    protected LearningLibraryDAO learningLibraryDAO = null;
    protected LicenseDAO licenseDAO;
    protected GroupingDAO groupingDAO;
    protected ToolDAO toolDAO;

    public LDWDDXValueObjectStorer() {
    }

    public LDWDDXValueObjectStorer(LearningDesignDAO learningDesignDAO, LearningLibraryDAO learningLibraryDAO, UserDAO userDAO, ActivityDAO activityDAO, WorkspaceFolderDAO workspaceFolderDAO, LicenseDAO licenseDAO, GroupingDAO groupingDAO) {
        this.learningDesignDAO = learningDesignDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.userDAO = userDAO;
        this.activityDAO = activityDAO;
        this.workspaceFolderDAO = workspaceFolderDAO;
        this.licenseDAO = licenseDAO;
        this.groupingDAO = groupingDAO;
    }

    public static LDWDDXValueObjectStorer getInstance() {
        return storer == null ? new LDWDDXValueObjectStorer() : storer;
    }

    public Long processLearningDesign(Hashtable table) throws Exception {
        boolean readOnly;
        Long learning_design_id = null;
        Object oldDesignID = null;
        LearningDesign learningDesign = null;
        boolean update = false;
        if (table.containsKey("learning_design_id")) {
            update = true;
            learning_design_id = WDDXProcessor.convertToLong("learning_design_id", table.get("learning_design_id"));
            learningDesign = this.learningDesignDAO.getLearningDesignById(learning_design_id);
            if (learningDesign == null) {
                throw new Exception("Learning Design with the given learning_design_id " + learning_design_id + " doesn't exists. Update Failed!!");
            }
        } else {
            learningDesign = new LearningDesign();
        }
        if (readOnly = WDDXProcessor.convertToBoolean("readOnly", table.get("read_only_flag")).booleanValue()) {
            throw new Exception("This design is locked, you cannot save or update it.\nPlease click on File | Save as... and rename it to save it");
        }
        if (!table.containsKey("first_activity_ui_id")) {
            throw new Exception("Mandatory Field first_id is missing");
        }
        Integer firstID = WDDXProcessor.convertToInteger("first_activity_ui_id", table.get("first_activity_ui_id"));
        this.updateLearningDesign(table, learningDesign);
        if (update) {
            this.learningDesignDAO.update(learningDesign);
        } else {
            this.learningDesignDAO.insert(learningDesign);
            this.updateDesignActivities(table, learningDesign);
        }
        if (learningDesign.getValidDesign().booleanValue()) {
            this.calculateFirstActivity(firstID, learningDesign);
        }
        return learningDesign.getLearningDesignId();
    }

    private void updateDesignActivities(Hashtable table, LearningDesign learningDesign) throws Exception {
        Vector activities = (Vector)table.get("activities");
        Iterator iter = activities.iterator();
        HashSet<Activity> designActivities = new HashSet<Activity>();
        while (iter.hasNext()) {
            Hashtable activity = (Hashtable)iter.next();
            activity.put("learning_design_id", learningDesign.getLearningDesignId());
            designActivities.add(this.processActivity(activity, learningDesign));
        }
        learningDesign.setActivities(designActivities);
        this.learningDesignDAO.update(learningDesign);
    }

    private void calculateFirstActivity(Integer firstID, LearningDesign design) throws Exception {
        Activity flashFirstActivity = this.activityDAO.getActivityByUIID(firstID, design);
        Activity designFirstActivity = design.calculateFirstActivity();
        if (flashFirstActivity.getActivityId() != designFirstActivity.getActivityId()) {
            throw new Exception("First Activity Conflict. We have two first activities here");
        }
        design.setFirstActivity(flashFirstActivity);
    }

    private void updateDesignTransitions(Hashtable table, LearningDesign learningDesign) throws Exception {
        if (table.containsKey("transitions")) {
            Vector transitions = (Vector)table.get("transitions");
            Iterator iter = transitions.iterator();
            HashSet<Hashtable> designTransitions = new HashSet<Hashtable>();
            while (iter.hasNext()) {
                Hashtable transition = (Hashtable)iter.next();
                transition.put("learning_design_id", learningDesign.getLearningDesignId());
                designTransitions.add(transition);
            }
            learningDesign.setTransitions(designTransitions);
            this.learningDesignDAO.update(learningDesign);
        }
    }

    private Transition processTransitionObject(Hashtable table) throws Exception {
        Activity activity;
        Long activityID;
        Transition transition = new Transition();
        if (table.containsKey("transition_ui_id")) {
            transition.setTransitionUIID(WDDXProcessor.convertToInteger("transition_ui_id", table.get("transition_ui_id")));
        }
        if (table.containsKey("description")) {
            transition.setDescription((String)table.get("description"));
        }
        if (table.containsKey("title")) {
            transition.setTitle("title");
        }
        if (table.containsKey("to_activity_id")) {
            activityID = WDDXProcessor.convertToLong("to_activity_id", table.get("to_activity_id"));
            activity = this.activityDAO.getActivityByActivityId(activityID);
            if (activity != null) {
                transition.setToActivity(activity);
            } else {
                throw new Exception("Error setting to_activity_id. No activity with an activity_id of " + activityID + " exists");
            }
        }
        if (table.containsKey("from_activity_id")) {
            activityID = WDDXProcessor.convertToLong("from_activity_id", table.get("from_activity_id"));
            activity = this.activityDAO.getActivityByActivityId(activityID);
            if (activity != null) {
                transition.setFromActivity(activity);
            } else {
                throw new Exception("Error setting from_activity_id. No activity with an activity_id of " + activityID + " exists");
            }
        }
        if (table.containsKey("create_date_time")) {
            transition.setCreateDateTime((Date)table.get("create_date_time"));
        }
        if (table.containsKey("to_activity_ui_id")) {
            transition.setToUIID(WDDXProcessor.convertToInteger("to_activity_ui_id", table.get("to_activity_ui_id")));
        }
        if (table.containsKey("from_activity_ui_id")) {
            transition.setFromUIID(WDDXProcessor.convertToInteger("from_activity_ui_id", table.get("from_activity_ui_id")));
        }
        return transition;
    }

    public void updateLearningDesign(Hashtable table, LearningDesign design) throws Exception {
        try {
            WorkspaceFolder workspaceFolder;
            User user;
            if (table.containsKey("learning_design_ui_id")) {
                design.setLearningDesignUIID(WDDXProcessor.convertToInteger("learning_design_ui_id", table.get("learning_design_ui_id")));
            }
            if (table.containsKey("title")) {
                design.setTitle((String)table.get("title"));
            }
            if (table.containsKey("description")) {
                design.setDescription((String)table.get("description"));
            }
            if (table.containsKey("first_activity_id")) {
                Long firstActivityID = WDDXProcessor.convertToLong("first_activity_id", table.get("first_activity_id"));
                Activity activity = this.activityDAO.getActivityByActivityId(firstActivityID);
                if (activity == null) {
                    throw new Exception("No activity with an activity_id: first_activity_id exists.");
                }
                design.setFirstActivity(activity);
            }
            if (!table.containsKey("version")) {
                throw new Exception("Mandatory field version is missing for LearningDesign in the WDDX packet");
            }
            design.setVersion((String)table.get("version"));
            if (table.containsKey("max_id")) {
                design.setMaxId(WDDXProcessor.convertToInteger("max_id", table.get("max_id")));
            }
            if (!table.containsKey("valid_design_flag")) {
                throw new Exception("Mandatory field valid_design_flag is missing for LearningDesign in the WDDX packet");
            }
            design.setValidDesign(WDDXProcessor.convertToBoolean("valid_design_flag", table.get("valid_design_flag")));
            if (!table.containsKey("read_only_flag")) {
                throw new Exception("Mandatory field read_only_flag is missing for LearningDesign in the WDDX packet");
            }
            design.setReadOnly(WDDXProcessor.convertToBoolean("read_only_flag", table.get("read_only_flag")));
            if (table.containsKey("date_read_only")) {
                design.setDateReadOnly((Date)table.get("date_read_only"));
            }
            if (table.containsKey("help_text")) {
                design.setHelpText((String)table.get("help_text"));
            }
            if (!table.containsKey("copy_type_id")) {
                throw new Exception("Mandatory field copy_type is missing for LearningDesign in the WDDX packet");
            }
            design.setCopyTypeID(WDDXProcessor.convertToInteger("copy_type", table.get("copy_type_id")));
            if (!table.containsKey("create_date_time")) {
                throw new Exception("Mandatory field create_date_time is missing for LearningDesign in the WDDX packet");
            }
            design.setCreateDateTime((Date)table.get("create_date_time"));
            if (table.containsKey("user_id")) {
                Integer userId = WDDXProcessor.convertToInteger("user_id", table.get("user_id"));
                user = this.userDAO.getUserById(userId);
                if (user == null) {
                    throw new Exception("No user with a user_id: user_id exists.");
                }
            } else {
                throw new Exception("Mandatory Field user_id is missing for LearningDesign in the WDDX packet");
            }
            design.setUser(user);
            if (table.containsKey("workspace_folder_id")) {
                Integer workspaceFolderID = WDDXProcessor.convertToInteger("workspace_folder_id", table.get("workspace_folder_id"));
                workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(workspaceFolderID);
                if (workspaceFolder == null) {
                    throw new Exception("No workspaceFolder with a  with workspace_folder_id: workspace_folder_id exists.");
                }
            } else {
                throw new Exception("Mandatory Field workspace_folder_id is missing for LearningDesign in the WDDX packet");
            }
            design.setWorkspaceFolder(workspaceFolder);
            if (table.containsKey("parent_learning_design_id")) {
                Long parentDesignID = WDDXProcessor.convertToLong("parent_learning_design_id", table.get("parent_learning_design_id"));
                LearningDesign parent = this.learningDesignDAO.getLearningDesignById(parentDesignID);
                if (parent == null) {
                    throw new Exception("No parent design with with learning_design_id of : parent_learning_design_id exists.");
                }
                design.setParentLearningDesign(parent);
            }
            if (table.containsKey("duration")) {
                design.setDuration(WDDXProcessor.convertToLong("duration", table.get("duration")));
            }
            if (table.containsKey("license_id")) {
                Long licenseID = WDDXProcessor.convertToLong("license_id", table.get("license_id"));
                License license = this.licenseDAO.getLicenseByID(licenseID);
                if (license != null) {
                    design.setLicense(license);
                } else {
                    throw new Exception("No License with a license_id of : " + licenseID + " exists");
                }
            }
            if (table.containsKey("license_text")) {
                design.setLicenseText((String)table.get("license_text"));
            }
        }
        catch (WDDXProcessorConversionException wpce) {
            String str = wpce.getMessage();
            throw new Exception(wpce.getMessage());
        }
    }

    private Activity processActivity(Hashtable table, LearningDesign design) throws Exception {
        boolean update;
        Activity activity;
        block32: {
            Long activityID = null;
            activity = null;
            update = false;
            if (table.containsKey("activity_id")) {
                activityID = WDDXProcessor.convertToLong("activity_id", table.get("activity_id"));
                activity = this.activityDAO.getActivityByActivityId(activityID);
                update = true;
            } else {
                Integer activityTypeID = WDDXProcessor.convertToInteger("activity_type_id", table.get("learning_activity_type_id"));
                activity = this.createActivityInstance(activityTypeID, table);
            }
            try {
                if (table.containsKey("activity_ui_id")) {
                    activity.setActivityUIID(WDDXProcessor.convertToInteger("activity_ui_id", table.get("activity_ui_id")));
                }
                if (table.containsKey("description")) {
                    activity.setDescription((String)table.get("description"));
                }
                if (table.containsKey("title")) {
                    activity.setTitle((String)table.get("title"));
                }
                if (table.containsKey("help_text")) {
                    activity.setHelpText((String)table.get("help_text"));
                }
                if (table.containsKey("xcoord")) {
                    activity.setXcoord(WDDXProcessor.convertToInteger("xcoord", table.get("xcoord")));
                }
                if (table.containsKey("ycoord")) {
                    activity.setYcoord(WDDXProcessor.convertToInteger("ycoord", table.get("ycoord")));
                }
                if (table.containsKey("parent_activity_ui_id")) {
                    Integer parentUIID = WDDXProcessor.convertToInteger("parent_ui_id", table.get("parent_activity_ui_id"));
                    Activity objActivity = this.activityDAO.getActivityByUIID(parentUIID, design);
                    if (objActivity != null) {
                        activity.setParentActivity(objActivity);
                        activity.setParentUIID(parentUIID);
                    } else {
                        throw new Exception("Error setting parent_ui_id. No such activity with activity_ui_id : " + parentUIID + "exists.");
                    }
                }
                if (table.containsKey("parent_activity_id")) {
                    Long parentActivityID = WDDXProcessor.convertToLong("parent_activity_id", table.get("parent_activity_id"));
                    Activity parent = this.activityDAO.getActivityByActivityId(parentActivityID);
                    if (parent != null) {
                        activity.setParentActivity(parent);
                        activity.setParentUIID(parent.getActivityUIID());
                    } else {
                        throw new Exception("Error setting the parent_activity_id. No such activity with activity_id of: " + parentActivityID + " exists");
                    }
                }
                if (table.containsKey("learning_activity_type_id")) {
                    activity.setActivityTypeId(WDDXProcessor.convertToInteger("learning_activity_type_id", table.get("learning_activity_type_id")));
                }
                if (table.containsKey("grouping_ui_id")) {
                    Integer groupingUIID = WDDXProcessor.convertToInteger("grouping_ui_id", table.get("grouping_ui_id"));
                    activity.setGroupingUIID(groupingUIID);
                    Grouping grouping = this.groupingDAO.getGroupingByUIID(groupingUIID);
                    activity.setGrouping(grouping);
                }
                if (!table.containsKey("define_later_flag")) {
                    throw new Exception("Mandatory Field define_later is missing for Activity in the WDDX packet");
                }
                activity.setDefineLater((Boolean)table.get("define_later_flag"));
                if (!table.containsKey("run_offline")) {
                    throw new Exception("Mandatory Field run_offline is missing for Activity in the WDDX packet");
                }
                activity.setRunOffline(WDDXProcessor.convertToBoolean("run_offline", table.get("run_offline")));
                if (table.containsKey("learning_design_id")) {
                    Long learningDesignID = WDDXProcessor.convertToLong("learning_design_id", table.get("learning_design_id"));
                    LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
                    if (learningDesign != null) {
                        activity.setLearningDesign(learningDesign);
                    } else {
                        throw new Exception("Error setting learning_design_Id.No such design with learning_design_id : " + learningDesignID + " exists");
                    }
                }
                if (table.containsKey("learning_library_id")) {
                    Long learningLibraryID = WDDXProcessor.convertToLong("learning_library_id", table.get("learning_library_id"));
                    LearningLibrary learningLibrary = this.learningLibraryDAO.getLearningLibraryById(learningLibraryID);
                    if (learningLibrary != null) {
                        activity.setLearningLibrary(learningLibrary);
                    } else {
                        throw new Exception("Error setting learning_library_Id.No such design with learning_library_id : " + learningLibraryID + " exists");
                    }
                }
                if (!table.containsKey("create_date_time")) {
                    throw new Exception("Mandatory Field create_date_time is missing for Activity in the WDDX packet");
                }
                activity.setCreateDateTime((Date)table.get("create_date_time"));
                if (table.containsKey("offline_instructions")) {
                    activity.setOfflineInstructions((String)table.get("offline_instructions"));
                }
                if (table.containsKey("library_activity_ui_image")) {
                    activity.setLibraryActivityUiImage((String)table.get("library_activity_ui_image"));
                }
                if (!table.containsKey("library_activity_id")) break block32;
                Long libraryActivityID = WDDXProcessor.convertToLong("library_activity_id", table.get("library_activity_id"));
                Activity libActivity = this.activityDAO.getActivityByActivityId(libraryActivityID);
                if (libActivity != null) {
                    activity.setLibraryActivity(libActivity);
                    break block32;
                }
                throw new Exception("Error setting library_activity_idNo Such activity with activity_id of: " + libraryActivityID + " exists");
            }
            catch (WDDXProcessorConversionException wpce) {
                throw new Exception(wpce.getMessage());
            }
        }
        if (update) {
            this.activityDAO.update(activity);
        } else {
            this.activityDAO.insert(activity);
        }
        return activity;
    }

    private Activity createActivityInstance(Integer activityTypeID, Hashtable table) throws Exception {
        Activity activity = null;
        int type = activityTypeID;
        switch (type) {
            case 1: {
                activity = this.storeToolActivity(table);
                break;
            }
            case 7: {
                activity = this.storeOptionsActivity(table);
                break;
            }
            case 2: {
                activity = this.storeGroupingActivity(table);
                break;
            }
            case 5: {
                activity = this.storePermissionGateActivity(table);
                break;
            }
            case 4: {
                activity = this.storeScheduleGateActivity(table);
                break;
            }
            case 3: {
                activity = this.storeSynchGateActivity(table);
                break;
            }
            case 6: {
                activity = this.storeParallelActivity(table);
                break;
            }
            case 8: {
                activity = this.storeSequenceActivity(table);
            }
        }
        return activity;
    }

    private GroupingActivity storeGroupingActivity(Hashtable table) throws Exception {
        GroupingActivity groupingActivity = new GroupingActivity();
        Hashtable groupingTable = (Hashtable)table.get("grouping");
        Integer groupingType = null;
        Grouping grouping = null;
        if (!groupingTable.containsKey("grouping_type_id")) {
            throw new Exception("grouping_type_id missing for GroupingActivity.Cannot create Grouping without that");
        }
        groupingType = WDDXProcessor.convertToInteger("grouping_type_id", groupingTable.get("grouping_type_id"));
        grouping = groupingType == Grouping.RANDOM_GROUPING_TYPE ? this.createRandomGrouping(groupingTable) : this.createChosenGrouping(groupingTable);
        groupingActivity.setCreateGrouping(grouping);
        groupingActivity.setCreateGroupingUIID(grouping.getGroupingUIID());
        return groupingActivity;
    }

    private RandomGrouping createRandomGrouping(Hashtable table) throws Exception {
        RandomGrouping randomGrouping = new RandomGrouping();
        if (table.containsKey("max_number_of_groups")) {
            randomGrouping.setMaxNumberOfGroups(WDDXProcessor.convertToInteger("max_number_of_groups", table.get("max_number_of_groups")));
        }
        if (table.containsKey("grouping_ui_id")) {
            randomGrouping.setGroupingUIID(WDDXProcessor.convertToInteger("grouping_ui_id", table.get("grouping_ui_id")));
        }
        if (table.containsKey("number_of_groups")) {
            randomGrouping.setNumberOfGroups(WDDXProcessor.convertToInteger("number_of_groups", table.get("number_of_groups")));
        }
        if (table.containsKey("learners_per_group")) {
            randomGrouping.setLearnersPerGroup(WDDXProcessor.convertToInteger("learners_per_group", table.get("learners_per_group")));
        }
        this.groupingDAO.insert(randomGrouping);
        return randomGrouping;
    }

    private ChosenGrouping createChosenGrouping(Hashtable table) throws Exception {
        ChosenGrouping chosenGrouping = new ChosenGrouping();
        if (table.containsKey("max_number_of_groups")) {
            chosenGrouping.setMaxNumberOfGroups(WDDXProcessor.convertToInteger("max_number_of_groups", table.get("max_number_of_groups")));
        }
        if (table.containsKey("grouping_ui_id")) {
            chosenGrouping.setGroupingUIID(WDDXProcessor.convertToInteger("grouping_ui_id", table.get("grouping_ui_id")));
        }
        this.groupingDAO.insert(chosenGrouping);
        return chosenGrouping;
    }

    private OptionsActivity storeOptionsActivity(Hashtable table) throws Exception {
        OptionsActivity optActivity = new OptionsActivity();
        if (table.containsKey("max_number_of_options")) {
            optActivity.setMaxNumberOfOptions(WDDXProcessor.convertToInteger("max_number_of_options", table.get("max_number_of_options")));
        }
        if (table.containsKey("min_number_of_options")) {
            optActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger("min_number_of_options", table.get("min_number_of_options")));
        }
        if (table.containsKey("options_instructions")) {
            optActivity.setOptionsInstructions((String)table.get("options_instructions"));
        }
        this.addChildActivities(optActivity, table);
        return optActivity;
    }

    private ToolActivity storeToolActivity(Hashtable table) throws Exception {
        ToolActivity toolActivity = new ToolActivity();
        if (table.containsKey("tool_id")) {
            Long toolID = WDDXProcessor.convertToLong("tool_id", table.get("tool_id"));
            Tool tool = this.toolDAO.getToolByID(toolID);
            if (tool != null) {
                toolActivity.setTool(tool);
            } else {
                throw new Exception("Error setting tool_id. No such tool with tool_id of: " + toolID + "exists");
            }
        }
        if (table.containsKey("order_id")) {
            toolActivity.setOrderId(WDDXProcessor.convertToInteger("order_id", table.get("order_id")));
        }
        if (table.containsKey("tool_content_id")) {
            toolActivity.setToolContentId(WDDXProcessor.convertToLong("tool_content_id", table.get("tool_content_id")));
        }
        return toolActivity;
    }

    private void addGateActivityAttributes(GateActivity gateActivity, Hashtable table) throws Exception {
        if (table.containsKey("gate_activity_level_id")) {
            gateActivity.setGateActivityLevelId(WDDXProcessor.convertToInteger("gate_activity_level_id", table.get("gate_activity_level_id")));
        }
        if (table.containsKey("gate_open")) {
            gateActivity.setGateOpen(WDDXProcessor.convertToBoolean("gate_open", table.get("gate_open")));
        }
    }

    private PermissionGateActivity storePermissionGateActivity(Hashtable table) throws Exception {
        PermissionGateActivity permissionGateActivity = new PermissionGateActivity();
        this.addGateActivityAttributes(permissionGateActivity, table);
        return permissionGateActivity;
    }

    private ScheduleGateActivity storeScheduleGateActivity(Hashtable table) throws Exception {
        ScheduleGateActivity scheduleGateActivity = new ScheduleGateActivity();
        this.addGateActivityAttributes(scheduleGateActivity, table);
        if (table.containsKey("gate_start_date_time")) {
            scheduleGateActivity.setGateStartDateTime((Date)table.get("gate_start_date_time"));
        }
        if (table.containsKey("gate_end_date_time")) {
            scheduleGateActivity.setGateEndDateTime((Date)table.get("gate_end_date_time"));
        }
        if (table.containsKey("gate_start_time_offset")) {
            scheduleGateActivity.setGateStartTimeOffset(WDDXProcessor.convertToLong("gate_start_time_offset", table.get("gate_start_time_offset")));
        }
        if (table.containsKey("gate_end_time_offset")) {
            scheduleGateActivity.setGateEndTimeOffset(WDDXProcessor.convertToLong("gate_end_time_offset", table.get("gate_end_time_offset")));
        }
        return scheduleGateActivity;
    }

    private SynchGateActivity storeSynchGateActivity(Hashtable table) throws Exception {
        SynchGateActivity synchGateActivity = new SynchGateActivity();
        this.addGateActivityAttributes(synchGateActivity, table);
        return synchGateActivity;
    }

    private ParallelActivity storeParallelActivity(Hashtable table) throws Exception {
        ParallelActivity parallelActivity = new ParallelActivity();
        this.addChildActivities(parallelActivity, table);
        return parallelActivity;
    }

    private SequenceActivity storeSequenceActivity(Hashtable table) throws Exception {
        SequenceActivity sequenceActivity = new SequenceActivity();
        this.addChildActivities(sequenceActivity, table);
        return sequenceActivity;
    }

    private void addChildActivities(ComplexActivity complexActivity, Hashtable table) throws Exception {
        HashSet<Activity> childActivities;
        if (table.containsKey("childActivities")) {
            Vector vector = (Vector)table.get("childActivities");
            childActivities = new HashSet<Activity>();
            Iterator iter = vector.iterator();
            while (iter.hasNext()) {
                Activity activity = (Activity)iter.next();
                childActivities.add(activity);
            }
        } else {
            throw new Exception("An attempt to save a complex activity with no child activities");
        }
        complexActivity.setActivities(childActivities);
    }
}

