/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.dto;

import java.util.Date;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

public class FolderContentDTO {
    public static final String LESSON = "lesson";
    public static final String DESIGN = "learningDesign";
    public static final String FOLDER = "folder";
    private String name;
    private String description;
    private Date creationDateTime;
    private Date lastModifiedDateTime;
    private String resourceType;
    private Long resourceID;
    private Integer permissionCode;

    public FolderContentDTO() {
    }

    public FolderContentDTO(String name, String description, Date creationDateTime, Date lastModifiedDateTime, String resourceType, Long resourceID, Integer permissionCode) {
        this.name = name;
        this.description = description;
        this.creationDateTime = creationDateTime;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.resourceType = resourceType;
        this.resourceID = resourceID;
        this.permissionCode = permissionCode;
    }

    public FolderContentDTO(LearningDesign design, Integer permissionCode) {
        this.name = design.getTitle();
        this.description = design.getDescription();
        this.creationDateTime = design.getCreateDateTime();
        this.lastModifiedDateTime = design.getLastModifiedDateTime();
        this.resourceType = DESIGN;
        this.resourceID = design.getLearningDesignId();
        this.permissionCode = permissionCode;
    }

    public FolderContentDTO(WorkspaceFolder workspaceFolder, Integer permissionCode) {
        this.name = workspaceFolder.getName();
        this.description = "Folder";
        this.creationDateTime = workspaceFolder.getCreationDate();
        this.lastModifiedDateTime = workspaceFolder.getLastModifiedDate();
        this.resourceType = FOLDER;
        this.resourceID = new Long(workspaceFolder.getWorkspaceFolderId().intValue());
        this.permissionCode = permissionCode;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime != null ? this.creationDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime != null ? this.lastModifiedDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getName() {
        return this.name != null ? this.name : "string_null_value";
    }

    public Integer getPermissionCode() {
        return this.permissionCode != null ? this.permissionCode : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getResourceID() {
        return this.resourceID != null ? this.resourceID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getResourceType() {
        return this.resourceType != null ? this.resourceType : "string_null_value";
    }
}

