/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.google.common.base.Preconditions;
import com.thoughtworks.selenium.SeleniumException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class AlertOverride {
    private final boolean enableOverrides;

    public AlertOverride(boolean enableOverrides) {
        this.enableOverrides = enableOverrides;
    }

    public void replaceAlertMethod(WebDriver driver) {
        if (!this.enableOverrides) {
            return;
        }
        ((JavascriptExecutor)((Object)driver)).executeScript("var canUseLocalStorage = false; try { canUseLocalStorage = !!window.localStorage; } catch(ex) { /* probe failed */ } if (canUseLocalStorage) {   window.localStorage.setItem('__webdriverAlerts', JSON.stringify([]));   window.alert = function(msg) {     var alerts = JSON.parse(window.localStorage.getItem('__webdriverAlerts'));     alerts.push(msg);     window.localStorage.setItem('__webdriverAlerts', JSON.stringify(alerts));   };   window.localStorage.setItem('__webdriverConfirms', JSON.stringify([]));   if (!('__webdriverNextConfirm' in window.localStorage)) {     window.localStorage.setItem('__webdriverNextConfirm', JSON.stringify(true));   }   window.confirm = function(msg) {     var confirms = JSON.parse(window.localStorage.getItem('__webdriverConfirms'));     confirms.push(msg);     window.localStorage.setItem('__webdriverConfirms', JSON.stringify(confirms));     var res = JSON.parse(window.localStorage.getItem('__webdriverNextConfirm'));     window.localStorage.setItem('__webdriverNextConfirm', JSON.stringify(true));     return res;   }; } else {   if (window.__webdriverAlerts) { return; }   window.__webdriverAlerts = [];   window.alert = function(msg) { window.__webdriverAlerts.push(msg); };   window.__webdriverConfirms = [];   window.__webdriverNextConfirm = true;   window.confirm = function(msg) {     window.__webdriverConfirms.push(msg);     var res = window.__webdriverNextConfirm;     window.__webdriverNextConfirm = true;     return res;   }; }", new Object[0]);
    }

    private void checkOverridesEnabled() {
        Preconditions.checkState((boolean)this.enableOverrides, (Object)"Selenium alert overrides have been disabled; please use the underlying WebDriver API");
    }

    public String getNextAlert(WebDriver driver) {
        this.checkOverridesEnabled();
        String result = (String)((JavascriptExecutor)((Object)driver)).executeScript("var canUseLocalStorage = false; try { canUseLocalStorage = !!window.localStorage; } catch(ex) { /* probe failed */ } if (canUseLocalStorage) {   if (!('__webdriverAlerts' in window.localStorage)) { return null }   var alerts = JSON.parse(window.localStorage.getItem('__webdriverAlerts'));   if (! alerts) { return null }   var t = alerts.shift();   window.localStorage.setItem('__webdriverAlerts', JSON.stringify(alerts));   if (t) { t = t.replace(/\\n/g, ' '); }   return t; } else {   if (!window.__webdriverAlerts) { return null }   var t = window.__webdriverAlerts.shift();   if (t) { t = t.replace(/\\n/g, ' '); }   return t; }", new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no alerts");
        }
        return result;
    }

    public boolean isAlertPresent(WebDriver driver) {
        this.checkOverridesEnabled();
        return Boolean.TRUE.equals(((JavascriptExecutor)((Object)driver)).executeScript("var canUseLocalStorage = false; try { canUseLocalStorage = !!window.localStorage; } catch(ex) { /* probe failed */ } if (canUseLocalStorage) {   if (!('__webdriverAlerts' in window.localStorage)) { return false }   var alerts = JSON.parse(window.localStorage.getItem('__webdriverAlerts'));   return alerts && alerts.length > 0; } else {   return window.__webdriverAlerts && window.__webdriverAlerts.length > 0; }", new Object[0]));
    }

    public String getNextConfirmation(WebDriver driver) {
        this.checkOverridesEnabled();
        String result = (String)((JavascriptExecutor)((Object)driver)).executeScript("var canUseLocalStorage = false; try { canUseLocalStorage = !!window.localStorage; } catch(ex) { /* probe failed */ } if (canUseLocalStorage) {   if (!('__webdriverConfirms' in window.localStorage)) { return null }   var confirms = JSON.parse(window.localStorage.getItem('__webdriverConfirms'));   if (! confirms) { return null }   var t = confirms.shift();   window.localStorage.setItem('__webdriverConfirms', JSON.stringify(confirms));   if (t) { t = t.replace(/\\n/g, ' '); }   return t; } else {   if (!window.__webdriverConfirms) { return null; }   return window.__webdriverConfirms.shift(); }", new Object[0]);
        if (result == null) {
            throw new SeleniumException("There were no confirmations");
        }
        return result;
    }

    public boolean isConfirmationPresent(WebDriver driver) {
        this.checkOverridesEnabled();
        return Boolean.TRUE.equals(((JavascriptExecutor)((Object)driver)).executeScript("var canUseLocalStorage = false; try { canUseLocalStorage = !!window.localStorage; } catch(ex) { /* probe failed */ } if (canUseLocalStorage) {   if (!('__webdriverConfirms' in window.localStorage)) { return false }   var confirms = JSON.parse(window.localStorage.getItem('__webdriverConfirms'));   return confirms && confirms.length > 0; } else {   return window.__webdriverConfirms && window.__webdriverConfirms.length > 0; }", new Object[0]));
    }
}

