/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.MarionetteConnection;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionNotFoundException;

public class FirefoxDriver
extends RemoteWebDriver
implements Killable {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final boolean DEFAULT_ENABLE_NATIVE_EVENTS = Platform.getCurrent().is(Platform.WINDOWS);
    public static final boolean USE_MARIONETTE = Boolean.parseBoolean(System.getProperty("webdriver.firefox.marionette"));
    @Deprecated
    public static final boolean ACCEPT_UNTRUSTED_CERTIFICATES = true;
    @Deprecated
    public static final boolean ASSUME_UNTRUSTED_ISSUER = true;
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxBinary(), null);
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxBinary(), profile);
    }

    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(FirefoxDriver.getBinary(desiredCapabilities), FirefoxDriver.extractProfile(desiredCapabilities, null), desiredCapabilities);
    }

    public FirefoxDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(FirefoxDriver.getBinary(desiredCapabilities), FirefoxDriver.extractProfile(desiredCapabilities, requiredCapabilities), desiredCapabilities, requiredCapabilities);
    }

    private static FirefoxProfile extractProfile(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        FirefoxProfile profile = null;
        Object raw = null;
        if (desiredCapabilities != null && desiredCapabilities.getCapability(PROFILE) != null) {
            raw = desiredCapabilities.getCapability(PROFILE);
        }
        if (requiredCapabilities != null && requiredCapabilities.getCapability(PROFILE) != null) {
            raw = requiredCapabilities.getCapability(PROFILE);
        }
        if (raw != null) {
            if (raw instanceof FirefoxProfile) {
                profile = (FirefoxProfile)raw;
            } else if (raw instanceof String) {
                try {
                    profile = FirefoxProfile.fromJson((String)raw);
                }
                catch (IOException e) {
                    throw new WebDriverException(e);
                }
            }
        }
        profile = FirefoxDriver.getProfile(profile);
        FirefoxDriver.populateProfile(profile, desiredCapabilities);
        FirefoxDriver.populateProfile(profile, requiredCapabilities);
        return profile;
    }

    static void populateProfile(FirefoxProfile profile, Capabilities capabilities) {
        if (capabilities == null) {
            return;
        }
        if (capabilities.getCapability("webStorageEnabled") != null) {
            Boolean supportsWebStorage = (Boolean)capabilities.getCapability("webStorageEnabled");
            profile.setPreference("dom.storage.enabled", supportsWebStorage);
        }
        if (capabilities.getCapability("acceptSslCerts") != null) {
            Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
            profile.setAcceptUntrustedCertificates(acceptCerts);
        }
        if (capabilities.getCapability("loggingPrefs") != null) {
            LoggingPreferences logsPrefs = (LoggingPreferences)capabilities.getCapability("loggingPrefs");
            for (String logtype : logsPrefs.getEnabledLogTypes()) {
                profile.setPreference("webdriver.log." + logtype, logsPrefs.getLevel(logtype).intValue());
            }
        }
        if (capabilities.getCapability("nativeEvents") != null) {
            Boolean nativeEventsEnabled = (Boolean)capabilities.getCapability("nativeEvents");
            profile.setEnableNativeEvents(nativeEventsEnabled);
        }
    }

    private static FirefoxBinary getBinary(Capabilities capabilities) {
        if (capabilities != null && capabilities.getCapability(BINARY) != null) {
            Object raw = capabilities.getCapability(BINARY);
            if (raw instanceof FirefoxBinary) {
                return (FirefoxBinary)raw;
            }
            File file = new File((String)raw);
            return new FirefoxBinary(file);
        }
        return new FirefoxBinary();
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(binary, profile, (Capabilities)DesiredCapabilities.firefox());
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities capabilities) {
        this(binary, profile, capabilities, null);
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(new LazyCommandExecutor(binary, profile), FirefoxDriver.dropCapabilities(desiredCapabilities, BINARY, PROFILE), FirefoxDriver.dropCapabilities(requiredCapabilities, BINARY, PROFILE));
        this.binary = binary;
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    public void kill() {
        this.binary.quit();
    }

    @Override
    public WebDriver.Options manage() {
        return new RemoteWebDriver.RemoteWebDriverOptions(this){

            @Override
            public WebDriver.Timeouts timeouts() {
                return new RemoteWebDriver.RemoteWebDriverOptions.RemoteTimeouts(this){

                    @Override
                    public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"implicit", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }

                    @Override
                    public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"script", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }
                };
            }
        };
    }

    @Override
    protected void startClient() {
        LazyCommandExecutor exe = (LazyCommandExecutor)this.getCommandExecutor();
        FirefoxProfile profileToUse = FirefoxDriver.getProfile(exe.profile);
        ExtensionConnection connection = this.connectTo(exe.binary, profileToUse, "localhost");
        exe.setConnection(connection);
        try {
            connection.start();
        }
        catch (IOException e) {
            throw new WebDriverException("An error occurred while connecting to Firefox", e);
        }
    }

    private static FirefoxProfile getProfile(FirefoxProfile profile) {
        FirefoxProfile profileToUse = profile;
        String suggestedProfile = System.getProperty("webdriver.firefox.profile");
        if (profileToUse == null && suggestedProfile != null) {
            profileToUse = new ProfilesIni().getProfile(suggestedProfile);
            if (profileToUse == null) {
                throw new WebDriverException("Firefox profile '" + suggestedProfile + "' named in system property 'webdriver.firefox.profile' not found");
            }
        } else if (profileToUse == null) {
            profileToUse = new FirefoxProfile();
        }
        return profileToUse;
    }

    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        Lock lock = FirefoxDriver.obtainLock(profile);
        try {
            FirefoxBinary bin;
            FirefoxBinary firefoxBinary = bin = binary == null ? new FirefoxBinary() : binary;
            if (USE_MARIONETTE) {
                MarionetteConnection marionetteConnection = new MarionetteConnection(lock, bin, profile, host);
                return marionetteConnection;
            }
            NewProfileExtensionConnection newProfileExtensionConnection = new NewProfileExtensionConnection(lock, bin, profile, host);
            return newProfileExtensionConnection;
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected static Lock obtainLock(FirefoxProfile profile) {
        return new SocketLock();
    }

    @Override
    protected void stopClient() {
        ((LazyCommandExecutor)this.getCommandExecutor()).quit();
    }

    private static Capabilities dropCapabilities(Capabilities capabilities, String ... keysToRemove) {
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        final HashSet toRemove = Sets.newHashSet((Object[])keysToRemove);
        DesiredCapabilities caps = new DesiredCapabilities(Maps.filterKeys(capabilities.asMap(), (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !toRemove.contains(key);
            }
        }));
        Proxy proxy = Proxy.extractFrom(capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", new BeanToJsonConverter().convert(proxy));
        }
        return caps;
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return target.convertFromBase64Png(base64);
    }

    private static class LazyCommandExecutor
    implements CommandExecutor,
    NeedsLocalLogs {
        private ExtensionConnection connection;
        private final FirefoxBinary binary;
        private final FirefoxProfile profile;
        private LocalLogs logs = LocalLogs.getNullLogger();

        private LazyCommandExecutor(FirefoxBinary binary, FirefoxProfile profile) {
            this.binary = binary;
            this.profile = profile;
        }

        public void setConnection(ExtensionConnection connection) {
            this.connection = connection;
            connection.setLocalLogs(this.logs);
        }

        public void quit() {
            if (this.connection != null) {
                this.connection.quit();
                this.connection = null;
            }
            if (this.profile != null) {
                this.profile.cleanTemporaryModel();
            }
        }

        @Override
        public Response execute(Command command) throws IOException {
            if (this.connection == null) {
                if (command.getName().equals("quit")) {
                    return new Response();
                }
                throw new SessionNotFoundException("The FirefoxDriver cannot be used after quit() was called.");
            }
            return this.connection.execute(command);
        }

        @Override
        public void setLocalLogs(LocalLogs logs) {
            this.logs = logs;
            if (this.connection != null) {
                this.connection.setLocalLogs(logs);
            }
        }
    }
}

