/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.openqa.selenium.Platform;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

public class FileHandler {
    public static File unzip(InputStream resource) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir("unzip", "stream");
        new Zip().unzip(resource, output);
        return output;
    }

    public static void copyResource(File outputDir, Class<?> forClassLoader, String ... names) throws IOException {
        Zip zip = new Zip();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            InputStream is = FileHandler.locateResource(forClassLoader, name);
            try {
                zip.unzipFile(outputDir, is, name);
            }
            finally {
                is.close();
            }
            ++n2;
        }
    }

    private static InputStream locateResource(Class<?> forClassLoader, String name) throws IOException {
        String arch = String.valueOf(System.getProperty("os.arch").toLowerCase()) + "/";
        ArrayList alternatives = Lists.newArrayList((Object[])new String[]{name, "/" + name, String.valueOf(arch) + name, "/" + arch + name});
        if (Platform.getCurrent().is(Platform.MAC)) {
            alternatives.add("mac/" + name);
            alternatives.add("/mac/" + name);
        }
        for (String possibility : alternatives) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException("Unable to locate: " + name);
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        if (file.canWrite()) {
            return true;
        }
        return file.setWritable(true);
    }

    public static boolean makeExecutable(File file) throws IOException {
        if (FileHandler.canExecute(file).booleanValue()) {
            return true;
        }
        return file.setExecutable(true);
    }

    public static Boolean canExecute(File file) {
        return file.canExecute();
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        File[] children;
        boolean deleted = true;
        if (toDelete.isDirectory() && (children = toDelete.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                deleted &= child.canWrite() && FileHandler.delete(child);
                ++n2;
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        FileHandler.copy(from, to, new NoFilter());
    }

    public static void copy(File source, File dest, String suffix) throws IOException {
        FileHandler.copy(source, dest, suffix == null ? new NoFilter() : new FileSuffixFilter(suffix));
    }

    private static void copy(File source, File dest, Filter onlyCopy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            FileHandler.copyDir(source, dest, onlyCopy);
        } else {
            FileHandler.copyFile(source, dest, onlyCopy);
        }
    }

    private static void copyDir(File from, File to, Filter onlyCopy) throws IOException {
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileHandler.createDir(to);
        String[] children = from.list();
        if (children == null) {
            throw new IOException("Could not copy directory " + from.getPath());
        }
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            if (!".parentlock".equals(child) && !"parent.lock".equals(child)) {
                FileHandler.copy(new File(from, child), new File(to, child), onlyCopy);
            }
            ++n2;
        }
    }

    private static void copyFile(File from, File to, Filter onlyCopy) throws IOException {
        if (!onlyCopy.isRequired(from)) {
            return;
        }
        FileChannel out = null;
        FileChannel in = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long length = in.size();
            long copied = in.transferTo(0L, in.size(), out);
            if (copied != length) {
                throw new IOException("Could not transfer all bytes.");
            }
        }
        catch (Throwable throwable) {
            Closeables.close(out, (boolean)false);
            Closeables.close((Closeable)in, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)out, (boolean)false);
        Closeables.close((Closeable)in, (boolean)false);
    }

    public static String readAsString(File toRead) throws IOException {
        String string;
        BufferedReader reader = null;
        try {
            int read;
            reader = new BufferedReader(new FileReader(toRead));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                char[] target = new char[read];
                System.arraycopy(buffer, 0, target, 0, read);
                builder.append(target);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)false);
        return string;
    }

    private static class FileSuffixFilter
    implements Filter {
        private final String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean isRequired(File file) {
            return file.isDirectory() || file.getAbsolutePath().endsWith(this.suffix);
        }
    }

    public static interface Filter {
        public boolean isRequired(File var1);
    }

    private static class NoFilter
    implements Filter {
        private NoFilter() {
        }

        @Override
        public boolean isRequired(File file) {
            return true;
        }
    }
}

