/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.internal.HttpClientFactory;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private static final int MAX_REDIRECTS = 10;
    private final HttpHost targetHost;
    private final URL remoteServer;
    private final HttpClient client;
    private final JsonHttpCommandCodec commandCodec;
    private final JsonHttpResponseCodec responseCodec;
    private static HttpClientFactory httpClientFactory;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this((Map<String, CommandInfo>)ImmutableMap.of(), addressOfRemoteServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        try {
            this.remoteServer = addressOfRemoteServer == null ? new URL(System.getProperty("webdriver.remote.server", "http://localhost:4444/wd/hub")) : addressOfRemoteServer;
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
        this.commandCodec = new JsonHttpCommandCodec();
        this.responseCodec = new JsonHttpResponseCodec();
        Class<HttpCommandExecutor> e = HttpCommandExecutor.class;
        synchronized (HttpCommandExecutor.class) {
            if (httpClientFactory == null) {
                httpClientFactory = new HttpClientFactory();
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (addressOfRemoteServer != null && addressOfRemoteServer.getUserInfo() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(addressOfRemoteServer.getUserInfo());
                this.client = httpClientFactory.createHttpClient((Credentials)credentials);
            } else {
                this.client = httpClientFactory.getHttpClient();
            }
            String host = this.remoteServer.getHost().replace(".localdomain", "");
            this.targetHost = new HttpHost(host, this.remoteServer.getPort(), this.remoteServer.getProtocol());
            for (Map.Entry<String, CommandInfo> entry : additionalCommands.entrySet()) {
                this.defineCommand(entry.getKey(), entry.getValue());
            }
            return;
        }
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Preconditions.checkNotNull((Object)commandName);
        Preconditions.checkNotNull((Object)info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        BasicHttpContext context = new BasicHttpContext();
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"getAllSessions".equals(command.getName()) && !"newSession".equals(command.getName())) {
                throw new SessionNotFoundException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        HttpRequest request = this.commandCodec.encode(command);
        String requestUrl = String.valueOf(this.remoteServer.toExternalForm().replaceAll("/$", "")) + request.getUri();
        HttpUriRequest httpMethod = HttpCommandExecutor.createHttpUriRequest(request.getMethod(), requestUrl);
        for (String name : request.getHeaderNames()) {
            if ("Content-Length".equalsIgnoreCase(name)) continue;
            for (String value : request.getHeaders(name)) {
                httpMethod.addHeader(name, value);
            }
        }
        if (httpMethod instanceof HttpPost) {
            ((HttpPost)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(request.getContent()));
        }
        try {
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            org.apache.http.HttpResponse response = this.fallBackExecute((HttpContext)context, httpMethod);
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            response = this.followRedirects(this.client, (HttpContext)context, response, 0);
            return this.createResponse(response, (HttpContext)context);
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }

    private static HttpUriRequest createHttpUriRequest(HttpMethod method, String url) {
        switch (method) {
            case DELETE: {
                return new HttpDelete(url);
            }
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + (Object)((Object)method)));
    }

    private org.apache.http.HttpResponse fallBackExecute(HttpContext context, HttpUriRequest httpMethod) throws IOException {
        try {
            return this.client.execute(this.targetHost, (org.apache.http.HttpRequest)httpMethod, context);
        }
        catch (BindException bindException) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate((Throwable)ie);
            }
        }
        catch (NoHttpResponseException noHttpResponseException) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate((Throwable)ie);
            }
        }
        return this.client.execute(this.targetHost, (org.apache.http.HttpRequest)httpMethod, context);
    }

    private org.apache.http.HttpResponse followRedirects(HttpClient client, HttpContext context, org.apache.http.HttpResponse response, int redirectCount) {
        if (!this.isRedirect(response)) {
            return response;
        }
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        try {
            URI uri = this.buildUri(context, location);
            HttpGet get = new HttpGet(uri);
            get.setHeader("Accept", "application/json; charset=utf-8");
            org.apache.http.HttpResponse newResponse = client.execute(this.targetHost, (org.apache.http.HttpRequest)get, context);
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (URISyntaxException e) {
            throw new WebDriverException(e);
        }
        catch (ClientProtocolException e) {
            throw new WebDriverException(e);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(String.valueOf(host.toURI()) + location);
        }
        return uri;
    }

    private boolean isRedirect(org.apache.http.HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    private Response createResponse(org.apache.http.HttpResponse httpResponse, HttpContext context) throws IOException {
        Response response;
        HttpResponse internalResponse = new HttpResponse();
        internalResponse.setStatus(httpResponse.getStatusLine().getStatusCode());
        Header[] headerArray = httpResponse.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            HeaderElement[] headerElementArray = header.getElements();
            int n3 = headerElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                HeaderElement headerElement = headerElementArray[n4];
                internalResponse.addHeader(header.getName(), headerElement.getValue());
                ++n4;
            }
            ++n2;
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                internalResponse.setContent(EntityUtils.toByteArray((HttpEntity)entity));
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        if ((response = this.responseCodec.decode(internalResponse)).getSessionId() == null) {
            HttpHost finalHost = (HttpHost)context.getAttribute("http.target_host");
            String uri = finalHost.toURI();
            String sessionId = HttpSessionId.getSessionId(uri);
            response.setSessionId(sessionId);
        }
        return response;
    }
}

