/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.safari.SafariOptions;

class SafariExtensions {
    private static final Logger logger = Logger.getLogger(SafariExtensions.class.getName());
    public static final String EXTENSION_LOCATION_PROPERTY = "webdriver.safari.driver";
    public static final String NO_INSTALL_EXTENSION_PROPERTY = "webdriver.safari.noinstall";
    private static final String EXTENSION_RESOURCE_PATH = String.format("/%s/SafariDriver.safariextz", SafariExtensions.class.getPackage().getName().replace('.', '/'));
    private static final String EXTENSION_PLIST_LINES_HEAD = Joiner.on((String)"\n").join((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (Object)"<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">", new Object[]{"<plist version=\"1.0\">", "<dict>", "\t<key>Available Updates</key>", "\t<dict>", "\t\t<key>Last Update Check Time</key>", "\t\t<real>370125644.75941497</real>", "\t\t<key>Updates List</key>", "\t\t<array/>", "\t</dict>", "\t<key>Installed Extensions</key>", "\t<array>\n"});
    private static final String EXTENSION_PLIST_LINES_ITEM = Joiner.on((String)"\n").join((Object)"\t\t<dict>", (Object)"\t\t\t<key>Added Non-Default Toolbar Items</key>", new Object[]{"\t\t\t<array/>", "\t\t\t<key>Archive File Name</key>", "\t\t\t<string>%s.safariextz</string>", "\t\t\t<key>Bundle Directory Name</key>", "\t\t\t<string>%s.safariextension</string>", "\t\t\t<key>Enabled</key>", "\t\t\t<true/>", "\t\t\t<key>Hidden Bars</key>", "\t\t\t<array/>", "\t\t\t<key>Removed Default Toolbar Items</key>", "\t\t\t<array/>", "\t\t</dict>\n"});
    private static final String EXTENSION_PLIST_LINES_TAIL = Joiner.on((String)"\n").join((Object)"\t</array>", (Object)"\t<key>Version</key>", new Object[]{"\t<integer>1</integer>", "</dict>", "</plist>"});
    private final Runtime runtime = Runtime.getRuntime();
    private final Backup backup = new Backup();
    private final Optional<File> customDataDir;
    private final boolean installExtension;
    private final List<File> safariExtensionFiles;
    private UninstallThread uninstallThread;
    private List<File> installedExtensions;
    private File extensionPlist;

    SafariExtensions(SafariOptions options) {
        this.customDataDir = options.getDataDir();
        this.installExtension = !Boolean.getBoolean(NO_INSTALL_EXTENSION_PROPERTY) && !options.getUseCustomDriverExtension();
        this.safariExtensionFiles = options.getExtensions();
    }

    private static File getSafariDataDirectory() {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.MAC)) {
            return new File("/Users/" + System.getenv("USER"), "Library/Safari");
        }
        if (current.is(Platform.WINDOWS)) {
            return new File(System.getenv("APPDATA"), "Apple Computer/Safari");
        }
        throw new IllegalStateException("The current platform is not supported: " + (Object)((Object)current));
    }

    private static File getInstallDirectory(Optional<File> customDataDir) throws IOException {
        File dataDir = (File)customDataDir.or((Object)SafariExtensions.getSafariDataDirectory());
        Preconditions.checkState((boolean)dataDir.isDirectory(), (String)"The expected Safari data directory does not exist: %s", (Object[])new Object[]{dataDir.getAbsolutePath()});
        File extensionsDir = new File(dataDir, "Extensions");
        if (!extensionsDir.isDirectory()) {
            extensionsDir.mkdir();
        }
        return extensionsDir;
    }

    public synchronized void install() throws IOException {
        if (this.uninstallThread != null) {
            return;
        }
        int numberOfExtensions = (this.installExtension ? 1 : 0) + this.safariExtensionFiles.size();
        this.installedExtensions = Lists.newArrayListWithExpectedSize((int)numberOfExtensions);
        if (!this.installExtension) {
            logger.info("Use of custom driver extension requested; skipping installation");
            if (this.safariExtensionFiles.isEmpty()) {
                return;
            }
        }
        File installDirectory = SafariExtensions.getInstallDirectory(this.customDataDir);
        if (this.installExtension) {
            ByteSource extensionSrc = (ByteSource)SafariExtensions.getExtensionFromSystemProperties().or((Object)SafariExtensions.getExtensionResource());
            File targetFile = new File(installDirectory, "WebDriver.safariextz");
            this.installExtension(extensionSrc, targetFile);
        }
        for (File extensionFile : this.safariExtensionFiles) {
            File targetFile = new File(installDirectory, extensionFile.getName());
            if (targetFile.getCanonicalPath().equals(extensionFile.getCanonicalPath())) {
                this.backup.backup(targetFile);
                this.installedExtensions.add(targetFile);
                continue;
            }
            ByteSource extensionSrc = Files.asByteSource((File)extensionFile);
            this.installExtension(extensionSrc, targetFile);
        }
        this.replaceExtensionsPlist(installDirectory);
        this.uninstallThread = new UninstallThread();
        this.runtime.addShutdownHook(this.uninstallThread);
    }

    private synchronized void installExtension(ByteSource extensionSrc, File targetFile) throws IOException {
        if (targetFile.exists()) {
            this.backup.backup(targetFile);
        }
        extensionSrc.copyTo(Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]));
        this.installedExtensions.add(targetFile);
    }

    private synchronized void replaceExtensionsPlist(File installDirectory) throws IOException {
        this.extensionPlist = new File(installDirectory, "Extensions.plist");
        if (this.extensionPlist.exists()) {
            this.backup.backup(this.extensionPlist);
        }
        StringBuilder plistContent = new StringBuilder(EXTENSION_PLIST_LINES_HEAD);
        for (File extensionFile : this.installedExtensions) {
            String basename = Files.getNameWithoutExtension((String)extensionFile.getName());
            plistContent.append(String.format(EXTENSION_PLIST_LINES_ITEM, basename, basename));
        }
        plistContent.append(EXTENSION_PLIST_LINES_TAIL);
        Files.write((CharSequence)plistContent.toString(), (File)this.extensionPlist, (Charset)Charsets.UTF_8);
    }

    private static Optional<ByteSource> getExtensionFromSystemProperties() throws FileNotFoundException {
        String extensionPath = System.getProperty(EXTENSION_LOCATION_PROPERTY);
        if (Strings.isNullOrEmpty((String)extensionPath)) {
            return Optional.absent();
        }
        File extensionSrc = new File(extensionPath);
        Preconditions.checkState((boolean)extensionSrc.isFile(), (String)"The SafariDriver extension specified through the %s system property does not exist: %s", (Object[])new Object[]{EXTENSION_LOCATION_PROPERTY, extensionPath});
        Preconditions.checkState((boolean)extensionSrc.canRead(), (String)"The SafariDriver extension specified through the %s system property is not readable: %s", (Object[])new Object[]{EXTENSION_LOCATION_PROPERTY, extensionPath});
        logger.info("Using extension " + extensionSrc.getAbsolutePath());
        return Optional.of((Object)Files.asByteSource((File)extensionSrc));
    }

    private static ByteSource getExtensionResource() {
        URL url = SafariExtensions.class.getResource(EXTENSION_RESOURCE_PATH);
        Preconditions.checkNotNull((Object)url, (String)"Unable to locate extension resource, %s", (Object[])new Object[]{EXTENSION_RESOURCE_PATH});
        return Resources.asByteSource((URL)url);
    }

    public synchronized void uninstall() throws IOException {
        if (this.uninstallThread != null) {
            try {
                this.runtime.removeShutdownHook(this.uninstallThread);
            }
            catch (IllegalStateException illegalStateException) {}
            this.uninstallThread = null;
            for (File installedExtension : this.installedExtensions) {
                installedExtension.delete();
            }
            this.extensionPlist.delete();
            this.backup.restoreAll();
        }
    }

    private static class Backup {
        private final TemporaryFilesystem filesystem = TemporaryFilesystem.getDefaultTmpFS();
        private final Map<File, File> backups = Maps.newHashMap();
        private File backupDir;

        private Backup() {
        }

        File backup(File file) throws IOException {
            if (this.backupDir == null) {
                this.backupDir = this.filesystem.createTempDir("SafariBackups", "webdriver");
            }
            File backup = new File(this.backupDir, file.getName());
            Files.copy((File)file, (File)backup);
            this.backups.put(file, backup);
            return backup;
        }

        void restoreAll() throws IOException {
            for (Map.Entry<File, File> entry : this.backups.entrySet()) {
                File originalLocation = entry.getKey();
                File backup = entry.getValue();
                Files.copy((File)backup, (File)originalLocation);
            }
        }
    }

    private class UninstallThread
    extends Thread {
        private UninstallThread() {
        }

        @Override
        public void run() {
            try {
                SafariExtensions.this.uninstall();
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to uninstall extension", e);
            }
        }
    }
}

