/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrNode;
import org.lamsfoundation.lams.contentrepository.CrNodeVersion;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.IVersionedNodeAdmin;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NoSuchNodeTypeException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.NodeType;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.ValidationException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.dao.IFileDAO;
import org.lamsfoundation.lams.contentrepository.dao.INodeDAO;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;

public class SimpleVersionedNode
implements BeanFactoryAware,
IVersionedNodeAdmin {
    private BeanFactory beanFactory = null;
    protected Logger log = Logger.getLogger((Class)(class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode));
    private INodeDAO nodeDAO = null;
    private IFileDAO fileDAO = null;
    private CrNode node = null;
    private CrNodeVersion nodeVersion = null;
    private List childNodes = null;
    private InputStream newIStream = null;
    private String filePath = null;
    private ITicket ticket = null;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$CrNode;
    static /* synthetic */ Class class$org$lamsfoundation$lams$contentrepository$FileException;

    private void nodeObjectInitilised(String specialisedMessage) throws RepositoryRuntimeException {
        if (this.node == null) {
            throw new RepositoryRuntimeException("Node details missing (node=null). " + specialisedMessage);
        }
        if (this.nodeVersion == null) {
            throw new RepositoryRuntimeException("Node details missing (nodeVersion=null). " + specialisedMessage);
        }
        if (this.nodeDAO == null) {
            throw new RepositoryRuntimeException("Node details missing (nodeDAO=null). " + specialisedMessage);
        }
        if (this.fileDAO == null) {
            throw new RepositoryRuntimeException("Node details missing (fileDAO=null). " + specialisedMessage);
        }
    }

    protected void initialiseNode(String relPath, String nodeTypeName, CrWorkspace workspace, SimpleVersionedNode parentNode) throws NoSuchNodeTypeException {
        if (!NodeType.isValidNodeType(nodeTypeName)) {
            throw new NoSuchNodeTypeException("Node type " + nodeTypeName + " is not a valid node type. ");
        }
        CrNodeVersion parentNodeVersion = parentNode != null ? parentNode.nodeVersion : null;
        this.createCrNode(relPath, nodeTypeName, workspace, parentNodeVersion);
        if (parentNode != null) {
            parentNode.addChildNode(this.node);
        }
    }

    private void addChildNode(CrNode newChild) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList();
        }
        this.childNodes.add(newChild);
    }

    protected void loadData(Long workspaceId, Long uuid, Long versionId) throws ItemNotFoundException {
        if (uuid == null) {
            throw new ItemNotFoundException("UUID is null, unable to find node.");
        }
        if (workspaceId == null) {
            throw new ItemNotFoundException("Workspace Id is null, unable to find node.");
        }
        this.node = null;
        this.nodeVersion = null;
        try {
            this.node = (CrNode)this.nodeDAO.find(class$org$lamsfoundation$lams$contentrepository$CrNode == null ? (class$org$lamsfoundation$lams$contentrepository$CrNode = SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.CrNode")) : class$org$lamsfoundation$lams$contentrepository$CrNode, uuid);
        }
        catch (HibernateObjectRetrievalFailureException e) {
            // empty catch block
        }
        if (this.node == null) {
            throw new ItemNotFoundException("Node " + uuid + " not found.");
        }
        if (!workspaceId.equals(this.node.getCrWorkspace().getWorkspaceId())) {
            this.log.error((Object)("Security warning. User of workspace " + workspaceId + " is trying to access node " + uuid + " which is in workspace " + this.node.getCrWorkspace().getWorkspaceId() + " Request for node will be rejected."));
            throw new ItemNotFoundException("Node " + uuid + " does not exist in workspace " + workspaceId);
        }
        this.nodeVersion = this.node.getNodeVersion(versionId);
        if (this.nodeVersion == null) {
            throw new ItemNotFoundException("No version " + (versionId != null ? "#" + versionId.toString() : "") + "found for node");
        }
    }

    protected void initialiseNewVersionOfNode(SimpleVersionedNode existingNode) {
        this.node = existingNode.node;
        Long nextVersionId = this.node.incrementNextVersionId();
        this.node.setParentNodeVersion(existingNode.node.getParentNodeVersion());
        this.nodeVersion = this.createCrNodeVersion(this.node.getType(), new Date(System.currentTimeMillis()), nextVersionId);
        this.node.getCrNodeVersions().add(this.nodeVersion);
    }

    public NodeKey getNodeKey() {
        return new NodeKey(this.getUUID(), this.getVersion());
    }

    public void setProperty(String name, String value, int type) {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, value, type);
    }

    public void setProperty(String name, String value) throws RepositoryRuntimeException {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, value, 1);
    }

    public void setProperty(String name, boolean value) {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, Boolean.toString(value), 5);
    }

    public void setProperty(String name, double value) {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, Double.toString(value), 3);
    }

    public void setProperty(String name, long value) {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, Long.toString(value), 2);
    }

    public void setProperty(String name, Calendar value) {
        this.nodeObjectInitilised("Unable to set property " + name + " to value " + value);
        this.nodeVersion.setProperty(name, value.toString(), 4);
    }

    public IValue getProperty(String name) {
        this.nodeObjectInitilised("Unable to get property " + name);
        return this.nodeVersion.getProperty(name);
    }

    public Set getProperties() {
        this.nodeObjectInitilised("Unable to get properties.");
        return this.nodeVersion.getCrNodeVersionProperties();
    }

    public Long getUUID() {
        this.nodeObjectInitilised("Unable to get uuid.");
        return this.node.getNodeId();
    }

    public boolean hasProperty(String name) {
        this.nodeObjectInitilised("Unable to check properties.");
        return this.nodeVersion.hasProperty(name);
    }

    public boolean hasProperties() {
        this.nodeObjectInitilised("Unable to check properties.");
        return this.nodeVersion.hasProperties();
    }

    public String getNodeType() {
        this.nodeObjectInitilised("Unable to get node type.");
        return this.node.getType();
    }

    public boolean isNodeType(String nodeTypeName) {
        this.nodeObjectInitilised("Unable to get check node type.");
        return this.node.isNodeType(nodeTypeName);
    }

    public SortedSet getVersionHistory() {
        this.nodeObjectInitilised("Unable to get version history.");
        return this.node.getVersionHistory();
    }

    public String getPath() {
        this.nodeObjectInitilised("Unable to get path.");
        return this.node.getPath();
    }

    public ITicket getTicket() {
        return this.ticket;
    }

    protected void setTicket(ITicket ticket) {
        this.ticket = ticket;
    }

    public Long getVersion() {
        this.nodeObjectInitilised("Unable to get version.");
        return this.nodeVersion.getVersionId();
    }

    public Date getCreatedDateTime() {
        this.nodeObjectInitilised("Unable to get version.");
        return this.nodeVersion.getCreatedDateTime();
    }

    public InputStream getFile() throws FileException {
        this.nodeObjectInitilised("Unable to get file");
        if (this.isNodeType("FILENODE")) {
            return this.fileDAO.getFile(this.node.getNodeId(), this.nodeVersion.getVersionId());
        }
        if (this.isNodeType("PACKAGENODE")) {
            try {
                IValue value = this.getProperty("INITIALPATH");
                String lookupPath = value != null ? value.getString() : null;
                IVersionedNode startNode = this.getNode(lookupPath);
                return startNode.getFile();
            }
            catch (ValueFormatException vfe) {
                throw new RepositoryRuntimeException("Internal error: unable to get file." + vfe.getMessage(), vfe);
            }
            catch (ItemNotFoundException e) {
                throw new FileException("Unable to find initial page for package. Initial path indicated INITIALPATH");
            }
        }
        throw new FileException("Node is not a file or a package. No stream to return.");
    }

    public void setFile(InputStream iStream, String filename, String mimeType) throws InvalidParameterException {
        String trimmedFilename;
        this.nodeObjectInitilised("Unable to set the file stream.");
        if (!"FILENODE".equals(this.node.getType())) {
            throw new InvalidParameterException("Node must be of type FILE_NODE for a file to be added to the node. Unable to set the file stream.");
        }
        if (iStream == null) {
            throw new InvalidParameterException("InputStream is required.");
        }
        String string = trimmedFilename = filename != null ? filename.trim() : null;
        if (trimmedFilename == null || trimmedFilename.length() == 0) {
            throw new InvalidParameterException("Filename is required.");
        }
        this.filePath = null;
        this.newIStream = iStream;
        this.setProperty("FILENAME", trimmedFilename);
        if (mimeType != null && mimeType.length() > 0) {
            this.setProperty("MIMETYPE", mimeType);
        } else {
            this.setProperty("MIMETYPE", (String)null);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("node", (Object)this.node).append("nodeVersion", (Object)this.nodeVersion).append("newIStream", (Object)this.newIStream).append("ticket", (Object)this.ticket).toString();
    }

    private void createCrNode(String relPath, String nodeTypeName, CrWorkspace workspace, CrNodeVersion parentNode) {
        Date createdDate = new Date(System.currentTimeMillis());
        this.node = new CrNode(relPath, nodeTypeName, createdDate, new Long(1L), workspace, parentNode, null);
        this.nodeVersion = this.createCrNodeVersion(nodeTypeName, createdDate, this.node.incrementNextVersionId());
        HashSet<CrNodeVersion> versions = new HashSet<CrNodeVersion>();
        versions.add(this.nodeVersion);
        this.node.setCrNodeVersions(versions);
    }

    protected CrNodeVersion createCrNodeVersion(String nodeTypeName, Date createdDate, Long versionId) {
        this.nodeVersion = new CrNodeVersion();
        this.nodeVersion.setCreatedDateTime(createdDate);
        this.nodeVersion.setNode(this.node);
        this.nodeVersion.setVersionId(versionId);
        return this.nodeVersion;
    }

    protected void validateNode() throws ValidationException {
        String errors = "";
        if (this.node == null) {
            errors = errors + "\nInternal node object (node) is missing - node just doesn't exist properly! ";
        }
        if (this.nodeVersion == null) {
            errors = errors + "\nInternal node object (nodeVersion) is missing - node just doesn't exist properly! ";
        }
        if (errors.length() == 0) {
            if (!NodeType.isValidNodeType(this.node.getType())) {
                errors = errors + "\nNode type " + this.node.getType() + " is not a valid node type. ";
            }
            if (this.node.getCreatedDateTime() == null) {
                errors = errors + "\nCreated datetimestamp is missing. ";
            }
            if (this.isNodeType("FILENODE")) {
                if (this.newIStream == null) {
                    errors = errors + "\nNode is a file node but the file is missing. ";
                }
                if (!this.hasProperty("FILENAME")) {
                    errors = errors + "\nNode is a file node but the filename is unknown";
                }
            } else if (this.newIStream != null) {
                errors = errors + "\nNode is a " + this.node.getType() + " type but a file is attached. ";
            }
            if (this.isNodeType("PACKAGENODE") && !this.hasProperty("INITIALPATH")) {
                errors = errors + "\nNode is a package node but the initial path is unknown";
            }
        }
        if (errors.length() > 0) {
            throw new ValidationException(errors);
        }
    }

    protected Long save(String versionDescription, List childNodes) throws ValidationException, FileException {
        this.nodeObjectInitilised("Unable to save node.");
        this.saveDB(versionDescription);
        if (childNodes != null) {
            Iterator iter = childNodes.iterator();
            while (iter.hasNext()) {
                SimpleVersionedNode childNode = (SimpleVersionedNode)iter.next();
                childNode.saveDB(versionDescription);
            }
        }
        HashSet<SimpleVersionedNode> fileNodesWritten = new HashSet<SimpleVersionedNode>();
        String nodePaths = null;
        try {
            this.writeFile();
            if (childNodes != null) {
                Iterator iter = childNodes.iterator();
                while (iter.hasNext()) {
                    SimpleVersionedNode childNode = (SimpleVersionedNode)iter.next();
                    childNode.writeFile();
                    fileNodesWritten.add(childNode);
                    nodePaths = nodePaths != null ? nodePaths + File.pathSeparator + childNode.getFilePath() : childNode.getFilePath();
                }
            }
        }
        catch (Exception e) {
            if (fileNodesWritten.size() == 0) {
                this.log.error((Object)"Error occured while writing out files. No files already written so no files to delete. ");
            } else {
                this.log.error((Object)("Error occured while writing out files. Trying to delete already written files for the following nodes: " + nodePaths));
                String deleted = null;
                String failedDeleted = null;
                Iterator writtenIter = fileNodesWritten.iterator();
                while (writtenIter.hasNext()) {
                    SimpleVersionedNode element = (SimpleVersionedNode)writtenIter.next();
                    int delStatus = -1;
                    try {
                        delStatus = this.fileDAO.delete(element.getUUID(), element.getVersion());
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (delStatus == 1) {
                        deleted = deleted != null ? deleted + File.pathSeparator + element.getFilePath() : element.getFilePath();
                        continue;
                    }
                    failedDeleted = failedDeleted != null ? failedDeleted + File.pathSeparator + element.getFilePath() : element.getFilePath();
                }
                String msg = "Result of rolling back file changes:";
                if (deleted != null && deleted.length() > 0) {
                    msg = msg + "   deleted file(s) " + deleted;
                }
                if (failedDeleted != null && failedDeleted.length() > 0) {
                    msg = msg + "   unable to delete file(s) " + failedDeleted;
                }
                this.log.error((Object)msg);
            }
            if ((class$org$lamsfoundation$lams$contentrepository$FileException == null ? (class$org$lamsfoundation$lams$contentrepository$FileException = SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.FileException")) : class$org$lamsfoundation$lams$contentrepository$FileException).isInstance(e)) {
                throw (FileException)e;
            }
            throw new FileException("Unable to write file " + e.getMessage(), e);
        }
        return this.node.getNodeId();
    }

    private void saveDB(String versionDescription) throws ValidationException {
        this.validateNode();
        if (versionDescription != null) {
            this.nodeVersion.setVersionDescription(versionDescription);
        }
        this.nodeDAO.insert(this.node);
        if (this.childNodes != null) {
            Iterator iter = this.childNodes.iterator();
            while (iter.hasNext()) {
                CrNode node = (CrNode)iter.next();
                this.nodeDAO.insert(node);
            }
        }
    }

    private void writeFile() throws FileException {
        String filePath = null;
        if (this.newIStream != null) {
            filePath = this.fileDAO.writeFile(this.node.getNodeId(), this.nodeVersion.getVersionId(), this.newIStream);
        }
        this.setFilePath(filePath);
    }

    private String getFilePath() {
        return this.filePath;
    }

    private void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public IVersionedNode getNode(String relPath) throws ItemNotFoundException {
        CrNode childNode;
        this.nodeObjectInitilised("Unable to get child node.");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getNode for path " + relPath + " start."));
        }
        if ((childNode = this.nodeDAO.findChildNode(this.nodeVersion, relPath)) != null) {
            SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? (class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode = SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode")) : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
            newNode.node = childNode;
            newNode.nodeVersion = childNode.getNodeVersion(null);
            return newNode;
        }
        throw new ItemNotFoundException("Unable to find node with path " + relPath + " as a child of node " + this.getUUID());
    }

    public Set getChildNodes() {
        List childCrNodes = this.nodeDAO.findChildNodes(this.nodeVersion);
        HashSet<SimpleVersionedNode> childNodes = new HashSet<SimpleVersionedNode>();
        if (childCrNodes != null) {
            Iterator iter = childCrNodes.iterator();
            while (iter.hasNext()) {
                CrNode element = (CrNode)iter.next();
                SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode") : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
                newNode.node = element;
                newNode.nodeVersion = element.getNodeVersion(null);
                childNodes.add(newNode);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getNodes returning set of " + (childNodes != null ? Integer.toString(childNodes.size()) : "0") + " nodes."));
        }
        return childNodes;
    }

    public boolean hasParentNode() {
        this.nodeObjectInitilised("Unable to check if there is a parent node.");
        return this.node.getParentNodeVersion() != null;
    }

    public boolean hasNode(String relPath) {
        try {
            IVersionedNode node = this.getNode(relPath);
            return node != null;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    public boolean hasNodes() {
        List childNodes = this.nodeDAO.findChildNodes(this.nodeVersion);
        return childNodes != null && childNodes.size() > 0;
    }

    public List deleteNode() {
        Long[] versions = this.node.getVersionIds();
        ArrayList problemPaths = new ArrayList();
        for (int i = 0; i < versions.length; ++i) {
            SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode == null ? SimpleVersionedNode.class$("org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode") : class$org$lamsfoundation$lams$contentrepository$service$SimpleVersionedNode);
            newNode.node = this.node;
            newNode.nodeVersion = this.node.getNodeVersion(versions[i]);
            problemPaths.addAll(newNode.deleteVersion());
        }
        return problemPaths;
    }

    public List deleteVersion() {
        Long workspaceId = this.node.getCrWorkspace().getWorkspaceId();
        Long uuid = this.getUUID();
        Long version = this.getVersion();
        String nodeDescription = "workspace " + workspaceId + " uuid " + uuid + " version " + version;
        this.log.info((Object)("Deleting database and file entries for " + nodeDescription));
        ArrayList nodeKeysDeleted = new ArrayList();
        this.deleteVersionFromDB(nodeKeysDeleted);
        ArrayList<String> failedList = new ArrayList<String>();
        Iterator iter = nodeKeysDeleted.iterator();
        while (iter.hasNext()) {
            NodeKey nk = (NodeKey)iter.next();
            try {
                int delStatus = this.fileDAO.delete(nk.getUuid(), nk.getVersion());
                if (delStatus != -1) continue;
                failedList.add(this.fileDAO.getFilePath(nk.getUuid(), nk.getVersion()));
            }
            catch (FileException e) {
                this.log.error((Object)("FileException occured while deleting files for " + nodeDescription), (Throwable)e);
                failedList.add("Filename unknown uuid " + nk.getUuid() + " version " + nk.getVersion());
            }
        }
        if (failedList.size() > 0) {
            String filenames = null;
            Iterator failedIter = failedList.iterator();
            while (iter.hasNext()) {
                String path = (String)failedIter.next();
                filenames = filenames != null ? filenames + "," + path : path;
            }
            this.log.error((Object)("Failed to delete the following files relating to workspace " + nodeDescription + ": " + filenames));
        }
        return failedList;
    }

    private void deleteVersionFromDB(ArrayList nodeKeysDeleted) {
        Set childNodes = this.getChildNodes();
        if (childNodes != null) {
            Iterator iter = childNodes.iterator();
            while (iter.hasNext()) {
                SimpleVersionedNode element = (SimpleVersionedNode)iter.next();
                element.deleteVersionFromDB(nodeKeysDeleted);
            }
        }
        NodeKey nk = this.getNodeKey();
        Set versions = this.node.getCrNodeVersions();
        if (versions != null) {
            versions.remove(this.nodeVersion);
        } else {
            this.nodeDAO.delete(this.nodeVersion);
        }
        if (versions == null || versions.size() == 0) {
            this.nodeDAO.delete(this.node);
        }
        nodeKeysDeleted.add(nk);
    }

    public INodeDAO getNodeDAO() {
        return this.nodeDAO;
    }

    public void setNodeDAO(INodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public IFileDAO getFileDAO() {
        return this.fileDAO;
    }

    public void setFileDAO(IFileDAO fileDAO) {
        this.fileDAO = fileDAO;
    }

    public void destroy() {
        System.out.println("SimpleVersionedNode destroy called!");
        try {
            if (this.newIStream != null) {
                this.newIStream.close();
            }
        }
        catch (IOException e) {
            this.log.debug((Object)"Unable to close stream - was it already closed perhaps?", (Throwable)e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

