/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.Ordered;

public class DefaultIntroductionAdvisor
implements IntroductionAdvisor,
ClassFilter,
Ordered,
Serializable {
    private static final long serialVersionUID = 1360502830817661569L;
    private int order = Integer.MAX_VALUE;
    private Advice advice;
    private Set interfaces = new HashSet();

    public DefaultIntroductionAdvisor(Advice advice) {
        if (advice instanceof IntroductionInfo) {
            this.init(advice, (IntroductionInfo)advice);
        } else {
            this.advice = advice;
        }
    }

    public DefaultIntroductionAdvisor(DynamicIntroductionAdvice advice, Class clazz) {
        this.advice = advice;
        this.addInterface(clazz);
    }

    public DefaultIntroductionAdvisor(Advice advice, IntroductionInfo introductionInfo) {
        this.init(advice, introductionInfo);
    }

    private void init(Advice advice, IntroductionInfo introductionInfo) {
        this.advice = advice;
        Class[] introducedInterfaces = introductionInfo.getInterfaces();
        if (introducedInterfaces.length == 0) {
            throw new IllegalArgumentException("IntroductionAdviceSupport implements no interfaces");
        }
        for (int i = 0; i < introducedInterfaces.length; ++i) {
            this.addInterface(introducedInterfaces[i]);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void addInterface(Class intf) {
        this.interfaces.add(intf);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void validateInterfaces() throws IllegalArgumentException {
        Iterator ut = this.interfaces.iterator();
        while (ut.hasNext()) {
            Class intf = (Class)ut.next();
            if (!intf.isInterface()) {
                throw new IllegalArgumentException("Class '" + intf.getName() + "' is not an interface; cannot be used in an introduction");
            }
            if (!(this.advice instanceof DynamicIntroductionAdvice) || ((DynamicIntroductionAdvice)this.advice).implementsInterface(intf)) continue;
            throw new IllegalArgumentException("IntroductionAdvice [" + this.advice + "] " + "does not implement interface '" + intf.getName() + "' specified in introduction advice");
        }
    }

    public String toString() {
        return "DefaultIntroductionAdvisor: interfaces=[" + AopUtils.interfacesString(this.interfaces) + "]; introductionInterceptor=[" + this.advice + "]";
    }
}

