/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.prefs;

import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.jdom.XMLUtils;

public abstract class UserPrefs {
    private Document _doc = this.load();

    protected UserPrefs() {
        this.setDefaultValues();
    }

    protected Document load() {
        Document doc = null;
        File prefsFile = this.getPrefsFile();
        if (prefsFile.exists()) {
            Element root;
            String rootName;
            try {
                doc = XMLUtils.readXMLFile((File)prefsFile);
            }
            catch (Exception ex) {
                doc = this.createNewPrefsFile();
            }
            if (doc != null && doc.hasRootElement() && !(rootName = (root = doc.getRootElement()).getName()).equals(this.getElementRootName())) {
                doc = this.createNewPrefsFile();
            }
        }
        if (doc == null) {
            doc = this.createNewPrefsFile();
        }
        return doc;
    }

    public void save() throws IOException {
        File file = this.getPrefsFile();
        XMLUtils.write2XMLFile((Document)this._doc, (File)file);
    }

    protected Document createNewPrefsFile() {
        Document doc = new Document();
        doc.setRootElement(new Element(this.getElementRootName()));
        return doc;
    }

    public String getValue(String key) {
        Element element;
        if (this._doc != null && this._doc.hasRootElement() && (element = this._doc.getRootElement().getChild(key)) != null) {
            return element.getText();
        }
        return null;
    }

    public boolean getBooleanValue(String key) {
        String value = this.getValue(key);
        return value == null ? false : value.equals("true");
    }

    public void putBooleanValue(String key, boolean value) {
        this.putValue(key, value ? "true" : "false");
    }

    public void putValue(String key, String value) {
        if (this._doc != null) {
            Element element;
            Element root = this._doc.getRootElement();
            if (root == null) {
                root = new Element(this.getElementRootName());
                this._doc.setRootElement(root);
            }
            if ((element = root.getChild(key)) != null) {
                element.setText(value);
            } else {
                element = new Element(key);
                element.setText(value);
                root.addContent(element);
            }
        }
    }

    public void removeValue(String key) {
        if (this._doc != null && this._doc.hasRootElement()) {
            this._doc.getRootElement().removeChild(key);
        }
    }

    public abstract File getPrefsFile();

    protected abstract void setDefaultValues();

    public abstract String getElementRootName();
}

