/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCacheView;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.TreeCacheAopGui;

public class TreeCacheAopView {
    TreeCacheAopGui gui_ = null;
    TreeCacheAop cache_ = null;
    static Logger logger_ = Logger.getLogger((String)(class$org$jboss$cache$aop$TreeCacheAopView == null ? (class$org$jboss$cache$aop$TreeCacheAopView = TreeCacheAopView.class$("org.jboss.cache.aop.TreeCacheAopView")) : class$org$jboss$cache$aop$TreeCacheAopView).getName());
    static /* synthetic */ Class class$org$jboss$cache$aop$TreeCacheAopView;

    public TreeCacheAopView(TreeCacheAop cache) throws Exception {
        this.cache_ = cache;
    }

    public void start() throws Exception {
        if (this.gui_ == null) {
            logger_.info((Object)"start(): creating the GUI");
            this.gui_ = new TreeCacheAopGui(this.cache_);
        }
    }

    public void stop() {
        if (this.gui_ != null) {
            logger_.info((Object)"stop(): disposing the GUI");
            this.gui_.dispose();
            this.gui_ = null;
        }
    }

    void populateTree(String dir) throws Exception {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        this.put(dir, null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.populateTree(dir + "/" + children[i]);
            }
        }
    }

    void put(String fqn, Map m) {
        try {
            this.cache_.put(fqn, m);
        }
        catch (Throwable t) {
            System.err.println("TreeCacheAopView.put(): " + t);
        }
    }

    public static void main(String[] args) {
        TreeCacheAop tree = null;
        String start_directory = null;
        String resource = "META-INF/replSync-service.xml";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-config")) {
                TreeCacheAopView.help();
                return;
            }
            resource = args[++i];
        }
        try {
            tree = new TreeCacheAop();
            PropertyConfigurator config = new PropertyConfigurator();
            config.configure((Object)tree, resource);
            tree.addTreeCacheListener(new TreeCacheView.MyListener());
            tree.createService();
            tree.startService();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(tree));
            TreeCacheAopView demo = new TreeCacheAopView(tree);
            demo.start();
            if (start_directory != null && start_directory.length() > 0) {
                demo.populateTree(start_directory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("TreeCacheAopView [-help] [-config <configuration file (XML)][-mbean_name <name of TreeCache MBean>] [-start_directory <dirname>] [-props <props>] [-use_queue <true/false>] [-queue_interval <ms>] [-queue_max_elements <num>]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ShutdownThread
    extends Thread {
        TreeCacheAop tree = null;

        ShutdownThread(TreeCacheAop tree) {
            this.tree = tree;
        }

        public void run() {
            this.tree.stop();
        }
    }
}

