/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.blocks.MethodCall;

public class CacheLoaderInterceptor
extends Interceptor {
    private CacheLoader loader = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Fqn fqn = null;
        Node n = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        boolean load_attributes = false;
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal)) {
            fqn = (Fqn)args[1];
            load_attributes = true;
        } else if (!meth.equals(TreeCache.removeNodeMethodLocal)) {
            if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
                fqn = (Fqn)args[1];
                load_attributes = true;
            } else if (meth.equals(TreeCache.addChildMethodLocal)) {
                fqn = (Fqn)args[1];
            } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
                fqn = (Fqn)args[0];
            } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
                fqn = (Fqn)args[0];
                load_attributes = true;
            } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
                fqn = (Fqn)args[0];
            }
        }
        CacheLoaderInterceptor cacheLoaderInterceptor = this;
        synchronized (cacheLoaderInterceptor) {
            Map children;
            if (fqn != null && (!this.cache.exists(fqn) || this.cache.exists(fqn, (Object)"jboss:internal:uninitialized"))) {
                n = this.loadNode(fqn);
                if (load_attributes && n != null) {
                    this.loadAttributesFromCacheLoader(n);
                }
                this.lock(fqn, 2, false);
            }
            if (meth.equals(TreeCache.getChildrenNamesMethodLocal) && n != null && fqn != null && (children = n.getChildren()) == null) {
                Set children_names = null;
                try {
                    children_names = this.loader.getChildrenNames(fqn);
                }
                catch (Exception e) {
                    this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
                }
                if (children_names != null) {
                    Iterator it = children_names.iterator();
                    while (it.hasNext()) {
                        String child_name = (String)it.next();
                        Fqn child_fqn = new Fqn(n.getFqn(), child_name);
                        n.createChild(child_name, child_fqn, n, "jboss:internal:uninitialized", null);
                    }
                    this.lock(fqn, 1, true);
                }
            }
        }
        return super.invoke(m);
    }

    private void lock(Fqn fqn, int lock_type, boolean recursive) throws Throwable {
        MethodCall meth = new MethodCall(TreeCache.lockMethodLocal, new Object[]{fqn, new Integer(lock_type), new Boolean(recursive)});
        super.invoke(meth);
    }

    private Node loadNode(Fqn fqn) {
        Node child_node = null;
        Fqn tmp_fqn = new Fqn();
        if (fqn == null) {
            return null;
        }
        int treeNodeSize = fqn.size();
        Node n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize && n != null; ++i) {
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            child_node = n.getChild(child_name);
            if (child_node == null) {
                try {
                    if (this.loader.exists(fqn)) {
                        child_node = n.createChild(child_name, tmp_fqn, n, "jboss:internal:uninitialized", null);
                        this.cache.notifyNodeLoaded(tmp_fqn);
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)("failed loading node " + fqn + " from CacheLoader"), t);
                }
            }
            n = child_node;
        }
        return n;
    }

    private void loadAttributesFromCacheLoader(Node n) {
        if (n == null || !n.containsKey("jboss:internal:uninitialized")) {
            return;
        }
        try {
            Map m = this.loader.get(n.getFqn());
            n.remove("jboss:internal:uninitialized");
            n.put(m);
        }
        catch (Throwable t) {
            this.log.error((Object)("failure when lazily loading attributes of " + n.getFqn()), t);
        }
    }
}

