/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.TreeCache;
import org.jboss.cache.transaction.DummyTransactionManager;

public class RestartTest
extends TestCase {
    static /* synthetic */ Class class$org$jboss$cache$tests$RestartTest;

    public void testLocalRestartNoTransactions() throws Exception {
        TreeCache cache = this.createCache(1);
        cache.createService();
        cache.startService();
        cache.put("/a/b/c", null);
        RestartTest.assertTrue((cache.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        RestartTest.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        System.out.println("cache locks before restart:\n" + cache.printLockInfo());
        this.restartCache(cache);
        System.out.println("cache locks after restart:\n" + cache.printLockInfo());
        RestartTest.assertTrue((cache.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        RestartTest.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
    }

    public void testLocalRestartWithTransactions() throws Exception {
        TreeCache cache = this.createCache(1);
        cache.createService();
        cache.startService();
        Transaction tx = this.beginTransaction();
        cache.put("/a/b/c", null);
        System.out.println("cache locks before restart:\n" + cache.printLockInfo());
        RestartTest.assertTrue((cache.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        RestartTest.assertEquals((int)3, (int)cache.getNumberOfLocksHeld());
        this.restartCache(cache);
        System.out.println("cache locks after restart:\n" + cache.printLockInfo());
        RestartTest.assertEquals((int)3, (int)cache.getNumberOfLocksHeld());
        RestartTest.assertTrue((cache.getNumberOfNodes() > 0 ? 1 : 0) != 0);
        tx.rollback();
        RestartTest.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
    }

    TreeCache createCache(int cache_mode) throws Exception {
        TreeCache retval = new TreeCache();
        retval.setCacheMode(cache_mode);
        retval.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        return retval;
    }

    Transaction beginTransaction() throws SystemException, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        return tx;
    }

    void startCache(TreeCache c) throws Exception {
        c.createService();
        c.startService();
    }

    void stopCache(TreeCache c) {
        c.stopService();
        c.destroyService();
    }

    void restartCache(TreeCache c) throws Exception {
        this.stopCache(c);
        this.startCache(c);
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$RestartTest == null ? (class$org$jboss$cache$tests$RestartTest = RestartTest.class$("org.jboss.cache.tests.RestartTest")) : class$org$jboss$cache$tests$RestartTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RestartTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

