/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring;

import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ContributionTypes;

public class ContributeActivityDTO {
    private String title;
    private String description;
    private Long activityID;
    private Integer activityTypeID;
    private Integer orderID;
    private Long parentActivityID;
    private Vector<ContributeActivityDTO> childActivities;
    private Vector<ContributeEntry> contributeEntries;

    public ContributeActivityDTO(Activity activity) {
        this.title = activity.getTitle();
        this.description = activity.getDescription();
        this.activityID = activity.getActivityId();
        this.activityTypeID = activity.getActivityTypeId();
        this.orderID = activity.getOrderId();
        if (activity.getParentActivity() != null) {
            this.parentActivityID = activity.getParentActivity().getActivityId();
        }
        this.contributeEntries = new Vector();
    }

    public Long getActivityID() {
        return this.activityID;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public String getTitle() {
        return this.title;
    }

    public Vector<ContributeEntry> getContributeEntries() {
        return this.contributeEntries;
    }

    public void setChildActivities(Vector<ContributeActivityDTO> childActivities) {
        this.childActivities = childActivities;
    }

    public Vector<ContributeActivityDTO> getChildActivities() {
        return this.childActivities;
    }

    public Long getParentActivityID() {
        return this.parentActivityID;
    }

    public void addContribution(Integer contributionType, String url) {
        ContributeEntry entry = new ContributeEntry();
        entry.setContributionType(contributionType);
        entry.setURL(url);
        this.contributeEntries.add(entry);
    }

    class ContributeEntry {
        private Boolean isRequired;
        private Integer contributionType;
        private String url;

        ContributeEntry() {
        }

        public Integer getContributionType() {
            return this.contributionType;
        }

        public void setContributionType(Integer contributionType) {
            this.contributionType = contributionType;
            boolean isReq = contributionType != null && (contributionType.equals(ContributionTypes.DEFINE_LATER) || contributionType.equals(ContributionTypes.PERMISSION_GATE) || contributionType.equals(ContributionTypes.CHOSEN_GROUPING));
            this.isRequired = new Boolean(isReq);
        }

        public Boolean getIsRequired() {
            return this.isRequired;
        }

        public String getURL() {
            return this.url;
        }

        public void setURL(String url) {
            this.url = url;
        }
    }
}

