/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import java.util.Vector;
import org.apache.commons.collections.ArrayStack;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignProcessor;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;
import org.lamsfoundation.lams.monitoring.ContributeActivityDTO;
import org.lamsfoundation.lams.monitoring.ContributeDTOFactory;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;

public class ContributeActivitiesProcessor
extends LearningDesignProcessor {
    Vector<ContributeActivityDTO> mainActivityList;
    ArrayStack activityListStack;
    Vector<ContributeActivityDTO> currentActivityList;
    ILamsCoreToolService toolService;
    Long lessonID;

    public ContributeActivitiesProcessor(LearningDesign design, Long lessonID, IActivityDAO activityDAO, ILamsCoreToolService toolService) {
        super(design, activityDAO);
        this.lessonID = lessonID;
        this.toolService = toolService;
        this.mainActivityList = new Vector();
        this.activityListStack = new ArrayStack(5);
        this.currentActivityList = this.mainActivityList;
    }

    public Vector<ContributeActivityDTO> getMainActivityList() {
        return this.mainActivityList;
    }

    public void startComplexActivity(ComplexActivity activity) {
        this.activityListStack.push(this.currentActivityList);
        this.currentActivityList = new Vector();
    }

    public void endComplexActivity(ComplexActivity activity) {
        ContributeActivityDTO dto = null;
        if (this.currentActivityList.size() > 0) {
            dto = ContributeDTOFactory.getContributeActivityDTO(activity);
            dto.setChildActivities(this.currentActivityList);
        }
        this.currentActivityList = (Vector)this.activityListStack.pop();
        if (dto != null) {
            this.currentActivityList.add(dto);
        }
    }

    public void startSimpleActivity(SimpleActivity activity) {
    }

    public void endSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
        try {
            ContributeActivityDTO dto = ContributeDTOFactory.getContributeActivityDTO(this.lessonID, activity, this.toolService);
            if (dto != null) {
                this.currentActivityList.add(dto);
            }
        }
        catch (LamsToolServiceException e) {
            throw new LearningDesignProcessorException((Throwable)e);
        }
    }
}

