/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.ContributeActivityDTO;
import org.lamsfoundation.lams.monitoring.MonitoringConstants;
import org.lamsfoundation.lams.monitoring.service.ContributeActivitiesProcessor;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserFlashDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.AuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MonitoringService
implements IMonitoringService,
ApplicationContextAware {
    private static Logger log = Logger.getLogger(MonitoringService.class);
    private static final long numMilliSecondsInADay = 86400000L;
    private static final String AUDIT_LEARNER_PORTFOLIO_SET = "audit.learner.portfolio.set";
    private static final String AUDIT_LESSON_CREATED_KEY = "audit.lesson.created";
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private ITransitionDAO transitionDAO;
    private IActivityDAO activityDAO;
    private IBaseDAO baseDAO;
    private ILearningDesignDAO learningDesignDAO;
    private IGroupingDAO groupingDAO;
    private IAuthoringService authoringService;
    private ICoreLearnerService learnerService;
    private ILessonService lessonService;
    private ILamsCoreToolService lamsCoreToolService;
    private IUserManagementService userManagementService;
    private Scheduler scheduler;
    private ApplicationContext applicationContext;
    private MessageService messageService;
    private AuditService auditService;
    private static final String FORCE_COMPLETE_STOP_MESSAGE_ACTIVITY_DONE = "force.complete.stop.message.activity.done";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GROUPING_ERROR = "force.complete.stop.message.grouping.error";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GROUPING = "force.complete.stop.message.grouping";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_GATE = "force.complete.stop.message.gate";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_ACTIVITY = "force.complete.stop.message.completed.to.activity";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_COMPLETED_TO_END = "force.complete.stop.message.completed.to.end";
    private static final String FORCE_COMPLETE_STOP_MESSAGE_STOPPED_UNEXPECTEDLY = "force.complete.stop.message.stopped.unexpectedly";

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearnerService(ICoreLearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsToolService) {
        this.lamsCoreToolService = lamsToolService;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    private void auditAction(String messageKey, Object[] args) {
        String message = this.messageService.getMessage(messageKey, args);
        this.auditService.log("Monitoring", message);
    }

    private void checkOwnerOrStaffMember(Integer userId, Lesson lesson, String actionDescription) {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userId);
        if (lesson.getUser() != null && lesson.getUser().getUserId().equals(userId)) {
            return;
        }
        if (lesson == null || lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(user)) {
            throw new UserAccessDeniedException("User " + userId + " may not " + actionDescription + " for lesson " + lesson.getLessonId());
        }
    }

    @Override
    public Lesson initializeLesson(String lessonName, String lessonDescription, Boolean learnerExportAvailable, long learningDesignId, Integer organisationId, Integer userID) {
        LearningDesign originalLearningDesign = this.authoringService.getLearningDesign(new Long(learningDesignId));
        if (originalLearningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignId + " is missing. Unable to initialize lesson.");
        }
        WorkspaceFolder runSeqFolder = null;
        int MAX_DEEP_LEVEL_FOLDER = 50;
        if (organisationId != null) {
            Organisation org = (Organisation)this.baseDAO.find(Organisation.class, (Serializable)organisationId);
            for (int idx = 0; idx < MAX_DEEP_LEVEL_FOLDER && org != null; org = org.getParentOrganisation(), ++idx) {
                Workspace workspace = org.getWorkspace();
                if (workspace != null) {
                    runSeqFolder = workspace.getDefaultRunSequencesFolder();
                }
                if (runSeqFolder != null) break;
            }
        }
        User user = userID != null ? (User)this.baseDAO.find(User.class, (Serializable)userID) : null;
        return this.initializeLesson(lessonName, lessonDescription, learnerExportAvailable, originalLearningDesign, user, runSeqFolder, 2);
    }

    @Override
    public Lesson initializeLessonForPreview(String lessonName, String lessonDescription, long learningDesignId, Integer userID) {
        LearningDesign originalLearningDesign = this.authoringService.getLearningDesign(new Long(learningDesignId));
        if (originalLearningDesign == null) {
            throw new MonitoringServiceException("Learning design for id=" + learningDesignId + " is missing. Unable to initialize lesson.");
        }
        User user = userID != null ? (User)this.baseDAO.find(User.class, (Serializable)userID) : null;
        return this.initializeLesson(lessonName, lessonDescription, Boolean.TRUE, originalLearningDesign, user, null, 3);
    }

    public Lesson initializeLesson(String lessonName, String lessonDescription, Boolean learnerExportAvailable, LearningDesign originalLearningDesign, User user, WorkspaceFolder workspaceFolder, int copyType) {
        String newName = originalLearningDesign.getTitle();
        if (workspaceFolder != null && copyType == 2) {
            List ldList = this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
            int idx = 1;
            Calendar calendar = Calendar.getInstance();
            int mth = calendar.get(2) + 1;
            String mthStr = new Integer(mth).toString();
            if (mth < 10) {
                mthStr = "0" + mthStr;
            }
            int day = calendar.get(5);
            String dayStr = new Integer(day).toString();
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String nameMid = dayStr + mthStr + calendar.get(1);
            while (true) {
                boolean dupName = false;
                for (LearningDesign eld : ldList) {
                    if (!StringUtils.equals((String)eld.getTitle(), (String)newName)) continue;
                    dupName = true;
                    break;
                }
                if (!dupName) break;
                newName = originalLearningDesign.getTitle() + "_" + nameMid + "_" + idx;
                ++idx;
            }
        }
        LearningDesign copiedLearningDesign = this.authoringService.copyLearningDesign(originalLearningDesign, new Integer(copyType), user, workspaceFolder, true);
        copiedLearningDesign.setTitle(newName);
        this.authoringService.saveLearningDesign(copiedLearningDesign);
        Lesson lesson = this.createNewLesson(lessonName, lessonDescription, user, learnerExportAvailable, copiedLearningDesign);
        this.auditAction(AUDIT_LESSON_CREATED_KEY, new Object[]{lessonName, copiedLearningDesign.getTitle(), learnerExportAvailable});
        return lesson;
    }

    @Override
    public String initializeLesson(Integer creatorUserId, String lessonPacket) throws Exception {
        FlashMessage flashMessage = null;
        try {
            String desc;
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)lessonPacket);
            String title = WDDXProcessor.convertToString((String)"lessonName", table.get("lessonName"));
            if (title == null) {
                title = "lesson";
            }
            if ((desc = WDDXProcessor.convertToString((String)"lessonDescription", table.get("lessonDescription"))) == null) {
                desc = "description";
            }
            int copyType = WDDXProcessor.convertToInt((String)"copyType", table.get("copyType"));
            Integer organisationId = WDDXProcessor.convertToInteger((String)"organisationID", table.get("organisationID"));
            long ldId = WDDXProcessor.convertToLong((String)"learningDesignID", table.get("learningDesignID"));
            boolean learnerExportAvailable = WDDXProcessor.convertToBoolean((String)"learnerExportPortfolio", table.get("learnerExportPortfolio"));
            Lesson newLesson = null;
            newLesson = copyType == 3 ? this.initializeLessonForPreview(title, desc, ldId, creatorUserId) : this.initializeLesson(title, desc, learnerExportAvailable, ldId, organisationId, creatorUserId);
            if (newLesson != null) {
                flashMessage = new FlashMessage("initializeLesson", (Object)newLesson.getLessonId());
            }
            return flashMessage.serializeMessage();
        }
        catch (Exception e) {
            log.error((Object)"Exception occured trying to create a lesson class ", (Throwable)e);
            throw new Exception(e);
        }
    }

    @Override
    public String createLessonClassForLessonWDDX(Integer creatorUserId, String lessonPacket) throws UserAccessDeniedException {
        FlashMessage flashMessage = null;
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)lessonPacket);
            Integer orgId = WDDXProcessor.convertToInteger((String)"organisationID", table.get("organisationID"));
            long lessonId = WDDXProcessor.convertToLong((String)"lessonID", table.get("lessonID"));
            Hashtable learnerMap = (Hashtable)table.get("learners");
            LinkedList learners = (LinkedList)learnerMap.get(MonitoringConstants.KEY_USERS);
            String learnerGroupName = WDDXProcessor.convertToString((Hashtable)learnerMap, (String)"groupName");
            Hashtable staffMap = (Hashtable)table.get("staff");
            LinkedList staffs = (LinkedList)staffMap.get(MonitoringConstants.KEY_USERS);
            String staffGroupName = WDDXProcessor.convertToString((Hashtable)staffMap, (String)"groupName");
            if (learners == null) {
                learners = new LinkedList();
            }
            if (staffs == null) {
                staffs = new LinkedList();
            }
            Organisation organisation = (Organisation)this.baseDAO.find(Organisation.class, (Serializable)orgId);
            User creator = (User)this.baseDAO.find(User.class, (Serializable)creatorUserId);
            LinkedList<User> learnerList = new LinkedList<User>();
            Iterator iter = learners.iterator();
            while (iter.hasNext()) {
                try {
                    int id = ((Double)iter.next()).intValue();
                    learnerList.add((User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(id)));
                }
                catch (Exception e) {
                    log.error((Object)("Error parsing learner ID from " + lessonPacket));
                }
            }
            LinkedList<User> staffList = new LinkedList<User>();
            staffList.add(creator);
            iter = staffs.iterator();
            while (iter.hasNext()) {
                try {
                    int id = ((Double)iter.next()).intValue();
                    staffList.add((User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(id)));
                }
                catch (Exception e) {
                    log.error((Object)("Error parsing staff ID from " + lessonPacket));
                }
            }
            this.createLessonClassForLesson(lessonId, organisation, learnerGroupName, learnerList, staffGroupName, staffList, creatorUserId);
            flashMessage = new FlashMessage("createLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error((Object)"Exception occured trying to create a lesson class ", (Throwable)e);
            flashMessage = new FlashMessage("createLesson", (Object)e.getMessage(), 1);
        }
        String message = "Failed on creating flash message:" + flashMessage;
        try {
            message = flashMessage.serializeMessage();
        }
        catch (IOException e) {
            log.error((Object)message);
        }
        return message;
    }

    @Override
    public Lesson createLessonClassForLesson(long lessonId, Organisation organisation, String learnerGroupName, List<User> organizationUsers, String staffGroupName, List<User> staffs, Integer userId) {
        Lesson newLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (newLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to create class for lesson.");
        }
        this.checkOwnerOrStaffMember(userId, newLesson, "create lesson class");
        if (!newLesson.isLessonStarted()) {
            if (newLesson == null) {
                throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to create class for lesson.");
            }
            LessonClass oldLessonClass = newLesson.getLessonClass();
            LessonClass newLessonClass = this.createLessonClass(organisation, learnerGroupName, organizationUsers, staffGroupName, staffs, newLesson);
            newLessonClass.setLesson(newLesson);
            newLesson.setLessonClass(newLessonClass);
            newLesson.setOrganisation(organisation);
            this.lessonDAO.updateLesson(newLesson);
            if (oldLessonClass != null) {
                this.lessonClassDAO.deleteLessonClass(oldLessonClass);
            }
        } else {
            this.lessonService.addLearners(newLesson, organizationUsers);
            this.lessonService.addStaffMembers(newLesson, staffs);
        }
        return newLesson;
    }

    @Override
    public void startLessonOnSchedule(long lessonId, Date startDate, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "start lesson on schedule");
        if (requestedLesson.isLessonStarted()) {
            log.error((Object)("Lesson for id=" + lessonId + " has been started. Unable to schedule lesson start."));
            return;
        }
        if (requestedLesson.getScheduleStartDate() != null) {
            log.error((Object)("Lesson for id=" + lessonId + " is already scheduled and cannot be rescheduled."));
            return;
        }
        JobDetail startLessonJob = this.getStartScheduleLessonJob();
        startLessonJob.setName("startLessonOnSchedule:" + lessonId);
        startLessonJob.setDescription(requestedLesson.getLessonName() + ":" + (requestedLesson.getUser() == null ? "" : requestedLesson.getUser().getFullName()));
        startLessonJob.getJobDataMap().put((Object)"lessonID", (Object)new Long(lessonId));
        startLessonJob.getJobDataMap().put((Object)"userID", (Object)new Integer(userId));
        SimpleTrigger startLessonTrigger = new SimpleTrigger("startLessonOnScheduleTrigger:" + lessonId, "DEFAULT", startDate);
        try {
            requestedLesson.setScheduleStartDate(startDate);
            this.scheduler.scheduleJob(startLessonJob, (Trigger)startLessonTrigger);
            this.setLessonState(requestedLesson, Lesson.NOT_STARTED_STATE);
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [startLessonOnSchedule]- fail to start scheduling", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start lesson  [" + lessonId + "] on schedule is configured"));
        }
    }

    @Override
    public void finishLessonOnSchedule(long lessonId, Date endDate, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "finish lesson on schedule");
        JobDetail finishLessonJob = this.getFinishScheduleLessonJob();
        finishLessonJob.setName("finishLessonOnSchedule:" + lessonId);
        finishLessonJob.setDescription(requestedLesson.getLessonName() + ":" + (requestedLesson.getUser() == null ? "" : requestedLesson.getUser().getFullName()));
        finishLessonJob.getJobDataMap().put((Object)"lessonID", (Object)new Long(lessonId));
        finishLessonJob.getJobDataMap().put((Object)"userID", (Object)new Integer(userId));
        SimpleTrigger finishLessonTrigger = new SimpleTrigger("finishLessonOnScheduleTrigger:" + lessonId, "DEFAULT", endDate);
        try {
            requestedLesson.setScheduleEndDate(endDate);
            this.scheduler.scheduleJob(finishLessonJob, (Trigger)finishLessonTrigger);
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [finishLessonOnSchedule]- fail to start scheduling", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finish lesson  [" + lessonId + "] on schedule is configured"));
        }
    }

    @Override
    public void startLesson(long lessonId, Integer userId) {
        Lesson requestedLesson;
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Starting Lesson " + lessonId + "=============="));
        }
        if ((requestedLesson = this.lessonDAO.getLesson(new Long(lessonId))) == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to start lesson.");
        }
        if (requestedLesson.isLessonStarted()) {
            log.warn((Object)("Lesson for id=" + lessonId + " has been started. No need to start the lesson. The lesson was probably scheduled, and then the staff used \"Start now\". This message would have then been created by the schedule start"));
            return;
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "create lesson class");
        Date lessonStartTime = new Date();
        Set activities = requestedLesson.getLearningDesign().getActivities();
        for (Activity activity : activities) {
            if (activity.isToolActivity()) {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                this.initToolSessionIfSuitable(toolActivity, requestedLesson);
            }
            if (activity.getActivityTypeId() != 4) continue;
            ScheduleGateActivity gateActivity = (ScheduleGateActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
            this.runGateScheduler(gateActivity, lessonStartTime, requestedLesson.getLessonName());
        }
        requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
        requestedLesson.setStartDateTime(lessonStartTime);
        this.lessonDAO.updateLesson(requestedLesson);
        if (log.isDebugEnabled()) {
            log.debug((Object)("=============Lesson " + lessonId + " started==============="));
        }
    }

    @Override
    public void finishLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to finished");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "finish lesson");
        this.setLessonState(requestedLesson, Lesson.FINISHED_STATE);
    }

    @Override
    public void archiveLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to archived");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "archive lesson");
        if (!Lesson.ARCHIVED_STATE.equals(requestedLesson.getLessonStateId()) && !Lesson.REMOVED_STATE.equals(requestedLesson.getLessonStateId())) {
            this.setLessonState(requestedLesson, Lesson.ARCHIVED_STATE);
        }
    }

    @Override
    public void unarchiveLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set lesson to archived");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "unarchive lesson");
        this.revertLessonState(requestedLesson);
    }

    @Override
    public void suspendLesson(long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(userId, lesson, "suspend lesson");
        if (lesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to suspend lesson.");
        }
        if (!Lesson.SUSPENDED_STATE.equals(lesson.getLessonStateId()) && !Lesson.REMOVED_STATE.equals(lesson.getLessonStateId())) {
            this.setLessonState(lesson, Lesson.SUSPENDED_STATE);
        }
    }

    @Override
    public void unsuspendLesson(long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(userId, lesson, "unsuspend lesson");
        Integer state = lesson.getLessonStateId();
        if (!Lesson.SUSPENDED_STATE.equals(state)) {
            throw new MonitoringServiceException("Lesson is not suspended lesson. It can not be unsuspended.");
        }
        if (lesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to suspend lesson.");
        }
        this.revertLessonState(lesson);
    }

    private void setLessonState(Lesson requestedLesson, Integer status) {
        requestedLesson.setPreviousLessonStateId(requestedLesson.getLessonStateId());
        requestedLesson.setLessonStateId(status);
        this.lessonDAO.updateLesson(requestedLesson);
    }

    private void revertLessonState(Lesson requestedLesson) {
        Integer currentStatus = requestedLesson.getLessonStateId();
        if (requestedLesson.getPreviousLessonStateId() != null) {
            if (requestedLesson.getPreviousLessonStateId().equals(Lesson.NOT_STARTED_STATE) && requestedLesson.getScheduleStartDate().before(new Date())) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else {
                requestedLesson.setLessonStateId(requestedLesson.getPreviousLessonStateId());
            }
            requestedLesson.setPreviousLessonStateId(null);
        } else {
            if (requestedLesson.getStartDateTime() != null && requestedLesson.getScheduleStartDate() != null) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else if (requestedLesson.getScheduleStartDate() != null) {
                if (requestedLesson.getScheduleStartDate().after(new Date())) {
                    requestedLesson.setLessonStateId(Lesson.NOT_STARTED_STATE);
                } else {
                    requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
                }
            } else if (requestedLesson.getStartDateTime() != null) {
                requestedLesson.setLessonStateId(Lesson.STARTED_STATE);
            } else {
                requestedLesson.setLessonStateId(Lesson.CREATED);
            }
            requestedLesson.setPreviousLessonStateId(currentStatus);
        }
        this.lessonDAO.updateLesson(requestedLesson);
    }

    @Override
    public void removeLesson(long lessonId, Integer userId) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to remove lesson.");
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "remove lesson");
        this.setLessonState(requestedLesson, Lesson.REMOVED_STATE);
    }

    @Override
    public Boolean setLearnerPortfolioAvailable(long lessonId, Integer userId, Boolean learnerExportAvailable) {
        Lesson requestedLesson = this.lessonDAO.getLesson(new Long(lessonId));
        if (requestedLesson == null) {
            throw new MonitoringServiceException("Lesson for id=" + lessonId + " is missing. Unable to set learner portfolio available to " + learnerExportAvailable);
        }
        this.checkOwnerOrStaffMember(userId, requestedLesson, "set learner portfolio available");
        requestedLesson.setLearnerExportAvailable(learnerExportAvailable != null ? learnerExportAvailable : Boolean.FALSE);
        this.auditAction(AUDIT_LEARNER_PORTFOLIO_SET, new Object[]{requestedLesson.getLessonName(), requestedLesson.getLearnerExportAvailable()});
        this.lessonDAO.updateLesson(requestedLesson);
        return requestedLesson.getLearnerExportAvailable();
    }

    @Override
    public GateActivity openGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        if (gate != null) {
            gate.setGateOpen(new Boolean(true));
            this.activityDAO.update((Object)gate);
        }
        return gate;
    }

    @Override
    public GateActivity closeGate(Long gateId) {
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(gateId);
        gate.setGateOpen(new Boolean(false));
        this.activityDAO.update((Object)gate);
        return gate;
    }

    @Override
    public String forceCompleteLessonByUser(Integer learnerId, Integer requesterId, long lessonId, Long activityId) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonId));
        this.checkOwnerOrStaffMember(requesterId, lesson, "force complete");
        User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerId);
        LearnerProgress learnerProgress = this.learnerService.getProgress(learnerId, Long.valueOf(lessonId));
        Activity stopActivity = null;
        if (activityId != null) {
            stopActivity = this.activityDAO.getActivityByActivityId(activityId);
            if (stopActivity == null) {
                throw new MonitoringServiceException("Activity missing. Activity id" + activityId);
            }
            if (learnerProgress != null && learnerProgress.getCompletedActivities().contains(stopActivity)) {
                return this.messageService.getMessage(FORCE_COMPLETE_STOP_MESSAGE_ACTIVITY_DONE, new Object[]{stopActivity.getTitle()});
            }
        }
        Activity currentActivity = learnerProgress.getCurrentActivity();
        String stopReason = null;
        if (currentActivity != null) {
            stopReason = this.forceCompleteActivity(learner, lessonId, learnerProgress, currentActivity, stopActivity, new ArrayList<Long>());
        }
        return stopReason != null ? stopReason : this.messageService.getMessage(FORCE_COMPLETE_STOP_MESSAGE_STOPPED_UNEXPECTEDLY);
    }

    /*
     * Unable to fully structure code
     */
    private String forceCompleteActivity(User learner, Long lessonId, LearnerProgress progress, Activity activity, Activity stopActivity, ArrayList<Long> touchedActivityIds) {
        stopReason = null;
        activity = this.activityDAO.getActivityByActivityId(activity.getActivityId());
        touchedActivityIds.add(activity.getActivityId());
        if (activity.isGroupingActivity()) {
            groupActivity = (GroupingActivity)activity;
            grouping = groupActivity.getCreateGrouping();
            myGroup = grouping.getGroupBy(learner);
            if (myGroup == null || myGroup.isNull()) {
                if (grouping.isRandomGrouping()) {
                    try {
                        this.lessonService.performGrouping(lessonId, groupActivity, learner);
                    }
                    catch (LessonServiceException e) {
                        MonitoringService.log.error((Object)("Force complete failed. Learner " + learner + " lessonId " + lessonId + " processing activity " + activity), (Throwable)e);
                        stopReason = this.messageService.getMessage("force.complete.stop.message.grouping.error", new Object[]{activity.getTitle()});
                    }
                    this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                    if (MonitoringService.log.isDebugEnabled()) {
                        MonitoringService.log.debug((Object)("Grouping activity [" + activity.getActivityId() + "] is completed."));
                    }
                } else {
                    stopReason = this.messageService.getMessage("force.complete.stop.message.grouping", new Object[]{activity.getTitle()});
                }
            } else {
                this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                if (MonitoringService.log.isDebugEnabled()) {
                    MonitoringService.log.debug((Object)("Grouping activity [" + activity.getActivityId() + "] is completed."));
                }
            }
        } else if (activity.isGateActivity()) {
            gate = (GateActivity)activity;
            if (this.learnerService.knockGate(gate, learner, false)) {
                this.learnerService.completeActivity(learner.getUserId(), activity, lessonId);
                if (MonitoringService.log.isDebugEnabled()) {
                    MonitoringService.log.debug((Object)("Gate activity [" + gate.getActivityId() + "] is completed."));
                }
            } else {
                stopReason = this.messageService.getMessage("force.complete.stop.message.gate", new Object[]{activity.getTitle()});
            }
        } else if (activity.isToolActivity()) {
            toolActivity = (ToolActivity)activity;
            try {
                toolSession = this.lamsCoreToolService.getToolSessionByActivity(learner, toolActivity);
                if (toolSession == null) {
                    this.learnerService.createToolSessionsIfNecessary((Activity)toolActivity, progress);
                    toolSession = this.lamsCoreToolService.getToolSessionByActivity(learner, toolActivity);
                }
                this.learnerService.completeToolSession(toolSession.getToolSessionId(), new Long(learner.getUserId().longValue()));
                if (!MonitoringService.log.isDebugEnabled()) ** GOTO lbl62
                MonitoringService.log.debug((Object)("Tool activity [" + activity.getActivityId() + "] is completed."));
            }
            catch (LamsToolServiceException e) {
                throw new MonitoringServiceException(e);
            }
        } else if (activity.isComplexActivity()) {
            complexActivity = (ComplexActivity)activity;
            allActivities = complexActivity.getActivities();
            iter = allActivities.iterator();
            while (stopReason == null && iter.hasNext()) {
                act = (Activity)iter.next();
                stopReason = this.forceCompleteActivity(learner, lessonId, progress, act, stopActivity, touchedActivityIds);
            }
            MonitoringService.log.debug((Object)("Complex activity [" + activity.getActivityId() + "] is completed."));
        }
lbl62:
        // 10 sources

        if (stopReason == null) {
            learnerProgress = this.learnerService.getProgress(learner.getUserId(), lessonId);
            stopReason = learnerProgress.getCompletedActivities().contains(stopActivity) != false ? this.messageService.getMessage("force.complete.stop.message.completed.to.activity", new Object[]{activity.getTitle()}) : ((nextActivity = learnerProgress.getNextActivity()) == null || nextActivity.getActivityId().equals(activity.getActivityId()) != false ? this.messageService.getMessage("force.complete.stop.message.completed.to.end") : (touchedActivityIds.contains(nextActivity.getActivityId()) != false ? null : this.forceCompleteActivity(learner, lessonId, learnerProgress, nextActivity, stopActivity, touchedActivityIds)));
        }
        return stopReason;
    }

    @Override
    public String getLessonDetails(Long lessonID, Integer userID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonID));
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson deatils");
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        LessonDetailsDTO dto = this.lessonService.getLessonDetails(lessonID);
        Locale userLocale = new Locale(user.getLocale().getLanguageIsoCode(), user.getLocale().getCountryIsoCode());
        if (dto.getStartDateTime() != null) {
            dto.setStartDateTimeStr(DateFormat.getDateTimeInstance(0, 0, userLocale).format(dto.getStartDateTime()));
        }
        if (dto.getScheduleStartDate() != null) {
            dto.setScheduleStartDateStr(DateFormat.getDateTimeInstance(0, 0, userLocale).format(dto.getScheduleStartDate()));
        }
        FlashMessage flashMessage = dto != null ? new FlashMessage("getLessonDetails", (Object)dto) : new FlashMessage("getLessonDetails", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLessonLearners(Long lessonID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson learners");
        Vector<UserFlashDTO> lessonLearners = new Vector<UserFlashDTO>();
        if (lesson != null) {
            for (User user : lesson.getLessonClass().getLearners()) {
                lessonLearners.add(user.getUserFlashDTO());
            }
            flashMessage = new FlashMessage("getLessonLearners", lessonLearners);
        } else {
            flashMessage = new FlashMessage("getLessonLearners", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLessonStaff(Long lessonID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get lesson staff");
        Vector<UserFlashDTO> lessonStaff = new Vector<UserFlashDTO>();
        if (lesson != null) {
            for (User user : lesson.getLessonClass().getStaffGroup().getUsers()) {
                lessonStaff.add(user.getUserFlashDTO());
            }
            flashMessage = new FlashMessage("getLessonStaff", lessonStaff);
        } else {
            flashMessage = new FlashMessage("getLessonStaff", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLearningDesignDetails(Long lessonID) throws IOException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        return this.authoringService.getLearningDesignDetails(lesson.getLearningDesign().getLearningDesignId());
    }

    @Override
    public String getAllLearnersProgress(Long lessonID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get all learners progress");
        Vector<LearnerProgressDTO> progressData = new Vector<LearnerProgressDTO>();
        if (lesson != null) {
            for (LearnerProgress learnerProgress : lesson.getLearnerProgresses()) {
                progressData.add(learnerProgress.getLearnerProgressData());
            }
            flashMessage = new FlashMessage("getAllLearnersProgress", progressData);
        } else {
            flashMessage = new FlashMessage("getAllLearnersProgress", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public Activity getActivityById(Long activityId) {
        return this.activityDAO.getActivityByActivityId(activityId);
    }

    @Override
    public GroupingActivity getGroupingActivityById(Long activityID) {
        Activity activity = this.getActivityById(activityID);
        if (activity == null) {
            String error = "Activity missing. ActivityID was " + activityID;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        if (!activity.isGroupingActivity()) {
            String error = "Activity should have been GroupingActivity but was a different kind of activity. " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        return (GroupingActivity)activity;
    }

    @Override
    public String getAllContributeActivities(Long lessonID) throws IOException, LearningDesignProcessorException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            ContributeActivitiesProcessor processor = new ContributeActivitiesProcessor(lesson.getLearningDesign(), lessonID, this.activityDAO, this.lamsCoreToolService);
            processor.parseLearningDesign();
            Vector<ContributeActivityDTO> activities = processor.getMainActivityList();
            flashMessage = new FlashMessage("getAllContributeActivities", activities);
        } else {
            flashMessage = new FlashMessage("getAllContributeActivities", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLearnerActivityURL(Long lessonID, Long activityID, Integer learnerUserID, Integer requestingUserId) throws IOException, LamsToolServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(requestingUserId, lesson, "get monitoring learner progress url");
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerUserID);
        if (activity == null || learner == null) {
            log.error((Object)("getLearnerActivityURL activity or user missing. Activity ID " + activityID + " activity " + activity + " userID " + learnerUserID + " user " + learner));
        } else if (activity.isToolActivity() || activity.isSystemToolActivity()) {
            return this.lamsCoreToolService.getToolLearnerProgressURL(lessonID, activity, learner);
        }
        return null;
    }

    @Override
    public String getActivityDefineLaterURL(Long lessonID, Long activityID, Integer userID) throws IOException, LamsToolServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get activity define later url");
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        if (activity == null) {
            log.error((Object)("getActivityMonitorURL activity missing. Activity ID " + activityID + " activity " + activity));
        } else if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            return this.lamsCoreToolService.getToolDefineLaterURL(toolActivity);
        }
        return null;
    }

    @Override
    public String getActivityMonitorURL(Long lessonID, Long activityID, String contentFolderID, Integer userID) throws IOException, LamsToolServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        this.checkOwnerOrStaffMember(userID, lesson, "get activity define later url");
        Activity activity = this.activityDAO.getActivityByActivityId(activityID);
        if (activity == null) {
            log.error((Object)("getActivityMonitorURL activity missing. Activity ID " + activityID + " activity " + activity));
        } else if (activity.isToolActivity() || activity.isSystemToolActivity()) {
            return this.lamsCoreToolService.getToolMonitoringURL(lessonID, activity) + "&contentFolderID=" + contentFolderID;
        }
        return null;
    }

    @Override
    public String moveLesson(Long lessonID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)targetWorkspaceFolderID);
                if (workspaceFolder != null) {
                    LearningDesign learningDesign = lesson.getLearningDesign();
                    learningDesign.setWorkspaceFolder(workspaceFolder);
                    this.learningDesignDAO.update((Object)learningDesign);
                    flashMessage = new FlashMessage("moveLesson", (Object)targetWorkspaceFolderID);
                } else {
                    flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveLesson", (Integer)targetWorkspaceFolderID);
                }
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"moveLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("moveLesson", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String renameLesson(Long lessonID, String newName, Integer userID) throws IOException {
        FlashMessage flashMessage;
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson != null) {
            if (lesson.getUser().getUserId().equals(userID)) {
                lesson.setLessonName(newName);
                this.lessonDAO.updateLesson(lesson);
                flashMessage = new FlashMessage("renameLesson", (Object)newName);
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"renameLesson", (Integer)userID);
            }
        } else {
            flashMessage = new FlashMessage("renameLesson", (Object)this.messageService.getMessage("NO.SUCH.LESSON", new Object[]{lessonID}), 1);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String checkGateStatus(Long activityID, Long lessonID) throws IOException {
        FlashMessage flashMessage;
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(activityID);
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (gate == null || lesson == null) {
            flashMessage = new FlashMessage("checkGateStatus", (Object)this.messageService.getMessage("INVALID.ACTIVITYID.LESSONID", new Object[]{activityID, lessonID}), 1);
        } else {
            Hashtable table = new Hashtable();
            table = this.createGateStatusInfo(activityID, gate);
            flashMessage = new FlashMessage("checkGateStatus", (Object)table);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String releaseGate(Long activityID) throws IOException {
        FlashMessage flashMessage;
        GateActivity gate = (GateActivity)this.activityDAO.getActivityByActivityId(activityID);
        if (gate == null) {
            flashMessage = new FlashMessage("releaseGate", (Object)this.messageService.getMessage("INVALID.ACTIVITYID", new Object[]{activityID}), 1);
        } else {
            gate = this.openGate(activityID);
            flashMessage = new FlashMessage("releaseGate", (Object)gate.getGateOpen());
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public void performChosenGrouping(GroupingActivity groupingActivity, List groups) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (!grouping.isChosenGrouping()) {
            log.error((Object)("GroupingActivity [" + groupingActivity.getActivityId() + "] does not have chosen grouping."));
            throw new MonitoringServiceException("GroupingActivity [" + groupingActivity.getActivityId() + "] is not chosen grouping.");
        }
        try {
            Iterator<Object> iter = groups.iterator();
            TreeMap<Long, Hashtable> sortedMap = new TreeMap<Long, Hashtable>(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Long)arg0).compareTo((Long)arg1);
                }
            });
            while (iter.hasNext()) {
                Hashtable group = (Hashtable)iter.next();
                Long orderId = WDDXProcessor.convertToLong((Hashtable)group, (String)"orderID");
                sortedMap.put(orderId, group);
            }
            iter = sortedMap.values().iterator();
            int orderId = 0;
            while (iter.hasNext()) {
                Hashtable group = (Hashtable)iter.next();
                List learnerIdList = (List)group.get("learners");
                String groupName = WDDXProcessor.convertToString((Hashtable)group, (String)"groupName");
                ArrayList<User> learners = new ArrayList<User>();
                for (int idx = 0; idx < learnerIdList.size(); ++idx) {
                    User user = (User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(((Double)learnerIdList.get(idx)).intValue()));
                    learners.add(user);
                }
                log.debug((Object)("Performing grouping for " + groupName + "..."));
                this.lessonService.performGrouping(groupingActivity, groupName, learners);
                log.debug((Object)("Finish grouping for " + groupName));
                ++orderId;
            }
            log.debug((Object)("Persist grouping for [" + grouping.getGroupingId() + "]..."));
            this.groupingDAO.update((Object)grouping);
            log.debug((Object)("Persist grouping for [" + grouping.getGroupingId() + "] success."));
        }
        catch (WDDXProcessorConversionException e) {
            throw new MonitoringServiceException("Perform chosen grouping occurs error when parsing WDDX package:" + e.getMessage());
        }
    }

    private LessonClass createLessonClass(Organisation organisation, String learnerGroupName, List<User> organizationUsers, String staffGroupName, List<User> staffs, Lesson newLesson) {
        LessonClass newLessonClass = this.createNewLessonClass(newLesson.getLearningDesign());
        this.lessonClassDAO.saveLessonClass(newLessonClass);
        newLessonClass.setStaffGroup(Group.createStaffGroup((Grouping)newLessonClass, (String)staffGroupName, new HashSet<User>(staffs)));
        newLessonClass.getGroups().add(Group.createLearnerGroup((Grouping)newLessonClass, (String)learnerGroupName, new HashSet<User>(organizationUsers)));
        this.lessonClassDAO.updateLessonClass(newLessonClass);
        return newLessonClass;
    }

    private Lesson createNewLesson(String lessonName, String lessonDescription, User user, Boolean learnerExportAvailable, LearningDesign copiedLearningDesign) {
        Lesson newLesson = Lesson.createNewLessonWithoutClass((String)lessonName, (String)lessonDescription, (User)user, (Boolean)learnerExportAvailable, (LearningDesign)copiedLearningDesign);
        this.lessonDAO.saveLesson(newLesson);
        return newLesson;
    }

    private LessonClass createNewLessonClass(LearningDesign copiedLearningDesign) {
        HashSet activities = new HashSet(copiedLearningDesign.getActivities());
        LessonClass newLessonClass = new LessonClass(null, new HashSet(), activities, null, null);
        return newLessonClass;
    }

    private void initToolSessionIfSuitable(ToolActivity activity, Lesson lesson) {
        if (!activity.getApplyGrouping().booleanValue()) {
            activity.setToolSessions(new HashSet());
            try {
                Set newToolSessions = this.lamsCoreToolService.createToolSessions(lesson.getAllLearners(), activity, lesson);
                for (ToolSession toolSession : newToolSessions) {
                    this.lamsCoreToolService.notifyToolsToCreateSession(toolSession, activity);
                    activity.getToolSessions().add(toolSession);
                }
            }
            catch (LamsToolServiceException e) {
                String error = "Unable to initialise tool session. Fail to call tool services. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
            catch (ToolException e) {
                String error = "Unable to initialise tool session. Tool encountered an error. Error was " + e.getMessage();
                log.error((Object)error, (Throwable)e);
                throw new MonitoringServiceException(error, e);
            }
        }
    }

    private void runGateScheduler(ScheduleGateActivity scheduleGate, Date lessonStartTime, String lessonName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running scheduler for gate " + scheduleGate.getActivityId() + "..."));
        }
        JobDetail openScheduleGateJob = this.getOpenScheduleGateJob();
        JobDetail closeScheduleGateJob = this.getCloseScheduleGateJob();
        openScheduleGateJob.setName("openGate:" + scheduleGate.getActivityId());
        openScheduleGateJob.setDescription(scheduleGate.getTitle() + ":" + lessonName);
        openScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        closeScheduleGateJob.setName("closeGate:" + scheduleGate.getActivityId());
        closeScheduleGateJob.getJobDataMap().put((Object)"gateId", (Object)scheduleGate.getActivityId());
        closeScheduleGateJob.setDescription(scheduleGate.getTitle() + ":" + lessonName);
        SimpleTrigger openGateTrigger = new SimpleTrigger("openGateTrigger:" + scheduleGate.getActivityId(), "DEFAULT", scheduleGate.getLessonGateOpenTime(lessonStartTime));
        SimpleTrigger closeGateTrigger = new SimpleTrigger("closeGateTrigger:" + scheduleGate.getActivityId(), "DEFAULT", scheduleGate.getLessonGateCloseTime(lessonStartTime));
        try {
            if (scheduleGate.getGateStartTimeOffset() == null && scheduleGate.getGateEndTimeOffset() == null || scheduleGate.getGateStartTimeOffset() != null && scheduleGate.getGateEndTimeOffset() == null) {
                this.scheduler.scheduleJob(openScheduleGateJob, (Trigger)openGateTrigger);
            } else if (openGateTrigger.getStartTime().before(closeGateTrigger.getStartTime())) {
                this.scheduler.scheduleJob(openScheduleGateJob, (Trigger)openGateTrigger);
                this.scheduler.scheduleJob(closeScheduleGateJob, (Trigger)closeGateTrigger);
            }
        }
        catch (SchedulerException e) {
            throw new MonitoringServiceException("Error occurred at [runGateScheduler]- fail to start scheduling", e);
        }
        this.activityDAO.update((Object)scheduleGate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler for Gate " + scheduleGate.getActivityId() + " started..."));
        }
    }

    private JobDetail getOpenScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("openScheduleGateJob");
    }

    private JobDetail getStartScheduleLessonJob() {
        return (JobDetail)this.applicationContext.getBean("startScheduleLessonJob");
    }

    private JobDetail getFinishScheduleLessonJob() {
        return (JobDetail)this.applicationContext.getBean("finishScheduleLessonJob");
    }

    private JobDetail getCloseScheduleGateJob() {
        return (JobDetail)this.applicationContext.getBean("closeScheduleGateJob");
    }

    private Hashtable createGateStatusInfo(Long activityID, GateActivity gate) {
        Hashtable<String, Serializable> table = new Hashtable<String, Serializable>();
        table.put("activityID", activityID);
        table.put("activityTypeID", gate.getActivityTypeId());
        table.put("gateOpen", gate.getGateOpen());
        table.put("activityLevelID", gate.getGateActivityLevelId());
        table.put("learnersWaiting", new Integer(gate.getWaitingLearners().size()));
        if (gate.isScheduleGate()) {
            ScheduleGateActivity scheduleGate = (ScheduleGateActivity)gate;
            table.put("gateStartTime", scheduleGate.getGateStartDateTime());
            table.put("gateEndTime", scheduleGate.getGateEndDateTime());
        }
        return table;
    }

    @Override
    public Lesson createPreviewClassForLesson(int userID, long lessonID) throws UserAccessDeniedException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)Integer.valueOf(userID));
        if (user == null) {
            throw new UserAccessDeniedException("User " + userID + " not found");
        }
        LinkedList<User> learners = new LinkedList<User>();
        learners.add(user);
        LinkedList<User> staffs = new LinkedList<User>();
        staffs.add(user);
        return this.createLessonClassForLesson(lessonID, null, "Learner Group", learners, "Staff Group", staffs, userID);
    }

    @Override
    public void deletePreviewLesson(long lessonID) {
        Lesson lesson = this.lessonDAO.getLesson(new Long(lessonID));
        this.deletePreviewLesson(lesson);
    }

    private void deletePreviewLesson(Lesson lesson) {
        if (lesson != null) {
            if (lesson.isPreviewLesson()) {
                List toolSessions = this.lamsCoreToolService.getToolSessionsByLesson(lesson);
                if (toolSessions != null && toolSessions.size() > 0) {
                    for (ToolSession toolSession : toolSessions) {
                        this.lamsCoreToolService.deleteToolSession(toolSession);
                    }
                } else {
                    log.debug((Object)"deletePreviewLesson: Removing tool sessions - none exist");
                }
                LearningDesign ld = lesson.getLearningDesign();
                this.lessonDAO.deleteLesson(lesson);
                this.authoringService.deleteLearningDesign(ld);
            } else {
                log.warn((Object)("Unable to delete lesson as lesson is not a preview lesson. Learning design copy type was " + lesson.getLearningDesign().getCopyTypeID()));
            }
        }
    }

    @Override
    public int deleteAllOldPreviewLessons() {
        int numDays = Configuration.getAsInt((String)ConfigurationKeys.PREVIEW_CLEANUP_NUM_DAYS);
        if (numDays <= 0) {
            log.error((Object)("deleteAllOldPreviewSessions: number of days invalid (" + numDays + "). See configuration file (option " + ConfigurationKeys.PREVIEW_CLEANUP_NUM_DAYS + " Unable to delete any preview lessons"));
            return 0;
        }
        int numDeleted = 0;
        long newestDateToKeep = System.currentTimeMillis() - (long)numDays * 86400000L;
        Date date = new Date(newestDateToKeep);
        log.info((Object)("Deleting all preview lessons before " + date.toString() + " (server time) (" + newestDateToKeep + ")"));
        List sessions = this.lessonDAO.getPreviewLessonsBeforeDate(date);
        for (Lesson lesson : sessions) {
            try {
                this.deletePreviewLesson(lesson);
                ++numDeleted;
            }
            catch (Exception e) {
                log.error((Object)("Unable to delete lesson " + lesson.getLessonId() + " due to exception."), (Throwable)e);
            }
        }
        return numDeleted;
    }

    @Override
    public SortedSet<User> getClassMembersNotGrouped(Long lessonID, Long activityID) {
        GroupingActivity activity = this.getGroupingActivityById(activityID);
        Grouping grouping = activity.getCreateGrouping();
        if (grouping == null) {
            String error = "Grouping activity missing grouping. Activity was " + activity + " Grouping was " + grouping;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Lesson lesson = this.lessonDAO.getLesson(lessonID);
        if (lesson == null) {
            String error = "Lesson missing. LessonID was " + lessonID + " Activity was " + activity;
            log.error((Object)error);
            throw new MonitoringServiceException(error);
        }
        Set learners = lesson.getAllLearners();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClassMembersNotGrouped: Lesson " + lessonID + " has " + learners.size() + " learners."));
        }
        for (Group group : grouping.getGroups()) {
            learners.removeAll(group.getUsers());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getClassMembersNotGrouped: Group " + group.getGroupId() + " has " + group.getUsers().size() + " members."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClassMembersNotGrouped: Lesson " + lessonID + " has " + learners.size() + " learners."));
        }
        TreeSet<User> sortedUsers = new TreeSet<User>((Comparator<User>)new LastNameAlphabeticComparator());
        sortedUsers.addAll(learners);
        return sortedUsers;
    }

    @Override
    public void addGroup(Long activityID, String name) throws LessonServiceException {
        GroupingActivity groupingActivity = this.getGroupingActivityById(activityID);
        this.lessonService.createGroup(groupingActivity, name);
    }

    @Override
    public void removeGroup(Long activityID, Long groupId) throws LessonServiceException {
        GroupingActivity groupingActivity = this.getGroupingActivityById(activityID);
        this.lessonService.removeGroup(groupingActivity, groupId);
    }

    @Override
    public void addUsersToGroup(Long activityID, Long groupId, String[] learnerIDs) throws LessonServiceException {
        GroupingActivity groupingActivity = this.getGroupingActivityById(activityID);
        ArrayList<User> learners = this.createUserList(activityID, learnerIDs, "add");
        this.lessonService.performGrouping(groupingActivity, groupId, learners);
    }

    private ArrayList<User> createUserList(Long activityID, String[] learnerIDs, String addRemoveText) {
        ArrayList<User> learners = new ArrayList<User>();
        for (String strlearnerID : learnerIDs) {
            boolean added = false;
            try {
                Integer learnerID = new Integer(Integer.parseInt(strlearnerID));
                User learner = (User)this.baseDAO.find(User.class, (Serializable)learnerID);
                if (learner != null) {
                    learners.add(learner);
                    added = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (added) continue;
            log.warn((Object)("Unable to " + addRemoveText + " learner " + strlearnerID + " for group in grouping activity " + activityID + " as learner cannot be found."));
        }
        return learners;
    }

    @Override
    public void removeUsersFromGroup(Long activityID, Long groupId, String[] learnerIDs) throws LessonServiceException {
        GroupingActivity groupingActivity = this.getGroupingActivityById(activityID);
        ArrayList<User> learners = this.createUserList(activityID, learnerIDs, "remove");
        this.lessonService.removeLearnersFromGroup(groupingActivity, groupId, learners);
    }
}

