/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.AddableImplicitCollectionMapper;
import com.thoughtworks.xstream.core.DefaultClassMapper;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class XStream {
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private MarshallingStrategy marshallingStrategy;
    private ClassMapper classMapper;
    private DefaultConverterLookup converterLookup;
    private JVM jvm = new JVM();
    private AddableImplicitCollectionMapper implicitCollectionMapper = new AddableImplicitCollectionMapper();
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_REFERENCES = 1003;
    static /* synthetic */ Class class$java$lang$Object;

    public XStream() {
        this(null, new DefaultClassMapper(), new XppDriver());
    }

    public XStream(Converter defaultConverter) {
        this(null, new DefaultClassMapper(), new XppDriver(), "class", defaultConverter);
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(null, new DefaultClassMapper(), hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, new DefaultClassMapper(), new XppDriver());
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, new DefaultClassMapper(), hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver) {
        this(reflectionProvider, classMapper, driver, "class");
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver, String classAttributeIdentifier) {
        this.jvm = new JVM();
        if (reflectionProvider == null) {
            reflectionProvider = this.jvm.bestReflectionProvider();
        }
        this.classMapper = classMapper;
        this.hierarchicalStreamDriver = driver;
        this.setMode(1003);
        this.converterLookup = new DefaultConverterLookup(this.jvm, reflectionProvider, this.implicitCollectionMapper, classMapper, classAttributeIdentifier);
        this.converterLookup.setupDefaults();
    }

    public XStream(ReflectionProvider reflectionProvider, ClassMapper classMapper, HierarchicalStreamDriver driver, String classAttributeIdentifier, Converter defaultConverter) {
        this.jvm = new JVM();
        if (reflectionProvider == null) {
            reflectionProvider = this.jvm.bestReflectionProvider();
        }
        this.classMapper = classMapper;
        this.hierarchicalStreamDriver = driver;
        this.setMode(1003);
        this.converterLookup = new DefaultConverterLookup(this.jvm, reflectionProvider, defaultConverter, classMapper, classAttributeIdentifier);
        this.converterLookup.setupDefaults();
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object obj) {
        StringWriter stringWriter = new StringWriter();
        PrettyPrintWriter writer = new PrettyPrintWriter(stringWriter);
        this.marshal(obj, writer);
        return ((Object)stringWriter).toString();
    }

    public void toXML(Object obj, Writer writer) {
        this.marshal(obj, new PrettyPrintWriter(writer));
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer) {
        this.marshal(obj, writer, null);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(writer, obj, this.converterLookup, this.classMapper, dataHolder);
    }

    public Object fromXML(String xml) {
        return this.fromXML(new StringReader(xml));
    }

    public Object fromXML(Reader xml) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), null);
    }

    public Object fromXML(String xml, Object root) {
        return this.fromXML(new StringReader(xml), root);
    }

    public Object fromXML(Reader xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object unmarshal(HierarchicalStreamReader reader) {
        return this.unmarshal(reader, null, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root) {
        return this.unmarshal(reader, root, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.converterLookup, this.classMapper);
    }

    public void alias(String elementName, Class type) {
        this.converterLookup.alias(elementName, type, type);
    }

    public void alias(String elementName, Class type, Class defaultImplementation) {
        this.converterLookup.alias(elementName, type, defaultImplementation);
    }

    public void changeDefaultConverter(Converter defaultConverter) {
        this.converterLookup.changeDefaultConverter(defaultConverter);
    }

    public void registerConverter(Converter converter) {
        this.converterLookup.registerConverter(converter);
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
    }

    public void addDefaultCollection(Class ownerType, String fieldName) {
        this.addImplicitCollection(ownerType, fieldName);
    }

    public void addImplicitCollection(Class ownerType, String fieldName) {
        this.implicitCollectionMapper.add(ownerType, fieldName, null, class$java$lang$Object == null ? (class$java$lang$Object = XStream.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, Class itemType) {
        this.implicitCollectionMapper.add(ownerType, fieldName, null, itemType);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, String itemFieldName, Class itemType) {
        this.implicitCollectionMapper.add(ownerType, fieldName, itemFieldName, itemType);
    }

    public DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(new PrettyPrintWriter(writer), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer) throws IOException {
        return this.createObjectOutputStream(writer, "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(new PrettyPrintWriter(writer), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(final HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
        writer.startNode(rootNodeName);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                XStream.this.marshal(object, writer);
            }

            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void close() {
                writer.endNode();
            }
        });
    }

    public ObjectInputStream createObjectInputStream(Reader xmlReader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(xmlReader));
    }

    public ObjectInputStream createObjectInputStream(final HierarchicalStreamReader reader) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() throws EOFException {
                if (!reader.hasMoreChildren()) {
                    throw new EOFException();
                }
                reader.moveDown();
                Object result = XStream.this.unmarshal(reader);
                reader.moveUp();
                return result;
            }

            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            public void close() throws IOException {
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

