/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.alias.ImplicitCollectionMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.thoughtworks.xstream.converters.extended.ColorConverter;
import com.thoughtworks.xstream.converters.extended.CurrencyConverter;
import com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.FontConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.RegexPatternConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.converters.extended.StackTraceElementConverter;
import com.thoughtworks.xstream.converters.extended.ThrowableConverter;
import com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.JVM;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultConverterLookup
implements ConverterLookup {
    private ArrayList converters = new ArrayList();
    private Converter nullConverter = new NullConverter();
    private HashMap typeToConverterMap = new HashMap();
    private ClassMapper classMapper;
    private String classAttributeIdentifier;
    private Converter defaultConverter;
    private JVM jvm;
    private ReflectionProvider reflectionProvider;
    private transient ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$Null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$reflect$Constructor;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Map$Entry;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    public DefaultConverterLookup(JVM jvm, ReflectionProvider reflectionProvider, ImplicitCollectionMapper implicitCollectionMapper, ClassMapper classMapper, String classAttributeIdentifier) {
        this(jvm, reflectionProvider, new ReflectionConverter(classMapper, classAttributeIdentifier, "defined-in", reflectionProvider, implicitCollectionMapper), classMapper, classAttributeIdentifier);
    }

    public DefaultConverterLookup(JVM jvm, ReflectionProvider reflectionProvider, Converter defaultConverter, ClassMapper classMapper, String classAttributeIdentifier) {
        this.jvm = jvm;
        this.defaultConverter = defaultConverter;
        this.classMapper = classMapper;
        this.classAttributeIdentifier = classAttributeIdentifier;
        this.reflectionProvider = reflectionProvider;
    }

    public Converter defaultConverter() {
        return this.defaultConverter;
    }

    public void changeDefaultConverter(Converter newDefaultConverter) {
        this.defaultConverter = newDefaultConverter;
        this.setupDefaults();
    }

    public Converter lookupConverterForType(Class type) {
        if (type == null) {
            return this.nullConverter;
        }
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        type = this.classMapper.lookupDefaultType(type);
        int size = this.converters.size();
        for (int i = size - 1; i >= 0; --i) {
            Converter converter = (Converter)this.converters.get(i);
            if (!converter.canConvert(type)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        throw new ConversionException("No converter specified for " + type);
    }

    public void registerConverter(Converter converter) {
        this.converters.add(converter);
    }

    public void setupDefaults() {
        this.alias("null", class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = DefaultConverterLookup.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null);
        this.alias("int", class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultConverterLookup.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.alias("float", class$java$lang$Float == null ? (class$java$lang$Float = DefaultConverterLookup.class$("java.lang.Float")) : class$java$lang$Float);
        this.alias("double", class$java$lang$Double == null ? (class$java$lang$Double = DefaultConverterLookup.class$("java.lang.Double")) : class$java$lang$Double);
        this.alias("long", class$java$lang$Long == null ? (class$java$lang$Long = DefaultConverterLookup.class$("java.lang.Long")) : class$java$lang$Long);
        this.alias("short", class$java$lang$Short == null ? (class$java$lang$Short = DefaultConverterLookup.class$("java.lang.Short")) : class$java$lang$Short);
        this.alias("char", class$java$lang$Character == null ? (class$java$lang$Character = DefaultConverterLookup.class$("java.lang.Character")) : class$java$lang$Character);
        this.alias("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultConverterLookup.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.alias("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultConverterLookup.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.alias("number", class$java$lang$Number == null ? (class$java$lang$Number = DefaultConverterLookup.class$("java.lang.Number")) : class$java$lang$Number);
        this.alias("object", class$java$lang$Object == null ? (class$java$lang$Object = DefaultConverterLookup.class$("java.lang.Object")) : class$java$lang$Object);
        this.alias("dynamic-proxy", class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy = DefaultConverterLookup.class$("com.thoughtworks.xstream.alias.ClassMapper$DynamicProxy")) : class$com$thoughtworks$xstream$alias$ClassMapper$DynamicProxy);
        this.alias("big-int", class$java$math$BigInteger == null ? (class$java$math$BigInteger = DefaultConverterLookup.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.alias("big-decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DefaultConverterLookup.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.alias("string-buffer", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = DefaultConverterLookup.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        this.alias("string", class$java$lang$String == null ? (class$java$lang$String = DefaultConverterLookup.class$("java.lang.String")) : class$java$lang$String);
        this.alias("java-class", class$java$lang$Class == null ? (class$java$lang$Class = DefaultConverterLookup.class$("java.lang.Class")) : class$java$lang$Class);
        this.alias("method", class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = DefaultConverterLookup.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
        this.alias("constructor", class$java$lang$reflect$Constructor == null ? (class$java$lang$reflect$Constructor = DefaultConverterLookup.class$("java.lang.reflect.Constructor")) : class$java$lang$reflect$Constructor);
        this.alias("date", class$java$util$Date == null ? (class$java$util$Date = DefaultConverterLookup.class$("java.util.Date")) : class$java$util$Date);
        this.alias("url", class$java$net$URL == null ? (class$java$net$URL = DefaultConverterLookup.class$("java.net.URL")) : class$java$net$URL);
        this.alias("bit-set", class$java$util$BitSet == null ? (class$java$util$BitSet = DefaultConverterLookup.class$("java.util.BitSet")) : class$java$util$BitSet);
        this.alias("map", class$java$util$Map == null ? (class$java$util$Map = DefaultConverterLookup.class$("java.util.Map")) : class$java$util$Map, class$java$util$HashMap == null ? (class$java$util$HashMap = DefaultConverterLookup.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.alias("entry", class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = DefaultConverterLookup.class$("java.util.Map$Entry")) : class$java$util$Map$Entry);
        this.alias("properties", class$java$util$Properties == null ? (class$java$util$Properties = DefaultConverterLookup.class$("java.util.Properties")) : class$java$util$Properties);
        this.alias("list", class$java$util$List == null ? (class$java$util$List = DefaultConverterLookup.class$("java.util.List")) : class$java$util$List, class$java$util$ArrayList == null ? (class$java$util$ArrayList = DefaultConverterLookup.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        this.alias("set", class$java$util$Set == null ? (class$java$util$Set = DefaultConverterLookup.class$("java.util.Set")) : class$java$util$Set, class$java$util$HashSet == null ? (class$java$util$HashSet = DefaultConverterLookup.class$("java.util.HashSet")) : class$java$util$HashSet);
        this.alias("linked-list", class$java$util$LinkedList == null ? (class$java$util$LinkedList = DefaultConverterLookup.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        this.alias("vector", class$java$util$Vector == null ? (class$java$util$Vector = DefaultConverterLookup.class$("java.util.Vector")) : class$java$util$Vector);
        this.alias("tree-map", class$java$util$TreeMap == null ? (class$java$util$TreeMap = DefaultConverterLookup.class$("java.util.TreeMap")) : class$java$util$TreeMap);
        this.alias("tree-set", class$java$util$TreeSet == null ? (class$java$util$TreeSet = DefaultConverterLookup.class$("java.util.TreeSet")) : class$java$util$TreeSet);
        this.alias("hashtable", class$java$util$Hashtable == null ? (class$java$util$Hashtable = DefaultConverterLookup.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        this.alias("awt-color", this.jvm.loadClass("java.awt.Color"));
        this.alias("awt-font", this.jvm.loadClass("java.awt.Font"));
        this.alias("sql-timestamp", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DefaultConverterLookup.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        this.alias("sql-time", class$java$sql$Time == null ? (class$java$sql$Time = DefaultConverterLookup.class$("java.sql.Time")) : class$java$sql$Time);
        this.alias("sql-date", class$java$sql$Date == null ? (class$java$sql$Date = DefaultConverterLookup.class$("java.sql.Date")) : class$java$sql$Date);
        this.alias("file", class$java$io$File == null ? (class$java$io$File = DefaultConverterLookup.class$("java.io.File")) : class$java$io$File);
        this.alias("locale", class$java$util$Locale == null ? (class$java$util$Locale = DefaultConverterLookup.class$("java.util.Locale")) : class$java$util$Locale);
        this.alias("gregorian-calendar", class$java$util$Calendar == null ? (class$java$util$Calendar = DefaultConverterLookup.class$("java.util.Calendar")) : class$java$util$Calendar, class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = DefaultConverterLookup.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar);
        if (JVM.is14()) {
            this.alias("linked-hash-map", this.jvm.loadClass("java.util.LinkedHashMap"));
            this.alias("linked-hash-set", this.jvm.loadClass("java.util.LinkedHashSet"));
        }
        this.registerConverter(this.defaultConverter);
        this.registerConverter(new SerializableConverter(this.classMapper, this.reflectionProvider));
        this.registerConverter(new ExternalizableConverter(this.classMapper));
        this.registerConverter(new IntConverter());
        this.registerConverter(new FloatConverter());
        this.registerConverter(new DoubleConverter());
        this.registerConverter(new LongConverter());
        this.registerConverter(new ShortConverter());
        this.registerConverter(new CharConverter());
        this.registerConverter(new BooleanConverter());
        this.registerConverter(new ByteConverter());
        this.registerConverter(new StringConverter());
        this.registerConverter(new StringBufferConverter());
        this.registerConverter(new DateConverter());
        this.registerConverter(new BitSetConverter());
        this.registerConverter(new URLConverter());
        this.registerConverter(new BigIntegerConverter());
        this.registerConverter(new BigDecimalConverter());
        this.registerConverter(new ArrayConverter(this.classMapper, this.classAttributeIdentifier));
        this.registerConverter(new CharArrayConverter());
        this.registerConverter(new CollectionConverter(this.classMapper, this.classAttributeIdentifier));
        this.registerConverter(new MapConverter(this.classMapper, this.classAttributeIdentifier));
        this.registerConverter(new TreeMapConverter(this.classMapper, this.classAttributeIdentifier));
        this.registerConverter(new TreeSetConverter(this.classMapper, this.classAttributeIdentifier));
        this.registerConverter(new PropertiesConverter());
        this.registerConverter(new EncodedByteArrayConverter());
        this.registerConverter(new FileConverter());
        this.registerConverter(new SqlTimestampConverter());
        this.registerConverter(new SqlTimeConverter());
        this.registerConverter(new SqlDateConverter());
        this.registerConverter(new DynamicProxyConverter(this.classMapper, this.classLoader));
        this.registerConverter(new JavaClassConverter(this.classLoader));
        this.registerConverter(new JavaMethodConverter());
        this.registerConverter(new FontConverter());
        this.registerConverter(new ColorConverter());
        this.registerConverter(new LocaleConverter());
        this.registerConverter(new GregorianCalendarConverter());
        if (JVM.is14()) {
            this.registerConverter(new ThrowableConverter(this.defaultConverter()));
            this.registerConverter(new StackTraceElementConverter());
            this.alias("trace", this.jvm.loadClass("java.lang.StackTraceElement"));
            this.registerConverter(new CurrencyConverter());
            this.alias("currency", this.jvm.loadClass("java.util.Currency"));
            this.registerConverter(new RegexPatternConverter(this.defaultConverter()));
        }
    }

    public void alias(String elementName, Class type, Class defaultImplementation) {
        this.classMapper.alias(elementName, type, defaultImplementation);
    }

    public void alias(String elementName, Class type) {
        this.alias(elementName, type, type);
    }

    public String getClassAttributeIdentifier() {
        return this.classAttributeIdentifier;
    }

    private Object readResolve() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

