/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.security.AccessControlException;

public class JVM {
    private ReflectionProvider reflectionProvider;

    public static boolean is14() {
        float majorJavaVersion = Float.parseFloat(System.getProperty("java.version").substring(0, 3));
        return majorJavaVersion >= 1.4f;
    }

    public static boolean isSun() {
        return System.getProperty("java.vm.vendor").indexOf("Sun") != -1;
    }

    public static boolean isApple() {
        return System.getProperty("java.vm.vendor").indexOf("Apple") != -1;
    }

    public Class loadClass(String name) {
        try {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                if (this.canUseSun14ReflectionProvider()) {
                    String cls = "com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(cls).newInstance();
                } else {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isApple()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }
}

