/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.mc;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.mc.McAppConstants;
import org.lamsfoundation.lams.tool.mc.McApplicationException;
import org.lamsfoundation.lams.tool.mc.McComparator;
import org.lamsfoundation.lams.tool.mc.McGeneralAuthoringDTO;
import org.lamsfoundation.lams.tool.mc.McStringComparator;
import org.lamsfoundation.lams.tool.mc.pojos.McContent;
import org.lamsfoundation.lams.tool.mc.pojos.McOptsContent;
import org.lamsfoundation.lams.tool.mc.pojos.McUploadedFile;
import org.lamsfoundation.lams.tool.mc.service.IMcService;
import org.lamsfoundation.lams.tool.mc.web.McAuthoringForm;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public abstract class McUtils
implements McAppConstants {
    static Logger logger = Logger.getLogger((String)McUtils.class.getName());

    public static String replaceNewLines(String text) {
        logger.debug((Object)("using text: " + text));
        String newText = "";
        if (text != null) {
            newText = text.replaceAll("\n", "<br>");
            logger.debug((Object)("newText: " + newText));
        }
        return newText;
    }

    public static Date getGMTDateTime() {
        Date date = new Date(System.currentTimeMillis());
        logger.debug((Object)("date: " + date));
        return date;
    }

    public static UserDTO getToolUser() {
        HttpSession ss = SessionManager.getSession();
        UserDTO toolUser = (UserDTO)ss.getAttribute("user");
        logger.debug((Object)("retrieving toolUser: " + toolUser));
        return toolUser;
    }

    public static Long getUserId() {
        UserDTO toolUser = McUtils.getToolUser();
        long userId = toolUser.getUserID().longValue();
        logger.debug((Object)("userId: " + userId));
        return new Long(userId);
    }

    public static String getUserName() {
        UserDTO toolUser = McUtils.getToolUser();
        String userName = toolUser.getLogin();
        logger.debug((Object)("userName: " + userName));
        return userName;
    }

    public static String getUserFullName() {
        UserDTO toolUser = McUtils.getToolUser();
        String fullName = toolUser.getFirstName() + " " + toolUser.getLastName();
        logger.debug((Object)("fullName: " + fullName));
        return fullName;
    }

    public static String getFormattedDateString(Date date) {
        logger.debug((Object)("getFormattedDateString: " + DateFormat.getDateTimeInstance(1, 1).format(date)));
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }

    public static Map generateOptionsMap(List listMcOptions) {
        logger.debug((Object)("incoming listMcOptions" + listMcOptions));
        TreeMap<String, String> mapOptionsContent = new TreeMap<String, String>(new McStringComparator());
        Iterator listIterator = listMcOptions.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            McOptsContent mcOptionsContent = (McOptsContent)listIterator.next();
            logger.debug((Object)("mcOptionsContent:" + mcOptionsContent));
            mapOptionsContent.put(mapIndex.toString(), mcOptionsContent.getMcQueOptionText());
            mapIndex = new Long(mapIndex + 1L);
        }
        logger.debug((Object)("generated mcOptionsContent: " + mapOptionsContent));
        return mapOptionsContent;
    }

    public static void configureContentRepository(HttpServletRequest request, IMcService mcService) {
        logger.debug((Object)"attempt configureContentRepository");
        mcService.configureContentRepository();
        logger.debug((Object)"configureContentRepository ran successfully");
    }

    public static long generateId() {
        Random generator = new Random();
        long longId = generator.nextLong();
        if (longId < 0L) {
            longId *= -1L;
        }
        return longId;
    }

    public static int generateIntegerId() {
        Random generator = new Random();
        int intId = generator.nextInt();
        if (intId < 0) {
            intId *= -1;
        }
        return intId;
    }

    public static int getCurrentUserId(HttpServletRequest request) throws McApplicationException {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        logger.debug((Object)(logger + " " + "McUtils" + " Current user is: " + user + " with id: " + user.getUserID()));
        return user.getUserID();
    }

    public static User createSimpleUser(Integer userId) {
        User user = new User();
        user.setUserId(userId);
        return user;
    }

    public static boolean getDefineLaterStatus() {
        return false;
    }

    public static Map convertToMap(List sessionsList, String listType) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(new McComparator());
        logger.debug((Object)("listType: " + listType));
        Iterator listIterator = sessionsList.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            if (listType.equals("String")) {
                String text = (String)listIterator.next();
                map.put(mapIndex.toString(), text);
            } else if (listType.equals("Long")) {
                Long LongValue = (Long)listIterator.next();
                map.put(mapIndex.toString(), LongValue);
            }
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static Map convertToStringMap(List sessionsList, String listType) {
        TreeMap<String, String> map = new TreeMap<String, String>(new McComparator());
        logger.debug((Object)("listType: " + listType));
        Iterator listIterator = sessionsList.iterator();
        Long mapIndex = new Long(1L);
        while (listIterator.hasNext()) {
            if (listType.equals("String")) {
                logger.debug((Object)"listType String");
                String text = (String)listIterator.next();
                map.put(mapIndex.toString(), text);
            } else if (listType.equals("Long")) {
                logger.debug((Object)"listType Long");
                Long LongValue = (Long)listIterator.next();
                map.put(mapIndex.toString(), LongValue.toString());
            }
            mapIndex = new Long(mapIndex + 1L);
        }
        return map;
    }

    public static boolean isContentInUse(McContent mcContent) {
        logger.debug((Object)("is content inuse: " + mcContent.isContentInUse()));
        return mcContent.isContentInUse();
    }

    public static boolean isDefineLater(McContent mcContent) {
        logger.debug((Object)("is define later: " + mcContent.isDefineLater()));
        return mcContent.isDefineLater();
    }

    public static boolean isRunOffline(McContent mcContent) {
        logger.debug((Object)("is run offline: " + mcContent.isRunOffline()));
        return mcContent.isRunOffline();
    }

    public static String getDestination(String sourceMcStarter) {
        logger.debug((Object)("sourceMcStarter: " + sourceMcStarter));
        if (sourceMcStarter != null && !sourceMcStarter.equals("monitoring")) {
            logger.debug((Object)"request is from authoring or define Later url. return to: load");
            return "load";
        }
        if (sourceMcStarter == null) {
            logger.debug((Object)"request is from authoring url. return to: load");
            return "load";
        }
        logger.debug((Object)"request is from monitoring url. return to: loadMonitoringEditActivity");
        return "loadMonitoringEditActivity";
    }

    public static void cleanUpSessionAbsolute(HttpServletRequest request) {
        request.getSession().removeAttribute("lamc11");
        request.getSession().removeAttribute("defaultContentId");
        request.getSession().removeAttribute("error.exception.McApplication");
        request.getSession().removeAttribute("load");
        request.getSession().removeAttribute("load");
        request.getSession().removeAttribute("starter");
        request.getSession().removeAttribute("starter");
        request.getSession().removeAttribute("learningStarter");
        request.getSession().removeAttribute("monitoringStarter");
        request.getSession().removeAttribute("loadLearner");
        request.getSession().removeAttribute("loadMonitoring");
        request.getSession().removeAttribute("individualReport");
        request.getSession().removeAttribute("viewSummary");
        request.getSession().removeAttribute("redoQuestions");
        request.getSession().removeAttribute("singleQuestionAnswers");
        request.getSession().removeAttribute("resultsSummary");
        request.getSession().removeAttribute("errorList");
        request.getSession().removeAttribute("preview");
        request.getSession().removeAttribute("learnerProgress");
        request.getSession().removeAttribute("learnerProgressUserId");
        request.getSession().removeAttribute("authoring");
        request.getSession().removeAttribute("sourceMcStarter");
        request.getSession().removeAttribute("authoringCancelled");
        request.getSession().removeAttribute("defineLaterEditActivity");
        request.getSession().removeAttribute("editOptionsMode");
        request.getSession().removeAttribute("defineLaterInEditMode");
        request.getSession().removeAttribute("isAddQuestion");
        request.getSession().removeAttribute("isRemoveQuestion");
        request.getSession().removeAttribute("sbmtSuccess");
        request.getSession().removeAttribute("mapQuestionsContent");
        request.getSession().removeAttribute("isRemoveContent");
        request.getSession().removeAttribute("isRevisitingUser");
        request.getSession().removeAttribute("user");
        request.getSession().removeAttribute("toolContentUID");
        request.getSession().removeAttribute("toolSessionID");
        request.getSession().removeAttribute("userID");
        request.getSession().removeAttribute("maxQuestionIndex");
        request.getSession().removeAttribute("copyToolContent");
        request.getSession().removeAttribute("removeToolContent");
        request.getSession().removeAttribute("mapOptionsContent");
        request.getSession().removeAttribute("mapDefaultOptionsContent");
        request.getSession().removeAttribute("mapDisabledQuestions");
        request.getSession().removeAttribute("mapGeneralOptionsContent");
        request.getSession().removeAttribute("mapGeneralSelectedOptionsContent");
        request.getSession().removeAttribute("mapStartupGeneralOptionsContent");
        request.getSession().removeAttribute("mapStartupGeneralSelectedOptionsContent");
        request.getSession().removeAttribute("mapStartupGeneralOptionsQueId");
        request.getSession().removeAttribute("questionsWithNoOptions");
        request.getSession().removeAttribute("mapGeneralCheckedOptionsContent");
        request.getSession().removeAttribute("mapLearnerQuestionsContent");
        request.getSession().removeAttribute("mapLearnerCheckedOptionsContent");
        request.getSession().removeAttribute("mapLearnerAssessmentResults");
        request.getSession().removeAttribute("mapLeanerFeedbackIncorrect");
        request.getSession().removeAttribute("mapLeanerFeedbackCorrect");
        request.getSession().removeAttribute("mapQuestionWeights");
        request.getSession().removeAttribute("mapQueAttempts");
        request.getSession().removeAttribute("mapQueCorrectAttempts");
        request.getSession().removeAttribute("mapQueIncorrectAttempts");
        request.getSession().removeAttribute("mapWeights");
        request.getSession().removeAttribute("mapCheckBoxStates");
        request.getSession().removeAttribute("mapSelectedOptions");
        request.getSession().removeAttribute("mapFeedbackIncorrect");
        request.getSession().removeAttribute("mapFeedbackCorrect");
        request.getSession().removeAttribute("selectedQuestion");
        request.getSession().removeAttribute("selectedQuestionIndex");
        request.getSession().removeAttribute("defaultQuestionUid");
        request.getSession().removeAttribute("title");
        request.getSession().removeAttribute("instructions");
        request.getSession().removeAttribute("creationDate");
        request.getSession().removeAttribute("defineLater");
        request.getSession().removeAttribute("richTextFeedbackCorrect");
        request.getSession().removeAttribute("retries");
        request.getSession().removeAttribute("ON");
        request.getSession().removeAttribute("OFF");
        request.getSession().removeAttribute("richTextFeedbackInCorrect");
        request.getSession().removeAttribute("richTextOfflineInstructions");
        request.getSession().removeAttribute("passMark");
        request.getSession().removeAttribute("viewAnswers");
        request.getSession().removeAttribute("showAuthoringTabs");
        request.getSession().removeAttribute("richTextOnlineInstructions");
        request.getSession().removeAttribute("richTextReportTitle");
        request.getSession().removeAttribute("richTextTitle");
        request.getSession().removeAttribute("richTextInstructions");
        request.getSession().removeAttribute("<p>&nbsp;</p>");
        request.getSession().removeAttribute("submitOfflineFile");
        request.getSession().removeAttribute("submitOnlineFile");
        request.getSession().removeAttribute("listUploadedOfflineFileNames");
        request.getSession().removeAttribute("listUploadedOnlineFileNames");
        request.getSession().removeAttribute("listOfflineFilesMetadata");
        request.getSession().removeAttribute("listOnlineFilesMetadata");
        request.getSession().removeAttribute("countSessionComplete");
        request.getSession().removeAttribute("countAllUsers");
        request.getSession().removeAttribute("countMaxAttempt");
        request.getSession().removeAttribute("topMark");
        request.getSession().removeAttribute("lowestMark");
        request.getSession().removeAttribute("averageMark");
        request.getSession().removeAttribute("activeModule");
        request.getSession().removeAttribute("NOT_ATTEMPTED");
        request.getSession().removeAttribute("INCOMPLETE");
        request.getSession().removeAttribute("COMPLETED");
        request.getSession().removeAttribute("mapToolSessions");
        request.getSession().removeAttribute(MAX_TOOL_SESSION_COUNT.toString());
        request.getSession().removeAttribute("isToolSessionChanged");
        request.getSession().removeAttribute("addNewQuestion");
        request.getSession().removeAttribute("false");
        request.getSession().removeAttribute("removeQuestion");
        request.getSession().removeAttribute("removeAllContent");
        request.getSession().removeAttribute("submitAllContent");
        request.getSession().removeAttribute("submitTabDone");
        request.getSession().removeAttribute("mapQuestionContentLearner");
        request.getSession().removeAttribute("currentQuestionIndex");
        request.getSession().removeAttribute("totalQuestionCount");
        request.getSession().removeAttribute("learnerMark");
        request.getSession().removeAttribute("learnerBestMark");
        request.getSession().removeAttribute("learnerLastAttemptOrder");
        request.getSession().removeAttribute("learnerMarkAtLeast");
        request.getSession().removeAttribute("mapAnswers");
        request.getSession().removeAttribute("currentAnswer");
        request.getSession().removeAttribute("userFeedback");
        request.getSession().removeAttribute("reportTitleLearner");
        request.getSession().removeAttribute("totalCountReached");
        request.getSession().removeAttribute("isToolActivityOffline");
        request.getSession().removeAttribute("isUsernameVisible");
        request.getSession().removeAttribute("isContentInUse");
        request.getSession().removeAttribute("isRetries");
        request.getSession().removeAttribute("isShowFeedback");
        request.getSession().removeAttribute("isShowLearnersReport");
        request.getSession().removeAttribute("isAllSessionsCompleted");
        request.getSession().removeAttribute("checkAllSessionsCompleted");
        request.getSession().removeAttribute("fromToolContentId");
        request.getSession().removeAttribute("toToolContentId");
        request.getSession().removeAttribute("learnerReport");
        request.getSession().removeAttribute("mapUserResponses");
        request.getSession().removeAttribute("mapMainReport");
        request.getSession().removeAttribute("mapStats");
        request.getSession().removeAttribute("reportTitleMonitor");
        request.getSession().removeAttribute("userId");
        request.getSession().removeAttribute("monitoringReport");
        request.getSession().removeAttribute("monitoringError");
        request.getSession().removeAttribute("mapMonitoringQuestions");
        request.getSession().removeAttribute("summaryToolSessions");
        request.getSession().removeAttribute("monitoredContentId");
        request.getSession().removeAttribute("editActivityEditMode");
        request.getSession().removeAttribute("formIndex");
        request.getSession().removeAttribute("selectionCase");
        request.getSession().removeAttribute("listMonitoredAnswersContainerDto");
        request.getSession().removeAttribute("questionListingMode");
        request.getSession().removeAttribute("questionListingModeSequential");
        request.getSession().removeAttribute("questionListingModeCombined");
        request.getSession().removeAttribute("previewOnly");
        request.getSession().removeAttribute("timeZone");
        request.getSession().removeAttribute("mode");
        request.getSession().removeAttribute("learningMode");
        request.getSession().removeAttribute("exportUserId");
        request.getSession().removeAttribute("mapIncorrectFeedback");
        request.getSession().removeAttribute("mapCorrectFeedback");
        request.getSession().removeAttribute("mapIncorrectFeedbackLearner");
        request.getSession().removeAttribute("mapCorrectFeedbackLearner");
        request.getSession().removeAttribute("activityTitle");
        request.getSession().removeAttribute("activityInstructions");
        request.getSession().removeAttribute("summaryToolSessionsId");
        logger.debug((Object)"completely cleaned the session.");
    }

    public static String getDestination(String sourceMcStarter, String requestedModule) {
        logger.debug((Object)("sourceMcStarter: " + sourceMcStarter + " and requestedModule:" + requestedModule));
        if (requestedModule.equals("defineLater")) {
            logger.debug((Object)"request is from define Later url. return to: loadViewOnly");
            return "loadViewOnly";
        }
        if (requestedModule.equals("authoring")) {
            logger.debug((Object)"request is from authoring url. return to: load");
            return "load";
        }
        logger.debug((Object)"request is from an unknown source. return null");
        return null;
    }

    public static void populateAuthoringDTO(HttpServletRequest request, McContent defaultMcContent, McGeneralAuthoringDTO mcGeneralAuthoringDTO) {
        mcGeneralAuthoringDTO.setActivityTitle(defaultMcContent.getTitle());
        mcGeneralAuthoringDTO.setActivityInstructions(defaultMcContent.getInstructions());
        mcGeneralAuthoringDTO.setOnlineInstructions(defaultMcContent.getOnlineInstructions());
        mcGeneralAuthoringDTO.setOfflineInstructions(defaultMcContent.getOfflineInstructions());
    }

    public static void setDefineLater(HttpServletRequest request, boolean value, String strToolContentID, IMcService mcService) {
        logger.debug((Object)("mcService: " + mcService));
        logger.debug((Object)("value:" + value));
        logger.debug((Object)("strToolContentID:" + strToolContentID));
        McContent mcContent = mcService.retrieveMc(new Long(strToolContentID));
        logger.debug((Object)("mcContent:" + mcContent));
        if (mcContent != null) {
            mcContent.setDefineLater(value);
            logger.debug((Object)("defineLater has been set to:" + value));
            mcService.updateMc(mcContent);
        }
    }

    public static void setFormProperties(HttpServletRequest request, IMcService mcService, McAuthoringForm mcAuthoringForm, McGeneralAuthoringDTO mcGeneralAuthoringDTO, String strToolContentID, String defaultContentIdStr, String activeModule, SessionMap sessionMap, String httpSessionID) {
        logger.debug((Object)"setFormProperties: ");
        logger.debug((Object)("using strToolContentID: " + strToolContentID));
        logger.debug((Object)("using defaultContentIdStr: " + defaultContentIdStr));
        logger.debug((Object)("using activeModule: " + activeModule));
        logger.debug((Object)("using httpSessionID: " + httpSessionID));
        mcAuthoringForm.setHttpSessionID(httpSessionID);
        mcGeneralAuthoringDTO.setHttpSessionID(httpSessionID);
        mcAuthoringForm.setToolContentID(strToolContentID);
        if (defaultContentIdStr != null && defaultContentIdStr.length() > 0) {
            mcAuthoringForm.setDefaultContentIdStr(new Long(defaultContentIdStr).toString());
            mcGeneralAuthoringDTO.setDefaultContentIdStr(new Long(defaultContentIdStr).toString());
        }
        mcAuthoringForm.setActiveModule(activeModule);
        mcGeneralAuthoringDTO.setActiveModule(activeModule);
        String sln = request.getParameter("sln");
        logger.debug((Object)("sln: " + sln));
        mcAuthoringForm.setSln(sln);
        mcGeneralAuthoringDTO.setSln(sln);
        String questionsSequenced = request.getParameter("questionsSequenced");
        logger.debug((Object)("questionsSequenced: " + questionsSequenced));
        mcAuthoringForm.setQuestionsSequenced(questionsSequenced);
        mcGeneralAuthoringDTO.setQuestionsSequenced(questionsSequenced);
        String randomize = request.getParameter("randomize");
        logger.debug((Object)("randomize: " + randomize));
        mcAuthoringForm.setRandomize(randomize);
        mcGeneralAuthoringDTO.setRandomize(randomize);
        String showMarks = request.getParameter("showMarks");
        logger.debug((Object)("showMarks: " + questionsSequenced));
        mcAuthoringForm.setShowMarks(showMarks);
        mcGeneralAuthoringDTO.setShowMarks(showMarks);
        String retries = request.getParameter("retries");
        logger.debug((Object)("retries: " + retries));
        mcAuthoringForm.setRetries(retries);
        mcGeneralAuthoringDTO.setRetries(retries);
        String offlineInstructions = request.getParameter("offlineInstructions");
        logger.debug((Object)("offlineInstructions: " + offlineInstructions));
        mcAuthoringForm.setOfflineInstructions(offlineInstructions);
        mcGeneralAuthoringDTO.setOfflineInstructions(offlineInstructions);
        String onlineInstructions = request.getParameter("onlineInstructions");
        logger.debug((Object)("onlineInstructions: " + onlineInstructions));
        mcAuthoringForm.setOnlineInstructions(onlineInstructions);
        mcGeneralAuthoringDTO.setOnlineInstructions(onlineInstructions);
        String reflect = request.getParameter("reflect");
        logger.debug((Object)("reflect: " + reflect));
        mcAuthoringForm.setReflect(reflect);
        mcGeneralAuthoringDTO.setReflect(reflect);
        String reflectionSubject = request.getParameter("reflectionSubject");
        logger.debug((Object)("reflectionSubject: " + reflectionSubject));
        mcAuthoringForm.setReflectionSubject(reflectionSubject);
        mcGeneralAuthoringDTO.setReflectionSubject(reflectionSubject);
        String passmark = request.getParameter("passmark");
        logger.debug((Object)("passmark: " + passmark));
        mcGeneralAuthoringDTO.setPassMarkValue(passmark);
        logger.debug((Object)("ending setFormProperties with mcAuthoringForm: " + mcAuthoringForm));
        logger.debug((Object)("ending setFormProperties with mcGeneralAuthoringDTO: " + mcGeneralAuthoringDTO));
    }

    public static List moveToDelete(String uuid, List attachmentsList, List deletedAttachmentsList) {
        List deletedList;
        List list = deletedList = deletedAttachmentsList != null ? deletedAttachmentsList : new ArrayList();
        if (attachmentsList != null) {
            Iterator iter = attachmentsList.iterator();
            McUploadedFile attachment = null;
            while (iter.hasNext() && attachment == null) {
                McUploadedFile value = (McUploadedFile)iter.next();
                if (!uuid.equals(value.getUuid())) continue;
                attachment = value;
            }
            if (attachment != null) {
                deletedList.add(attachment);
                attachmentsList.remove(attachment);
            }
        }
        return deletedList;
    }

    public static List moveToDelete(String filename, boolean isOnline, List attachmentsList, List deletedAttachmentsList) {
        List deletedList;
        List list = deletedList = deletedAttachmentsList != null ? deletedAttachmentsList : new ArrayList();
        if (attachmentsList != null) {
            Iterator iter = attachmentsList.iterator();
            McUploadedFile attachment = null;
            while (iter.hasNext() && attachment == null) {
                McUploadedFile value = (McUploadedFile)iter.next();
                if (!filename.equals(value.getFileName()) || isOnline != value.isFileOnline()) continue;
                attachment = value;
            }
            if (attachment != null) {
                deletedList.add(attachment);
                attachmentsList.remove(attachment);
            }
        }
        return deletedList;
    }
}

